/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.server.tasks;

import com.dataiku.dss.shadeliba2a.io.a2a.server.events.EventConsumer;
import com.dataiku.dss.shadeliba2a.io.a2a.server.events.EventQueueItem;
import com.dataiku.dss.shadeliba2a.io.a2a.server.tasks.TaskManager;
import com.dataiku.dss.shadeliba2a.io.a2a.server.util.async.AsyncUtils;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.A2AServerException;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Event;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.EventKind;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.JSONRPCError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Message;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Task;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskState;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskStatusUpdateEvent;
import com.dataiku.dss.shadeliba2a.io.a2a.util.Utils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultAggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultAggregator.class);
    private final TaskManager taskManager;
    private final Executor executor;
    private volatile Message message;

    public ResultAggregator(TaskManager taskManager, Message message, Executor executor) {
        this.taskManager = taskManager;
        this.message = message;
        this.executor = executor;
    }

    public EventKind getCurrentResult() {
        if (this.message != null) {
            return this.message;
        }
        return this.taskManager.getTask();
    }

    public Flow.Publisher<EventQueueItem> consumeAndEmit(EventConsumer consumer) {
        Flow.Publisher<EventQueueItem> allItems = consumer.consumeAll();
        return AsyncUtils.processor(AsyncUtils.createTubeConfig(), allItems, (errorConsumer, item) -> {
            if (!item.isReplicated()) {
                try {
                    this.callTaskManagerProcess(item.getEvent());
                }
                catch (A2AServerException e) {
                    errorConsumer.accept(e);
                    return false;
                }
            }
            return true;
        });
    }

    public EventKind consumeAll(EventConsumer consumer) throws JSONRPCError {
        AtomicReference returnedEvent = new AtomicReference();
        Flow.Publisher<EventQueueItem> allItems = consumer.consumeAll();
        AtomicReference error = new AtomicReference();
        AsyncUtils.consumer(AsyncUtils.createTubeConfig(), allItems, item -> {
            Event event = item.getEvent();
            if (event instanceof Message) {
                Message msg;
                this.message = msg = (Message)event;
                if (returnedEvent.get() == null) {
                    returnedEvent.set(msg);
                    return false;
                }
            }
            if (!item.isReplicated()) {
                try {
                    this.callTaskManagerProcess(event);
                }
                catch (A2AServerException e) {
                    error.set(e);
                    return false;
                }
            }
            return true;
        }, error::set);
        Throwable err = (Throwable)error.get();
        if (err != null) {
            Utils.rethrow(err);
        }
        if (returnedEvent.get() != null) {
            return (EventKind)returnedEvent.get();
        }
        return this.taskManager.getTask();
    }

    public EventTypeAndInterrupt consumeAndBreakOnInterrupt(EventConsumer consumer, boolean blocking) throws JSONRPCError {
        Flow.Publisher<EventQueueItem> allItems = consumer.consumeAll();
        AtomicReference message = new AtomicReference();
        AtomicBoolean interrupted = new AtomicBoolean(false);
        AtomicReference errorRef = new AtomicReference();
        CompletableFuture completionFuture = new CompletableFuture();
        CompletableFuture<Void> consumptionCompletionFuture = new CompletableFuture<Void>();
        CompletableFuture.runAsync(() -> AsyncUtils.consumer(AsyncUtils.createTubeConfig(), allItems, item -> {
            TaskStatusUpdateEvent tsue;
            Task task;
            boolean isAuthRequired;
            TaskStatusUpdateEvent tsue2;
            Task task2;
            Event event = item.getEvent();
            if (event instanceof Throwable) {
                Throwable t = (Throwable)((Object)event);
                errorRef.set(t);
                completionFuture.completeExceptionally(t);
                return false;
            }
            if (event instanceof Message) {
                Message msg;
                this.message = msg = (Message)event;
                message.set(msg);
                completionFuture.complete(null);
                return false;
            }
            if (!item.isReplicated()) {
                try {
                    this.callTaskManagerProcess(event);
                }
                catch (A2AServerException e) {
                    errorRef.set(e);
                    completionFuture.completeExceptionally(e);
                    return false;
                }
            }
            boolean shouldInterrupt = false;
            boolean continueInBackground = false;
            boolean isFinalEvent = event instanceof Task && (task2 = (Task)event).getStatus().state().isFinal() || event instanceof TaskStatusUpdateEvent && (tsue2 = (TaskStatusUpdateEvent)event).isFinal();
            boolean bl = isAuthRequired = event instanceof Task && (task = (Task)event).getStatus().state() == TaskState.AUTH_REQUIRED || event instanceof TaskStatusUpdateEvent && (tsue = (TaskStatusUpdateEvent)event).getStatus().state() == TaskState.AUTH_REQUIRED;
            if (isAuthRequired) {
                shouldInterrupt = true;
                continueInBackground = true;
            } else if (!blocking) {
                shouldInterrupt = true;
                continueInBackground = true;
            } else if (blocking) {
                shouldInterrupt = true;
                continueInBackground = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Blocking call for task {}: {} event, returning with background consumption", (Object)this.taskIdForLogging(), (Object)(isFinalEvent ? "final" : "non-final"));
                }
            }
            if (shouldInterrupt) {
                interrupted.set(true);
                completionFuture.complete(null);
                if (!blocking) {
                    consumptionCompletionFuture.complete(null);
                }
                if (LOGGER.isDebugEnabled()) {
                    String reason = isAuthRequired ? "auth-required" : (blocking ? "blocking" : "non-blocking");
                    LOGGER.debug("Task {}: Continuing background consumption (reason: {})", (Object)this.taskIdForLogging(), (Object)reason);
                }
                return true;
            }
            return true;
        }, throwable -> {
            if (throwable != null) {
                errorRef.set(throwable);
                completionFuture.completeExceptionally((Throwable)throwable);
                consumptionCompletionFuture.completeExceptionally((Throwable)throwable);
            } else {
                completionFuture.complete(null);
                consumptionCompletionFuture.complete(null);
            }
        }), this.executor);
        try {
            completionFuture.join();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                Utils.rethrow(cause);
            }
            throw e;
        }
        Throwable error = (Throwable)errorRef.get();
        if (error != null) {
            Utils.rethrow(error);
        }
        return new EventTypeAndInterrupt(message.get() != null ? (EventKind)message.get() : this.taskManager.getTask(), interrupted.get(), consumptionCompletionFuture);
    }

    private void callTaskManagerProcess(Event event) throws A2AServerException {
        this.taskManager.process(event);
    }

    private String taskIdForLogging() {
        Task task = this.taskManager.getTask();
        return task != null ? task.getId() : "unknown";
    }

    public record EventTypeAndInterrupt(EventKind eventType, boolean interrupted, CompletableFuture<Void> consumptionFuture) {
    }
}

