/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.server.tasks;

import com.dataiku.dss.shadeliba2a.io.a2a.server.agentexecution.RequestContext;
import com.dataiku.dss.shadeliba2a.io.a2a.server.events.EventQueue;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Artifact;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Message;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Part;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskArtifactUpdateEvent;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskState;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskStatus;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskStatusUpdateEvent;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class TaskUpdater {
    private final EventQueue eventQueue;
    private final String taskId;
    private final String contextId;
    private final AtomicBoolean terminalStateReached = new AtomicBoolean(false);
    private final Object stateLock = new Object();

    public TaskUpdater(RequestContext context, EventQueue eventQueue) {
        this.eventQueue = eventQueue;
        this.taskId = context.getTaskId();
        this.contextId = context.getContextId();
    }

    private void updateStatus(TaskState taskState) {
        this.updateStatus(taskState, null, taskState.isFinal());
    }

    public void updateStatus(TaskState taskState, Message message) {
        this.updateStatus(taskState, message, taskState.isFinal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus(TaskState state, Message message, boolean isFinal) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.terminalStateReached.get()) {
                throw new IllegalStateException("Cannot update task status - terminal state already reached");
            }
            if (isFinal) {
                this.terminalStateReached.set(true);
            }
            TaskStatusUpdateEvent event = new TaskStatusUpdateEvent.Builder().taskId(this.taskId).contextId(this.contextId).isFinal(isFinal).status(new TaskStatus(state, message, null)).build();
            this.eventQueue.enqueueEvent(event);
        }
    }

    public String getContextId() {
        return this.contextId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void addArtifact(List<Part<?>> parts) {
        this.addArtifact(parts, null, null, null);
    }

    public void addArtifact(List<Part<?>> parts, String artifactId, String name, Map<String, Object> metadata) {
        this.addArtifact(parts, artifactId, name, metadata, null, null);
    }

    public void addArtifact(List<Part<?>> parts, String artifactId, String name, Map<String, Object> metadata, Boolean append, Boolean lastChunk) {
        if (artifactId == null) {
            artifactId = UUID.randomUUID().toString();
        }
        TaskArtifactUpdateEvent event = new TaskArtifactUpdateEvent.Builder().taskId(this.taskId).contextId(this.contextId).artifact(new Artifact.Builder().artifactId(artifactId).name(name).parts(parts).metadata(metadata).build()).append(append).lastChunk(lastChunk).build();
        this.eventQueue.enqueueEvent(event);
    }

    public void complete() {
        this.complete(null);
    }

    public void complete(Message message) {
        this.updateStatus(TaskState.COMPLETED, message);
    }

    public void fail() {
        this.fail(null);
    }

    public void fail(Message message) {
        this.updateStatus(TaskState.FAILED, message);
    }

    public void submit() {
        this.submit(null);
    }

    public void submit(Message message) {
        this.updateStatus(TaskState.SUBMITTED, message);
    }

    public void startWork() {
        this.startWork(null);
    }

    public void startWork(Message message) {
        this.updateStatus(TaskState.WORKING, message);
    }

    public void cancel() {
        this.cancel(null);
    }

    public void cancel(Message message) {
        this.updateStatus(TaskState.CANCELED, message);
    }

    public void reject() {
        this.reject(null);
    }

    public void reject(Message message) {
        this.updateStatus(TaskState.REJECTED, message);
    }

    public void requiresInput() {
        this.requiresInput(null, false);
    }

    public void requiresInput(Message message) {
        this.requiresInput(message, false);
    }

    public void requiresInput(boolean isFinal) {
        this.requiresInput(null, isFinal);
    }

    public void requiresInput(Message message, boolean isFinal) {
        this.updateStatus(TaskState.INPUT_REQUIRED, message, isFinal);
    }

    public void requiresAuth() {
        this.requiresAuth(null, false);
    }

    public void requiresAuth(Message message) {
        this.requiresAuth(message, false);
    }

    public void requiresAuth(boolean isFinal) {
        this.requiresAuth(null, isFinal);
    }

    public void requiresAuth(Message message, boolean isFinal) {
        this.updateStatus(TaskState.AUTH_REQUIRED, message, isFinal);
    }

    public Message newAgentMessage(List<Part<?>> parts, Map<String, Object> metadata) {
        return new Message.Builder().role(Message.Role.AGENT).taskId(this.taskId).contextId(this.contextId).messageId(UUID.randomUUID().toString()).metadata(metadata).parts(parts).build();
    }
}

