/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.spec;

import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.core.JsonParser;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.core.JsonProcessingException;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.databind.DeserializationContext;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.CancelTaskRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.DeleteTaskPushNotificationConfigRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetAuthenticatedExtendedCardRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetTaskPushNotificationConfigParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetTaskPushNotificationConfigRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetTaskRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.JSONRPCRequestDeserializerBase;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.ListTaskPushNotificationConfigParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.ListTaskPushNotificationConfigRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.MessageSendParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.MethodNotFoundJsonMappingException;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.NonStreamingJSONRPCRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SendMessageRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SetTaskPushNotificationConfigRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskIdParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskPushNotificationConfig;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskQueryParams;
import java.io.IOException;

public class NonStreamingJSONRPCRequestDeserializer
extends JSONRPCRequestDeserializerBase<NonStreamingJSONRPCRequest<?>> {
    public NonStreamingJSONRPCRequestDeserializer() {
        this((Class<?>)null);
    }

    public NonStreamingJSONRPCRequestDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public NonStreamingJSONRPCRequest<?> deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode treeNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String jsonrpc = this.getAndValidateJsonrpc(treeNode, jsonParser);
        String method = this.getAndValidateMethod(treeNode, jsonParser);
        Object id = this.getAndValidateId(treeNode, jsonParser);
        JsonNode paramsNode = treeNode.get("params");
        switch (method) {
            case "tasks/get": {
                return new GetTaskRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, TaskQueryParams.class));
            }
            case "tasks/cancel": {
                return new CancelTaskRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, TaskIdParams.class));
            }
            case "tasks/pushNotificationConfig/set": {
                return new SetTaskPushNotificationConfigRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, TaskPushNotificationConfig.class));
            }
            case "tasks/pushNotificationConfig/get": {
                return new GetTaskPushNotificationConfigRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, GetTaskPushNotificationConfigParams.class));
            }
            case "message/send": {
                return new SendMessageRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, MessageSendParams.class));
            }
            case "tasks/pushNotificationConfig/list": {
                return new ListTaskPushNotificationConfigRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, ListTaskPushNotificationConfigParams.class));
            }
            case "tasks/pushNotificationConfig/delete": {
                return new DeleteTaskPushNotificationConfigRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, DeleteTaskPushNotificationConfigParams.class));
            }
            case "agent/getAuthenticatedExtendedCard": {
                return new GetAuthenticatedExtendedCardRequest(jsonrpc, id, method, this.getAndValidateParams(paramsNode, jsonParser, treeNode, Void.class));
            }
        }
        throw new MethodNotFoundJsonMappingException("Invalid method", this.getIdIfPossible(treeNode, jsonParser));
    }
}

