/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.mutiny.zero;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public interface AsyncHelpers {
    public static <T> CompletionStage<T> applyExceptionally(CompletionStage<T> upstream, Function<Throwable, Throwable> mapper) {
        Objects.requireNonNull(mapper, "The mapper cannot be null");
        CompletableFuture future = new CompletableFuture();
        upstream.whenComplete((res, failure) -> {
            if (failure == null) {
                future.complete(res);
            } else {
                Throwable throwable;
                try {
                    throwable = Objects.requireNonNull((Throwable)mapper.apply((Throwable)failure));
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                    return;
                }
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    public static <T> CompletionStage<T> composeExceptionally(CompletionStage<T> upstream, Function<Throwable, CompletionStage<T>> mapper) {
        Objects.requireNonNull(mapper, "The mapper cannot be null");
        CompletableFuture future = new CompletableFuture();
        upstream.whenComplete((res, failure) -> {
            if (failure == null) {
                future.complete(res);
            } else {
                CompletionStage cs;
                try {
                    cs = Objects.requireNonNull((CompletionStage)mapper.apply((Throwable)failure));
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                    return;
                }
                cs.whenComplete((result, err) -> {
                    if (err != null) {
                        future.completeExceptionally((Throwable)err);
                    } else {
                        future.complete(result);
                    }
                });
            }
        });
        return future;
    }
}

