/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.mutiny.zero;

import com.dataiku.dss.shadeliba2a.mutiny.zero.BackpressureStrategy;
import com.dataiku.dss.shadeliba2a.mutiny.zero.Tube;
import com.dataiku.dss.shadeliba2a.mutiny.zero.TubeConfiguration;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.CompletionStagePublisher;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.EmptyPublisher;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.FailurePublisher;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.GeneratorPublisher;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.IterablePublisher;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.PublisherToCompletionStageSubscriber;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.StreamPublisher;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.TubePublisher;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface ZeroPublisher {
    @SafeVarargs
    public static <T> Flow.Publisher<T> fromItems(T ... items) {
        Objects.requireNonNull(items, "The items array cannot be null");
        return ZeroPublisher.fromIterable(Arrays.asList(items));
    }

    public static <T> Flow.Publisher<T> fromIterable(Iterable<T> iterable) {
        Objects.requireNonNull(iterable, "The iterable cannot be null");
        return new IterablePublisher<T>(iterable);
    }

    public static <T> Flow.Publisher<T> fromStream(Supplier<Stream<T>> supplier) {
        Objects.requireNonNull(supplier, "The supplier cannot be null");
        return new StreamPublisher<T>(supplier);
    }

    public static <S, T> Flow.Publisher<T> fromGenerator(Supplier<S> stateSupplier, Function<S, Iterator<T>> generator) {
        Objects.requireNonNull(stateSupplier, "The state supplier cannot be null");
        Objects.requireNonNull(generator, "The generator supplier cannot be null");
        return new GeneratorPublisher<S, T>(stateSupplier, generator);
    }

    public static <T> Flow.Publisher<T> fromCompletionStage(Supplier<CompletionStage<T>> completionStageSupplier) {
        Objects.requireNonNull(completionStageSupplier, "The CompletionStage supplier cannot be null");
        return new CompletionStagePublisher<T>(completionStageSupplier);
    }

    public static <T> CompletionStage<Optional<T>> toCompletionStage(Flow.Publisher<T> publisher) {
        Objects.requireNonNull(publisher, "The publisher cannot be null");
        CompletableFuture future = new CompletableFuture();
        publisher.subscribe(new PublisherToCompletionStageSubscriber(future));
        return future;
    }

    public static <T> Flow.Publisher<T> fromFailure(Throwable failure) {
        Objects.requireNonNull(failure, "The failure cannot be null");
        return new FailurePublisher(failure);
    }

    public static <T> Flow.Publisher<T> empty() {
        return new EmptyPublisher();
    }

    public static <T> Flow.Publisher<T> create(TubeConfiguration configuration, Consumer<Tube<T>> tubeConsumer) {
        Objects.requireNonNull(configuration.getBackpressureStrategy(), "The backpressure strategy cannot be null");
        Objects.requireNonNull(tubeConsumer, "The tube consumer cannot be null");
        if ((configuration.getBackpressureStrategy() == BackpressureStrategy.BUFFER || configuration.getBackpressureStrategy() == BackpressureStrategy.LATEST) && configuration.getBufferSize() <= 0) {
            throw new IllegalArgumentException("The buffer size must be strictly positive");
        }
        return new TubePublisher<T>(configuration, tubeConsumer);
    }
}

