/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.hive.executor;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRow;
import com.dataiku.dip.output.BasicCSVOutputFormatter;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.WithParams;
import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.ExecutionQuery;
import com.dataiku.hproxy.model.hive.ExecutionQueryParams;
import com.dataiku.hproxy.model.hive.ExecutionResults;
import com.dataiku.hproxy.model.hive.QueryStatus;
import com.dataiku.hproxy.model.hive.ResultCount;
import com.dataiku.hproxy.server.Context;
import com.dataiku.hproxy.server.hive.executor.DebugQueryHandler;
import com.dataiku.hproxy.server.hive.executor.HiveLoaderPool;
import com.dataiku.hproxy.server.hive.executor.IQueryHandler;
import com.dataiku.hproxy.server.hive.executor.QueryHandler;
import com.dataiku.hproxy.server.hive.executor.SeparateClassLoaderExecutor;
import com.dataiku.hproxy.server.hive.executor.SessionHandler;
import com.dataiku.hproxy.server.hive.executor.SessionHandlerPool;
import com.dataiku.hproxy.server.utils.IdGenerator;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class Manager {
    private SeparateClassLoaderExecutor classLoaderExecutor;
    private HiveLoaderPool hiveLoaderPool;
    private ScheduledExecutorService bkgThread = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("HiveExecMgrBkg-%d").build());
    private ExecutorService threads = Executors.newFixedThreadPool(10, new ThreadFactoryBuilder().setNameFormat("HiveExecMgr-%d").build());
    private HashMap<String, IQueryHandler> queries = new HashMap();
    private static Logger logger = Logger.getLogger(Manager.class);
    private Context ctx;

    public Manager(Context ctx) {
        this.ctx = ctx;
        try {
            logger.info((Object)"Create new Hive ClassLoader");
            URLClassLoader hiveClassLoader = this.ctx.getClassLoaderPool().requireNew("hive", "sandbox", "hive-additional");
            this.classLoaderExecutor = new SeparateClassLoaderExecutor(hiveClassLoader, "HiveExecLoaderCreation");
            logger.info((Object)"Create new pool of hiveloaders and populate with common variants");
            this.hiveLoaderPool = new HiveLoaderPool(hiveClassLoader, ctx, this.classLoaderExecutor);
            for (boolean forceMR : new boolean[]{true, false}) {
                this.hiveLoaderPool.getHiveLoader(new ExecutionQueryParams(forceMR));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initalize Hive", e);
        }
        this.bkgThread.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Manager.this.gcIdleQueries();
            }
        }, 500L, 1000L, TimeUnit.MILLISECONDS);
        logger.info((Object)"Started manager");
    }

    private synchronized void gcIdleQueries() {
        ArrayList<String> toBeKilled = new ArrayList<String>();
        long now = System.currentTimeMillis();
        for (Map.Entry<String, IQueryHandler> q : this.queries.entrySet()) {
            long lastUsedTime;
            long inactivityPeriod;
            long maxIdleTime;
            IQueryHandler qh = q.getValue();
            if (qh.getState() == QueryStatus.HiveQueryState.READY_TO_EXECUTE || qh.getState() == QueryStatus.HiveQueryState.EXECUTING_QUERY || qh.isFetching() || (maxIdleTime = qh.getMaxIdleTime()) == -1L || (inactivityPeriod = now - (lastUsedTime = qh.getLastUsedTime())) <= maxIdleTime) continue;
            logger.info((Object)("Query [" + q.getKey() + "] expired (" + inactivityPeriod + " ms > " + maxIdleTime + " ms)"));
            toBeKilled.add(q.getKey());
        }
        for (final String id : toBeKilled) {
            this.threads.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Manager.this.removeQuery(id);
                    return null;
                }
            });
        }
    }

    public synchronized void setMaxIdleTime(String id, long time) {
        IQueryHandler qh = this.getUpdatedHandler(id);
        qh.setMaxIdleTime(time);
    }

    public synchronized boolean keepAlive(String id) {
        IQueryHandler qh = this.queries.get(id);
        if (qh != null) {
            qh.updateLastUsedTime();
            return true;
        }
        return false;
    }

    public synchronized String newQuery(ExecutionQuery query) throws Exception {
        IQueryHandler handle;
        String identifier = IdGenerator.generate();
        logger.info((Object)("Start a query with " + query.params.toString()));
        logger.info((Object)("User query is : " + query.userQuery));
        if (query.userQuery.trim().toUpperCase().startsWith("__DKU_SESSION_MGMT__")) {
            logger.info((Object)"Found a hproxy management query");
            handle = this.handleDebugQuery(query, identifier);
        } else {
            SessionHandlerPool sessionHandlers = this.hiveLoaderPool.getSessionHandlers(query.params);
            handle = new QueryHandler(sessionHandlers.take(query.initQueries), query, identifier);
        }
        this.queries.put(identifier, handle);
        handle.startExecution();
        return identifier;
    }

    private IQueryHandler handleDebugQuery(ExecutionQuery query, String identifier) throws Exception {
        DebugQueryHandler handle;
        String[] tokens = query.userQuery.trim().toUpperCase().split("\\s+");
        if (tokens.length >= 2 && "LIST_QUERIES".equalsIgnoreCase(tokens[1])) {
            handle = new DebugQueryHandler(identifier, query, this.getQueriesList());
        } else if (tokens.length >= 2 && "LIST_SESSIONS".equalsIgnoreCase(tokens[1])) {
            handle = new DebugQueryHandler(identifier, query, this.hiveLoaderPool.getSessionHandlers(query.params).listHandlers());
        } else if (tokens.length >= 3 && "KILL_QUERY".equalsIgnoreCase(tokens[1])) {
            IQueryHandler queryToKill = this.getHandler(tokens[2]);
            queryToKill.kill();
            handle = new DebugQueryHandler(identifier, query, "query killed");
        } else if (tokens.length >= 3 && "DESTROY_SESSION".equalsIgnoreCase(tokens[1])) {
            SessionHandlerPool sessionHandlers = this.hiveLoaderPool.getSessionHandlers(query.params);
            SessionHandler sessionToKill = sessionHandlers.getHandler(tokens[2]);
            if (sessionToKill != null) {
                sessionToKill.destroy();
                handle = new DebugQueryHandler(identifier, query, "session killed");
            } else {
                handle = new DebugQueryHandler(identifier, query, "session not found");
            }
        } else {
            handle = new DebugQueryHandler(identifier, query, "command not understood. Use any of:", "LIST_QUERIES", "LIST_SESSIONS", "KILL_QUERY queryId", "DESTROY_SESSION sessionId");
        }
        return handle;
    }

    private ExecutionResults getQueriesList() {
        ExecutionResults ret = new ExecutionResults();
        ret.columns.add(new ColumnSchema().withName("identifier").withType("string"));
        ret.columns.add(new ColumnSchema().withName("state").withType("string"));
        ret.columns.add(new ColumnSchema().withName("start").withType("date"));
        for (Map.Entry<String, IQueryHandler> query : this.queries.entrySet()) {
            String start = DKUtils.isoFormatReadableByDateFormat((long)query.getValue().getStartTime());
            ArrayList row = Lists.newArrayList();
            row.add(query.getKey());
            row.add(query.getValue().getState().name());
            row.add(start);
            ret.rows.add(row.toArray(new String[0]));
        }
        return ret;
    }

    public synchronized void stopManager() {
        this.bkgThread.shutdown();
        this.threads.shutdown();
        this.classLoaderExecutor.shutdown();
        for (Map.Entry<String, IQueryHandler> q : this.queries.entrySet()) {
            q.getValue().kill();
        }
        logger.info((Object)"Stopped manager");
    }

    private synchronized IQueryHandler getUpdatedHandler(String id) {
        IQueryHandler handler = this.getHandler(id);
        handler.update();
        return handler;
    }

    private synchronized IQueryHandler getHandler(String id) {
        IQueryHandler handler = this.queries.get(id);
        if (handler == null) {
            throw new RuntimeException("Query identifier \"" + id + "\" doesn't exist");
        }
        return handler;
    }

    public synchronized String getLogTail(String queryIdentifier) {
        IQueryHandler handler = this.getUpdatedHandler(queryIdentifier);
        return handler.getLogTail();
    }

    public synchronized Future<ExecutionResults> fetchResult(String identifier, long offset, long limit) {
        return this.getUpdatedHandler(identifier).fetchResult(offset, limit);
    }

    public synchronized boolean isAlive(String id) {
        return this.queries.get(id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryStatus waitForCompletion(String id, long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        IQueryHandler qh = this.getUpdatedHandler(id);
        QueryStatus.HiveQueryState hqs = qh.waitForNextState(100L);
        boolean timeoutElapsed = false;
        while (hqs != QueryStatus.HiveQueryState.DEAD && hqs != QueryStatus.HiveQueryState.COMPLETE && hqs != QueryStatus.HiveQueryState.READY_TO_FETCH) {
            long now = System.currentTimeMillis();
            long elapsed = now - start;
            long remaining = timeout - elapsed;
            if (timeout > 0L && remaining <= 0L) {
                timeoutElapsed = true;
                break;
            }
            qh = this.getUpdatedHandler(id);
            hqs = qh.waitForNextState(1000L);
        }
        Manager manager = this;
        synchronized (manager) {
            QueryStatus desc = new QueryStatus();
            desc.id = id;
            desc.query = qh.getQuery();
            desc.state = qh.getState();
            String deathReason = qh.getDeathReason();
            if (deathReason == null && timeoutElapsed) {
                deathReason = "Timeout elapsed";
            }
            desc.errorMessage = deathReason;
            desc.idleTimeout = qh.getMaxIdleTime();
            return desc;
        }
    }

    public synchronized QueryStatus getStatus(String id) {
        IQueryHandler qh = this.getUpdatedHandler(id);
        QueryStatus desc = new QueryStatus();
        desc.id = id;
        desc.query = qh.getQuery();
        desc.state = qh.getState();
        desc.errorMessage = qh.getDeathReason();
        desc.idleTimeout = qh.getMaxIdleTime();
        return desc;
    }

    public synchronized List<QueryStatus> listQueries() {
        ArrayList<QueryStatus> list = new ArrayList<QueryStatus>();
        for (String id : this.queries.keySet()) {
            list.add(this.getStatus(id));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeQuery(String identifier) {
        IQueryHandler handler = null;
        Manager manager = this;
        synchronized (manager) {
            if (this.queries.get(identifier) != null) {
                handler = this.getHandler(identifier);
                this.queries.remove(identifier);
            }
        }
        if (handler != null) {
            handler.kill();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseQuery(String identifier) {
        IQueryHandler handler = null;
        Manager manager = this;
        synchronized (manager) {
            if (this.queries.get(identifier) != null) {
                handler = this.getHandler(identifier);
            }
        }
        if (handler != null) {
            handler.release();
            return true;
        }
        return false;
    }

    public synchronized boolean isFetchable(String id) {
        IQueryHandler qh = this.getUpdatedHandler(id);
        return qh.getState() == QueryStatus.HiveQueryState.READY_TO_FETCH;
    }

    public synchronized Future<Long> fetchRaw(final String id, final OutputStream stream) {
        return this.threads.submit(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                IQueryHandler handler = Manager.this.getHandler(id);
                if (handler.getState() != QueryStatus.HiveQueryState.READY_TO_FETCH) {
                    throw new RuntimeException("Results cannot be fetched");
                }
                ArrayList<Column> cols = new ArrayList<Column>();
                StreamColumnFactory factory = new StreamColumnFactory();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("separator", ",");
                params.put("parseHeaderRow", "false");
                BasicCSVOutputFormatter csv = new BasicCSVOutputFormatter(new WithParams(params, ""));
                long currentPosition = 0L;
                long chunkSize = 5000L;
                BufferedOutputStream buffered = new BufferedOutputStream(stream);
                OutputStreamWriter writer = new OutputStreamWriter(buffered);
                boolean initialized = false;
                while (true) {
                    handler = Manager.this.getUpdatedHandler(id);
                    ExecutionResults res = handler.fetchResult(currentPosition, chunkSize).get();
                    if (res.rows.size() == 0) break;
                    if (!initialized) {
                        for (int i = 0; i < res.columns.size(); ++i) {
                            cols.add(factory.column("c" + i));
                        }
                        csv.header((ColumnFactory)factory, (Writer)writer);
                        initialized = true;
                    }
                    for (String[] row : res.rows) {
                        StreamRow srow = new StreamRow();
                        for (int i = 0; i < row.length; ++i) {
                            srow.put((Column)cols.get(i), row[i]);
                        }
                        csv.format((Row)srow, (ColumnFactory)factory, (Writer)writer);
                    }
                    currentPosition += (long)res.rows.size();
                    Thread.yield();
                }
                writer.flush();
                return currentPosition;
            }
        });
    }

    public synchronized Future<ResultCount> countResults(final String id, final long requestedLimit) {
        long chunckSize = 100000L;
        long maxAllowed = 9223372036854575806L;
        final long limit = Math.min(9223372036854575806L, requestedLimit);
        return this.threads.submit(new Callable<ResultCount>(){

            @Override
            public ResultCount call() throws Exception {
                IQueryHandler qh = Manager.this.getHandler(id);
                if (9223372036854575806L <= requestedLimit) {
                    qh.injectLogMessage("Counting all rows...\n");
                } else {
                    qh.injectLogMessage("Counting rows (max " + limit + ")...\n");
                }
                long currentLimit = qh.getLowerBoundOnCount().get();
                logger.info((Object)("[" + qh.getIdentifier() + "] Lower bound on result count : " + currentLimit));
                while (true) {
                    qh = Manager.this.getHandler(id);
                    ResultCount rc = qh.countResults(currentLimit).get();
                    if (rc.count > limit) {
                        qh.injectLogMessage("Found more than " + limit + " rows \n");
                        return new ResultCount(limit, true);
                    }
                    if (!rc.hasMore) {
                        qh.injectLogMessage("Found " + rc.count + " rows \n");
                        return rc;
                    }
                    currentLimit = Math.min(currentLimit + 100000L, limit + 1L);
                    Thread.yield();
                }
            }
        });
    }
}

