/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hadoop.azure;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;
import org.apache.hadoop.security.AccessControlException;

class FixedSASTokenProvider
implements SASTokenProvider {
    private Configuration configuration;

    FixedSASTokenProvider() {
    }

    public String getSASToken(String accountName, String fileSystem, String path, String operation) throws IOException, AccessControlException {
        Objects.requireNonNull(accountName, "accountName must not be null");
        String account = this.configuration.get("dataiku.fixed.sas.account");
        String fixedTokenConfig = "fs.azure.sas.fixed.token" + account;
        String fixedToken = this.configuration.get(fixedTokenConfig);
        if (fixedToken == null) {
            throw new AccessControlException(String.format("SAS token isn't defined (no property '%s').", fixedTokenConfig));
        }
        return fixedToken;
    }

    public void initialize(Configuration configuration, String accountName) throws IOException {
        Objects.requireNonNull(configuration, "configuration must not be null");
        this.configuration = configuration;
    }
}

