/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class HiveUtils {
    public static String stripComments(String script) {
        StringBuilder builder = new StringBuilder();
        Pattern p = Pattern.compile("^\\s*--");
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(script));
            while ((line = reader.readLine()) != null) {
                if (!p.matcher(line).find()) {
                    builder.append(line + "\n");
                    continue;
                }
                builder.append("\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.toString();
    }

    public static List<String> splitCommandsRemoveEscaping(String script) {
        Object currentCommand = "";
        ArrayList<String> lines = new ArrayList<String>();
        for (String oneCmd : HiveUtils.stripComments(script).split(";")) {
            if (oneCmd.endsWith("\\")) {
                currentCommand = (String)currentCommand + StringUtils.chop((String)oneCmd) + ";";
                continue;
            }
            if (StringUtils.isBlank((String)(currentCommand = (String)currentCommand + oneCmd))) continue;
            Object command = currentCommand;
            currentCommand = "";
            if (StringUtils.isBlank((String)command)) continue;
            lines.add((String)command);
        }
        return lines;
    }

    public static List<String> splitCommandsPreserveEscaping(String script) {
        Object currentCommand = "";
        ArrayList<String> lines = new ArrayList<String>();
        for (String oneCmd : HiveUtils.stripComments(script).split(";")) {
            if (oneCmd.endsWith("\\")) {
                currentCommand = (String)currentCommand + oneCmd + ";";
                continue;
            }
            if (StringUtils.isBlank((String)(currentCommand = (String)currentCommand + oneCmd))) continue;
            Object command = currentCommand;
            currentCommand = "";
            if (StringUtils.isBlank((String)command)) continue;
            lines.add((String)command);
        }
        return lines;
    }

    public static String removeTrailingSemicolons(String s) {
        return s.replaceAll("[;\\s]*$", "");
    }
}

