/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.admin;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.APIIllegalArgumentException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.utils.CollectionUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.LambdaAPICodes;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.auth.ApiNodeAuthVerificationService;
import com.dataiku.lambda.model.serverconfig.EndpointServerSideConfig;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.LambdaServiceGenTag;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import com.dataiku.lambda.services.ServiceManager;
import com.dataiku.lambda.services.ServicesService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ServicesAdminController
extends LambdaAPIControllerBase {
    @Autowired
    private ApiNodeAuthVerificationService authService;
    @Autowired
    private ServicesService servicesService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private LambdaContext lambdaContext;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.admin.api");

    @AuditedCall(value={"msgType", "api-services-list"})
    @RequestMapping(value={"/admin/api/services"}, method={RequestMethod.GET})
    public void listServices(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        ServicesAdminController.writeJSON(resp, this.servicesService.listServices());
    }

    @RequestMapping(value={"/admin/api/services"}, method={RequestMethod.POST})
    public void createService(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false, defaultValue="false") boolean ignoreIfExists) throws Exception {
        this.authService.checkAdmin(req);
        ProtoService pservice = (ProtoService)JSON.parse((InputStream)req.getInputStream(), ProtoService.class);
        if (pservice == null || StringUtils.isBlank((String)pservice.serviceId)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)LambdaAPICodes.ERR_APINODE_BAD_SERVICE_CREATION_CALL, "No service id");
        }
        if (ignoreIfExists && this.servicesService.getServiceManager(pservice.serviceId) != null) {
            this.writeSimpleOK(resp);
            return;
        }
        this.servicesService.createService(pservice.serviceId);
        this.writeSimpleOK(resp);
        this.auditTrailService.generic("api-service-create").with("serviceId", pservice.serviceId).emit();
    }

    @AuditedCall(value={"msgType", "api-service-delete", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/admin/api/services/{serviceId:.+}"}, method={RequestMethod.DELETE})
    public void deleteService(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        this.authService.checkAdmin(req);
        logger.info((Object)"Disabling the service");
        this.servicesService.disableServiceNoFail(serviceId);
        logger.info((Object)"Destroying the service");
        this.servicesService.destroyService(serviceId);
        this.writeSimpleOK(resp);
    }

    @AuditedCall(value={"msgType", "api-service-list-generations", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/admin/api/services/{serviceId}/generations"}, method={RequestMethod.GET})
    public void listAvailableGenerations(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        this.authService.checkAdmin(req);
        List<LambdaServiceGenTag.WithStatus> generations = this.servicesService.getGenerations(serviceId);
        ServicesAdminController.writeJSONString((HttpServletResponse)resp, (String)("{\"generations\":" + JSON.json(generations) + "}"));
    }

    @AuditedCall(value={"msgType", "api-service-import", "serviceId", "${serviceId}", "source", "file", "filePath", "${filePath}"})
    @RequestMapping(value={"/admin/api/services/{serviceId}/generations/actions/importFromArchive"}, method={RequestMethod.POST})
    public void importGenerationFromArchive(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @RequestParam String filePath) throws Exception {
        this.authService.checkAdmin(req);
        this.servicesService.importGenerationFromArchive(serviceId, new File(filePath));
        this.writeSimpleOK(resp);
    }

    @AuditedCall(value={"msgType", "api-service-import", "serviceId", "${serviceId}", "source", "dir", "dirPath", "${dirPath}"})
    @RequestMapping(value={"/admin/api/services/{serviceId}/generations/actions/importFromDirectory"}, method={RequestMethod.POST})
    public void importGenerationFromDirectory(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @RequestParam String dirPath) throws Exception {
        this.authService.checkAdmin(req);
        this.servicesService.importGenerationFromDir(serviceId, new File(dirPath));
        this.writeSimpleOK(resp);
    }

    @AuditedCall(value={"msgType", "api-service-import", "serviceId", "${serviceId}", "source", "stream"})
    @RequestMapping(value={"/admin/api/services/{serviceId}/generations/actions/importFromStream"}, method={RequestMethod.POST})
    public void importGenerationFromStream(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        this.authService.checkAdmin(req);
        logger.info((Object)("Importing generation from upload stream: " + filePart.getOriginalFilename()));
        this.servicesService.importGenerationFromStream(serviceId, filePart.getInputStream());
        this.writeSimpleOK(resp);
    }

    @AuditedCall(value={"msgType", "api-service-preload", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/admin/api/services/{serviceId}/generations/{generationId}/preload"}, method={RequestMethod.POST})
    public void preloadGeneration(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String generationId, @RequestParam(required=false) boolean forceRebuildCodeEnvs) throws Exception {
        this.authService.checkAdmin(req);
        this.servicesService.preloadGeneration(serviceId, generationId, forceRebuildCodeEnvs);
        this.writeSimpleOK(resp);
    }

    @AuditedCall(value={"msgType", "api-service-disable", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/admin/api/services/{serviceId}/actions/disable"}, method={RequestMethod.POST})
    public void disableService(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        this.authService.checkAdmin(req);
        this.servicesService.disableService(serviceId);
        this.writeSimpleOK(resp);
    }

    @AuditedCall(value={"msgType", "api-service-enable", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/admin/api/services/{serviceId}/actions/enable"}, method={RequestMethod.POST})
    public void enableService(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        this.authService.checkAdmin(req);
        this.servicesService.enableService(serviceId);
        this.writeSimpleOK(resp);
    }

    @AuditInline
    @RequestMapping(value={"/admin/api/services/{serviceId}/actions/setMapping"}, method={RequestMethod.POST})
    public void setMapping(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        this.authService.checkAdmin(req);
        GenerationsMapping mapping = (GenerationsMapping)JSON.parse((InputStream)req.getInputStream(), GenerationsMapping.class);
        Validate.notNull((Object)mapping);
        this.servicesService.setMapping(serviceId, mapping);
        this.writeSimpleOK(resp);
        this.auditTrailService.generic("api-service-set-mapping").with("serviceId", serviceId).with("used-mapping", JSON.json((Object)mapping)).emit();
    }

    @AuditInline
    @RequestMapping(value={"/admin/api/services/{serviceId}/actions/switchToNewest"}, method={RequestMethod.POST})
    public void switchToNewest(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        this.authService.checkAdmin(req);
        String usedGeneration = this.servicesService.switchToNewestGeneration(serviceId);
        ServicesAdminController.writeJSON(resp, CollectionUtils.appendableSSMap().put("switchedToGeneration", usedGeneration).get());
        this.auditTrailService.generic("api-service-switch-to-newest").with("serviceId", serviceId).with("used-switchedToGeneration", usedGeneration).emit();
    }

    @AuditInline
    @RequestMapping(value={"/admin/api/services/{serviceId}/actions/switchTo/{generationId:.+}"}, method={RequestMethod.POST})
    public void switchToGeneration(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String generationId) throws Exception {
        this.authService.checkAdmin(req);
        this.servicesService.switchToSingleGeneration(serviceId, generationId);
        this.writeSimpleOK(resp);
        this.auditTrailService.generic("api-service-switch-to-generation").with("serviceId", serviceId).with("used-switchedToGeneration", generationId).emit();
    }

    @AuditedCall(value={"msgType", "api-service-delete-generation", "serviceId", "${serviceId}", "generationId", "${generationId}"})
    @RequestMapping(value={"/admin/api/services/{serviceId}/generations/{generationId:.+}"}, method={RequestMethod.DELETE})
    public void deleteGeneration(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String generationId) throws Exception {
        this.authService.checkAdmin(req);
        this.servicesService.destroyGeneration(serviceId, generationId);
        this.writeSimpleOK(resp);
    }

    @AuditedCall(value={"msgType", "api-service-list-generations", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/admin/api/services/{serviceId}/mapping"}, method={RequestMethod.GET})
    public void getCurrentMapping(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        this.authService.checkAdmin(req);
        ServicesAdminController.writeJSON(resp, this.servicesService.getServiceManagerCheck(serviceId).getCurrentGenerationsMapping());
    }

    @AuditedCall(value={"msgType", "api-service-set-not-alive", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/admin/api/services/{serviceId}/actions/setNotAlive"}, method={RequestMethod.POST})
    public void setNotAlive(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        this.authService.checkAdmin(req);
        ServiceManager sm = this.servicesService.getServiceManagerCheck(serviceId);
        sm.setNotAlive();
        this.writeSimpleOK(resp);
    }

    @AuditedCall(value={"msgType", "api-service-set-not-alive", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/admin/api/services/{serviceId}/actions/setAlive"}, method={RequestMethod.POST})
    public void setAlive(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        this.authService.checkAdmin(req);
        ServiceManager sm = this.servicesService.getServiceManagerCheck(serviceId);
        sm.setAlive();
        this.writeSimpleOK(resp);
    }

    @AuditedCall(value={"msgType", "api-service-reset-endpoint-settings", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/admin/api/services/{serviceId}/actions/reset-endpoints-settings"}, method={RequestMethod.POST})
    public void resetEndpointsSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        this.authService.checkAdmin(req);
        File serviceFolder = this.lambdaContext.getFile(new String[]{"config/services", serviceId});
        if (!DKUFileUtils.isWithin((File)this.lambdaContext.getFile(new String[]{"config/services"}), (File)serviceFolder)) {
            throw new DKUSecurityException("Invalid file");
        }
        if (serviceFolder.exists()) {
            DKUFileUtils.forceDelete((File)serviceFolder);
        }
        this.writeSimpleOK(resp);
    }

    @AuditedCall(value={"msgType", "api-service-set-endpoint-settings", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/admin/api/services/{serviceId}/endpoints/{endpointId}/settings"}, method={RequestMethod.POST})
    public void setEndpointSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String endpointId) throws Exception {
        this.authService.checkAdmin(req);
        File epServerConfig = this.lambdaContext.getFile(new String[]{"config/services", serviceId, endpointId + ".json"});
        if (!DKUFileUtils.isWithin((File)this.lambdaContext.getFile(new String[]{"config/services"}), (File)epServerConfig)) {
            throw new DKUSecurityException("Invalid file");
        }
        EndpointServerSideConfig essc = (EndpointServerSideConfig)this.getRequestBodyAs(req, EndpointServerSideConfig.class);
        JSON.prettyToFile((Object)essc, (File)epServerConfig);
        this.writeSimpleOK(resp);
    }

    @AuditedCall(value={"msgType", "api-service-clean-unused"})
    @RequestMapping(value={"/admin/api/services-clean-unused"}, method={RequestMethod.DELETE})
    public void cleanUnused(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        ServicesAdminController.writeJSON(resp, this.servicesService.cleanUnused());
    }

    static class ProtoService {
        String serviceId;

        ProtoService() {
        }
    }
}

