/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.controllers;

import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.auth.AuthVerificationService;
import com.dataiku.lambda.controllers.RequestMetadata;
import com.dataiku.lambda.endpoints.LambdaEndpointHandler;
import com.dataiku.lambda.endpoints.functioncommon.FunctionEndpointHandlerBase;
import com.dataiku.lambda.endpoints.predictcommon.PredictionEndpointHandlerBase;
import com.dataiku.lambda.endpoints.pyfunction.PyFunctionEndpointHandler;
import com.dataiku.lambda.model.api.FunctionResponse;
import com.dataiku.lambda.model.api.MultiplePredictionQuery;
import com.dataiku.lambda.model.api.PredictionQueryDispatch;
import com.dataiku.lambda.model.api.PredictionResponse;
import com.dataiku.lambda.model.api.ResponseElements;
import com.dataiku.lambda.model.api.SinglePredictionQuery;
import com.dataiku.lambda.model.api.SinglePredictionResponse;
import com.dataiku.lambda.model.api.SnowparkQuery;
import com.dataiku.lambda.model.api.SnowparkResponse;
import com.dataiku.lambda.model.api.VertexAIQuery;
import com.dataiku.lambda.model.api.VertexAIResponse;
import com.dataiku.lambda.model.serverconfig.QueryAPIKey;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import com.dataiku.lambda.services.ServiceManager;
import com.dataiku.lambda.services.ServicesService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class FullyManagedEndpointsController
extends LambdaAPIControllerBase {
    @Autowired
    private LambdaContext lambdaContext;
    @Autowired
    private ServicesService serviceService;
    @Autowired
    private AuthVerificationService authService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/public/api/v1/sagemaker/invocations"}, method={RequestMethod.POST})
    public void execInvocations(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        block19: {
            ServiceManager manager = this.serviceService.getUniqueServiceManagerCheckExistence();
            this.authService.checkAuth(manager.getServiceId(), manager.getConfig(), req);
            QueryAPIKey apiKey = this.authService.getApiKeyForInternalCalls(manager.getServiceId(), manager.getConfig(), req);
            boolean isRequestMetadataEnabled = this.lambdaContext.getMandatoryConfig().isRequestMetadataEnabled;
            RequestMetadata requestMetadata = RequestMetadata.extractFrom(req, isRequestMetadataEnabled);
            JsonElement jsonReq = (JsonElement)this.getRequestBodyAs(req, JsonElement.class);
            PredictionQueryDispatch dispatch = (PredictionQueryDispatch)JSON.parse((JsonElement)jsonReq.getAsJsonObject().get("dispatch"), PredictionQueryDispatch.class);
            String endpointId = this.serviceService.readState((String)manager.getServiceId()).mainEndpointId;
            if (StringUtils.isEmpty((CharSequence)endpointId)) {
                throw ErrorContext.ice((String)("Main endpoint id has not been defined in the service " + manager.getServiceId()));
            }
            ServiceManager.RefcountedEndpoint re = manager.acquireEndpoint(endpointId, dispatch);
            LambdaEndpointHandler<?> handler = re.getHandler();
            ResponseElements.Context context = handler.newContext();
            try (ErrorContext.ACNDC c1 = ErrorContext.pushWithNDC((String)("svc:" + context.serviceId));
                 ErrorContext.ACNDC c2 = ErrorContext.pushWithNDC((String)("ep:" + context.endpointId));){
                try {
                    if (handler instanceof PredictionEndpointHandlerBase) {
                        long startTimeN = System.nanoTime();
                        MultiplePredictionQuery mpq = (MultiplePredictionQuery)JSON.parse((JsonElement)jsonReq, MultiplePredictionQuery.class);
                        this.require(mpq.items != null, "'items' is required");
                        PredictionEndpointHandlerBase peh = (PredictionEndpointHandlerBase)re.getHandler();
                        this.writeJSON2(resp, peh.predict(startTimeN, re, mpq, apiKey, requestMetadata));
                        break block19;
                    }
                    if (handler instanceof PyFunctionEndpointHandler && ((PyFunctionEndpointHandler)re.getHandler()).hasCustomResponse()) {
                        throw new UnsupportedOperationException("Custom response is not supported for endpoints Deployed on SageMaker or Azure ML");
                    }
                    if (handler instanceof FunctionEndpointHandlerBase) {
                        FunctionEndpointHandlerBase reh = (FunctionEndpointHandlerBase)re.getHandler();
                        this.writeJSON2(resp, reh.runAndLog(jsonReq.getAsJsonObject(), re, apiKey, requestMetadata));
                        break block19;
                    }
                    throw new UnsupportedOperationException("Unsupported endpoint type");
                }
                finally {
                    manager.releaseEndpoint(re);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/public/api/v1/vertex-ai/{serviceId}/{endpointId}/predict"}, method={RequestMethod.POST})
    public void execVertexAI(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String endpointId) throws Exception {
        block20: {
            try (ErrorContext.ACNDC c1 = ErrorContext.pushWithNDC((String)("svc:" + serviceId));
                 ErrorContext.ACNDC c2 = ErrorContext.pushWithNDC((String)("ep:" + endpointId));){
                ServiceManager manager = this.serviceService.getServiceManagerCheck(serviceId);
                this.authService.checkAuth(manager.getServiceId(), manager.getConfig(), req);
                QueryAPIKey apiKey = this.authService.getApiKeyForInternalCalls(manager.getServiceId(), manager.getConfig(), req);
                boolean isRequestMetadataEnabled = this.lambdaContext.getMandatoryConfig().isRequestMetadataEnabled;
                RequestMetadata requestMetadata = RequestMetadata.extractFrom(req, isRequestMetadataEnabled);
                VertexAIQuery vq = (VertexAIQuery)this.getRequestBodyAs(req, VertexAIQuery.class);
                this.require(vq.instances != null, "'instances' is required");
                PredictionQueryDispatch dispatch = null;
                if (Objects.nonNull(vq.parameters)) {
                    dispatch = (PredictionQueryDispatch)JSON.parse((JsonElement)vq.parameters.get("dispatch"), PredictionQueryDispatch.class);
                }
                ServiceManager.RefcountedEndpoint re = manager.acquireEndpoint(endpointId, dispatch);
                LambdaEndpointHandler<?> handler = re.getHandler();
                try {
                    if (handler instanceof PredictionEndpointHandlerBase) {
                        long startTimeN = System.nanoTime();
                        MultiplePredictionQuery mpq = vq.toMultiplePredictionQuery();
                        PredictionEndpointHandlerBase peh = (PredictionEndpointHandlerBase)re.getHandler();
                        PredictionResponse presp = peh.predict(startTimeN, re, mpq, apiKey, requestMetadata);
                        this.writeJSON2(resp, new VertexAIResponse(presp));
                        break block20;
                    }
                    if (handler instanceof PyFunctionEndpointHandler && ((PyFunctionEndpointHandler)re.getHandler()).hasCustomResponse()) {
                        throw new UnsupportedOperationException("Custom response not supported on VertexAI");
                    }
                    if (handler instanceof FunctionEndpointHandlerBase) {
                        ArrayList<FunctionResponse> functionResponse = new ArrayList<FunctionResponse>();
                        for (JsonObject instance : vq.instances) {
                            FunctionEndpointHandlerBase reh = (FunctionEndpointHandlerBase)re.getHandler();
                            functionResponse.add(reh.runAndLog(instance, re, apiKey, requestMetadata));
                        }
                        this.writeJSON2(resp, new VertexAIResponse(functionResponse));
                        break block20;
                    }
                    throw new UnsupportedOperationException("Unsupported endpoint type");
                }
                finally {
                    manager.releaseEndpoint(re);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/public/api/v1/snowpark/{serviceId}/{endpointId}/predict"}, method={RequestMethod.POST})
    public void execSnowpark(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String endpointId) throws Exception {
        block20: {
            try (ErrorContext.ACNDC c1 = ErrorContext.pushWithNDC((String)("svc:" + serviceId));
                 ErrorContext.ACNDC c2 = ErrorContext.pushWithNDC((String)("ep:" + endpointId));){
                ServiceManager manager = this.serviceService.getServiceManagerCheck(serviceId);
                this.authService.checkAuth(manager.getServiceId(), manager.getConfig(), req);
                QueryAPIKey apiKey = this.authService.getApiKeyForInternalCalls(manager.getServiceId(), manager.getConfig(), req);
                boolean isRequestMetadataEnabled = this.lambdaContext.getMandatoryConfig().isRequestMetadataEnabled;
                RequestMetadata requestMetadata = RequestMetadata.extractFrom(req, isRequestMetadataEnabled);
                SnowparkQuery sq = (SnowparkQuery)this.getRequestBodyAs(req, SnowparkQuery.class);
                this.require(sq.data != null, "'data' is required");
                ServiceManager.RefcountedEndpoint re = manager.acquireEndpoint(endpointId, null);
                LambdaEndpointHandler<?> handler = re.getHandler();
                try {
                    if (handler instanceof PredictionEndpointHandlerBase) {
                        PredictionEndpointHandlerBase peh = (PredictionEndpointHandlerBase)re.getHandler();
                        List queries = sq.toSinglePredictionQueries();
                        ArrayList<Pair> predictionResponses = new ArrayList<Pair>();
                        for (Pair query : queries) {
                            long startTimeN = System.nanoTime();
                            PredictionResponse pred = peh.predict(startTimeN, re, (SinglePredictionQuery)query.second, apiKey, requestMetadata);
                            predictionResponses.add(new Pair((Object)((Integer)query.first), (Object)new SinglePredictionResponse(pred)));
                        }
                        SnowparkResponse snowparkResponse = SnowparkResponse.fromResponses(predictionResponses);
                        this.writeJSON2(resp, snowparkResponse);
                        break block20;
                    }
                    if (handler instanceof PyFunctionEndpointHandler && ((PyFunctionEndpointHandler)re.getHandler()).hasCustomResponse()) {
                        throw new UnsupportedOperationException("Custom response not supported on Snowpark");
                    }
                    if (handler instanceof FunctionEndpointHandlerBase) {
                        FunctionEndpointHandlerBase reh = (FunctionEndpointHandlerBase)re.getHandler();
                        List queries = sq.toItems();
                        ArrayList<Pair> functionResponses = new ArrayList<Pair>();
                        for (Pair query : queries) {
                            FunctionResponse fresp = reh.runAndLog((JsonObject)query.second, re, apiKey, requestMetadata);
                            functionResponses.add(new Pair((Object)((Integer)query.first), (Object)fresp));
                        }
                        SnowparkResponse snowparkResponse = SnowparkResponse.fromResponses(functionResponses);
                        this.writeJSON2(resp, snowparkResponse);
                        break block20;
                    }
                    throw new UnsupportedOperationException("Unsupported endpoint type");
                }
                finally {
                    manager.releaseEndpoint(re);
                }
            }
        }
    }
}

