/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.controllers;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.auth.AuthVerificationService;
import com.dataiku.lambda.controllers.LambdaControllerUtils;
import com.dataiku.lambda.endpoints.datasetlookup.DatasetsLookupEndpointHandler;
import com.dataiku.lambda.model.api.LookupModel;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import com.dataiku.lambda.services.ServiceManager;
import com.dataiku.lambda.services.ServicesService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.log4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class LookupEndpointsController
extends LambdaAPIControllerBase {
    @Autowired
    private ServicesService serviceService;
    @Autowired
    private AuthVerificationService authService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.functions");

    @RequestMapping(value={"/public/api/v1/{serviceId}/{endpointId}/lookup"}, method={RequestMethod.POST})
    public void execLookup(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String endpointId) throws Exception {
        try (ErrorContext.ACNDC c1 = ErrorContext.pushWithNDC((String)("svc:" + serviceId));
             ErrorContext.ACNDC c2 = ErrorContext.pushWithNDC((String)("ep:" + endpointId));){
            LookupModel.SingleLookupQuery spq = (LookupModel.SingleLookupQuery)this.getRequestBodyAs(req, LookupModel.SingleLookupQuery.class);
            this.replySimple(req, resp, serviceId, endpointId, spq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/public/api/v1/{serviceId}/{endpointId}/lookup-multi"}, method={RequestMethod.POST})
    public void execLookupMulti(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String endpointId) throws Exception {
        try (ErrorContext.ACNDC c1 = ErrorContext.pushWithNDC((String)("svc:" + serviceId));
             ErrorContext.ACNDC c2 = ErrorContext.pushWithNDC((String)("ep:" + endpointId));){
            MDC.put((String)"serviceId", (Object)serviceId);
            MDC.put((String)"endpointId", (Object)endpointId);
            LookupModel.MultipleLookupQuery mpq = (LookupModel.MultipleLookupQuery)this.getRequestBodyAs(req, LookupModel.MultipleLookupQuery.class);
            this.require(mpq.items != null, "'items' is required");
            ServiceManager manager = this.serviceService.getServiceManagerCheck(serviceId);
            this.authService.checkAuth(serviceId, manager.getConfig(), req);
            ServiceManager.RefcountedEndpoint re = manager.acquireEndpoint(endpointId, null);
            try {
                DatasetsLookupEndpointHandler handler = (DatasetsLookupEndpointHandler)re.getHandler();
                this.writeJSON2(resp, handler.lookupMulti(mpq, re));
            }
            finally {
                manager.releaseEndpoint(re);
            }
        }
    }

    @RequestMapping(value={"/public/api/v1/{serviceId}/{endpointId}/lookup-simple"}, method={RequestMethod.GET})
    public void execLookupSimple(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId, @PathVariable String endpointId) throws Exception {
        try (ErrorContext.ACNDC c1 = ErrorContext.pushWithNDC((String)("svc:" + serviceId));
             ErrorContext.ACNDC c2 = ErrorContext.pushWithNDC((String)("ep:" + endpointId));){
            LookupModel.SingleLookupQuery spq = LambdaControllerUtils.httpGETReqToLookupQuery(req);
            this.replySimple(req, resp, serviceId, endpointId, spq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replySimple(HttpServletRequest req, HttpServletResponse resp, String serviceId, String endpointId, LookupModel.SingleLookupQuery spq) throws Exception {
        this.require(spq.data != null, "'data' is required");
        MDC.put((String)"serviceId", (Object)serviceId);
        MDC.put((String)"endpointId", (Object)endpointId);
        logger.info((Object)("Got lookup request: " + JSON.log((Object)spq)));
        ServiceManager manager = this.serviceService.getServiceManagerCheck(serviceId);
        this.authService.checkAuth(serviceId, manager.getConfig(), req);
        ServiceManager.RefcountedEndpoint re = manager.acquireEndpoint(endpointId, null);
        try {
            DatasetsLookupEndpointHandler handler = (DatasetsLookupEndpointHandler)re.getHandler();
            this.writeJSON2(resp, handler.lookupSimple(spq, re));
        }
        finally {
            manager.releaseEndpoint(re);
        }
    }
}

