/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.controllers;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RequestMetadata {
    private final String path;
    private final List<List<String>> headers;

    private RequestMetadata(HttpServletRequest request) {
        this.path = request.getPathInfo();
        this.headers = RequestMetadata.extractHeaders(request);
    }

    private RequestMetadata(String path, List<List<String>> headers) {
        this.path = path;
        this.headers = headers;
    }

    private static List<List<String>> extractHeaders(HttpServletRequest request) {
        ArrayList<List<String>> headers = new ArrayList<List<String>>();
        for (String name : Collections.list(request.getHeaderNames())) {
            for (String value : Collections.list(request.getHeaders(name))) {
                headers.add(List.of(name, value));
            }
        }
        return headers;
    }

    public static RequestMetadata extractFrom(HttpServletRequest request, boolean isEnabled) {
        if (isEnabled) {
            return new RequestMetadata(request);
        }
        return new RequestMetadata("BLOCKED_BY_CONFIG", List.of());
    }
}

