/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.dispatch;

import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.lambda.dispatch.GenerationSelector;
import com.dataiku.lambda.model.api.PredictionQueryDispatch;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HashBasedGenerationSelector
implements GenerationSelector {
    static final long PRECISION = 10000L;
    HashFunction hashFunc = Hashing.goodFastHash((int)64);
    public List<Double> bounds = new ArrayList<Double>();
    public List<String> gens = new ArrayList<String>();
    private static Logger logger = Logger.getLogger((String)"dku.apinode.dispatch.hash");

    public HashBasedGenerationSelector(GenerationsMapping mapping) {
        double cur = 0.0;
        for (GenerationsMapping.MappingEntry e : mapping.getEntries()) {
            this.bounds.add(cur += e.proba);
            this.gens.add(e.generation);
        }
    }

    @Override
    public String select(PredictionQueryDispatch dispatch) {
        if (dispatch != null && !StringUtils.isBlank((String)dispatch.forcedGeneration)) {
            return dispatch.forcedGeneration;
        }
        if (dispatch == null || StringUtils.isBlank((String)dispatch.dispatchKey)) {
            throw ErrorContext.iae((String)"For a HASH_BASED dispatch, the dispatch key is mandatory in queries");
        }
        long hash = this.hashFunc.hashString((CharSequence)dispatch.dispatchKey, StandardCharsets.UTF_8).asLong();
        double val = (double)(Math.abs(hash) % 10000L) / 10000.0;
        for (int i = 0; i < this.bounds.size(); ++i) {
            if (!(val < this.bounds.get(i))) continue;
            return this.gens.get(i);
        }
        throw new Error("failed to select for val=" + val);
    }
}

