/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.predict;

import com.dataiku.dip.analysis.ml.MLPluginsService;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.kernels.AbstractLambdaPythonKernel;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.endpoints.predictcommon.AbstractPythonPredictionStep;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfig;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class PredictionModelPredictionStep
extends AbstractPythonPredictionStep {
    protected final List<String> codePaths = Lists.newArrayList();
    protected final Map<String, String> pluginResourcesEnv = new HashMap<String, String>();
    protected AbstractLambdaPythonKernel kernel;
    protected ResponderKernelLink link;
    protected final ServiceGenContext ctx;
    protected final String kernelName;
    protected final boolean outputExplanations;
    protected final boolean computePropensity;
    protected final String modelFolderPath;
    protected final File codeEnvFolder;
    protected final PredictionEndpointConfig endpointConfig;
    protected AutoDelete kernelWorkDir;
    @Autowired
    protected LambdaContext lambdaContext;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.predict");

    protected PredictionModelPredictionStep(PredictionEndpointConfig ep, ServiceGenContext ctx, File modelFolder) throws IOException {
        SpringUtils.getInstance().autowire((Object)this);
        this.codePaths.addAll(ctx.getLibPathsInEndpointFolder(ep.id));
        File mlPluginsFolder = ctx.getMLPluginsFolder();
        MLPluginsService.MLPluginEnvInfo mlPluginEnvInfo = MLPluginsService.getPluginsLibsPath((File)mlPluginsFolder);
        if (mlPluginEnvInfo.additionalPythonPaths != null && !mlPluginEnvInfo.additionalPythonPaths.isEmpty()) {
            this.codePaths.addAll(mlPluginEnvInfo.additionalPythonPaths);
        }
        if (mlPluginEnvInfo.pluginResourcesEnv != null) {
            this.pluginResourcesEnv.putAll(mlPluginEnvInfo.pluginResourcesEnv);
        }
        this.ctx = ctx;
        this.endpointConfig = ep;
        this.outputExplanations = ep.outputExplanations;
        this.computePropensity = ep.computePropensity;
        this.kernelName = this.getKernelNamePrefix() + ctx.getServiceId() + "-" + ep.id + "-" + ctx.getGenerationId();
        this.modelFolderPath = modelFolder.getAbsolutePath();
        this.codeEnvFolder = ctx.getFileInEndpointFolder(ep.id, "python-env-live");
        this.kernelWorkDir = this.lambdaContext.getTempFolder("lambda-" + this.getKernelNamePrefix() + SecretKeyGenerator.generate((int)8));
        logger.infoV("Created temporary kernel work directory %s for service %s - endpoint %s - generation %s", new Object[]{this.kernelWorkDir.getAbsolutePath(), ctx.getServiceId(), ep.id, ctx.getGenerationId()});
    }

    public abstract String getKernelNamePrefix();

    public abstract AbstractLambdaPythonKernel initializeKernel();

    public void init() throws Exception {
        this.link = new ResponderKernelLink(SecretKeyGenerator.generate((int)16));
        try {
            this.kernel = this.initializeKernel();
            this.kernel.start();
            StartResponse started = (StartResponse)this.link.execute((Object)new StartRequest(this.modelFolderPath, this.outputExplanations, this.computePropensity), StartResponse.class, "Failed to start prediction kernel");
            if (!started.ok) {
                throw new Exception("Failed to start prediction kernel: " + started.reason);
            }
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.kernel);
            IOException fe = this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
            this.cleanupResources();
            throw fe;
        }
        catch (Exception e) {
            this.cleanupResources();
            throw e;
        }
    }

    private void cleanupResources() {
        try {
            this.link.close();
            this.kernel.killWithoutMercy();
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to cleanup prediction kernel", (Throwable)ex);
        }
        try {
            this.kernelWorkDir.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error cleaning kernel work directory", (Throwable)e);
        }
        this.link = null;
        this.kernel = null;
        this.kernelWorkDir = null;
    }

    @Override
    public void destroy() {
        if (this.link != null) {
            try {
                this.link.close();
            }
            catch (IOException e) {
                logger.error((Object)"Failed to close link to prediction kernel", (Throwable)e);
            }
            this.link = null;
        }
        if (this.kernel != null) {
            this.kernel.killNoWaitNoException(false);
            this.kernel = null;
        }
        if (this.kernelWorkDir != null) {
            this.kernelWorkDir.close();
        }
    }

    public static class StartRequest {
        public String modelFolder;
        public boolean outputExplanations;
        public boolean computePropensity;

        public StartRequest(String modelFolder, boolean outputExplanations, boolean computePropensity) {
            this.modelFolder = modelFolder;
            this.outputExplanations = outputExplanations;
            this.computePropensity = computePropensity;
        }
    }

    public static class StartResponse {
        public boolean ok;
        public String reason;
    }
}

