/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.classpathfix;

import javax.annotation.Nullable;

public final class DKUDoubles {
    @Nullable
    public static Double tryParse(String string) {
        if (string == null) {
            return null;
        }
        try {
            if (DKUDoubles.isWellFormattedDouble(string)) {
                return Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isWellFormattedDouble(String s) {
        int previousIndex;
        boolean digitsBeforeDot;
        int index;
        boolean hasExp = false;
        boolean isHex = false;
        if (s == null) return false;
        if (s.length() <= 0) {
            return false;
        }
        char c = s.charAt(0);
        int n = index = c == '+' || c == '-' ? 1 : 0;
        if (index < s.length()) {
            c = s.charAt(index);
            if (c == 'I') {
                if (s.length() != index + 8) return false;
                if (s.charAt(index + 1) != 'n') return false;
                if (s.charAt(index + 2) != 'f') return false;
                if (s.charAt(index + 3) != 'i') return false;
                if (s.charAt(index + 4) != 'n') return false;
                if (s.charAt(index + 5) != 'i') return false;
                if (s.charAt(index + 6) != 't') return false;
                if (s.charAt(index + 7) != 'y') return false;
                return true;
            }
            if (c == 'N') {
                if (s.length() != index + 3) return false;
                if (s.charAt(index + 1) != 'a') return false;
                if (s.charAt(index + 2) != 'N') return false;
                return true;
            }
            if (c == '0' && index + 1 < s.length() && ((c = s.charAt(index + 1)) == 'x' || c == 'X')) {
                isHex = true;
                hasExp = true;
                index += 2;
            }
        }
        boolean bl = digitsBeforeDot = (previousIndex = index) != (index = DKUDoubles.consumeDigits(s, index, isHex));
        if (index < s.length() && s.charAt(index) == '.') {
            ++index;
            previousIndex = index;
            if (previousIndex == (index = DKUDoubles.consumeDigits(s, index, isHex)) && !digitsBeforeDot) {
                return false;
            }
        } else if (!digitsBeforeDot) {
            return false;
        }
        if (isHex) {
            if (index >= s.length()) return false;
            c = s.charAt(index);
            if (c != 'p') {
                if (c != 'P') return false;
            }
            ++index;
        } else if (index < s.length() && ((c = s.charAt(index)) == 'e' || c == 'E')) {
            ++index;
            hasExp = true;
        }
        if (hasExp) {
            if (index < s.length() && ((c = s.charAt(index)) == '+' || c == '-')) {
                ++index;
            }
            if ((previousIndex = index) == (index = DKUDoubles.consumeDigits(s, index, false))) {
                return false;
            }
        }
        if (index + 1 == s.length()) {
            c = s.charAt(index);
            if (c == 'f') return true;
            if (c == 'F') return true;
            if (c == 'D') return true;
            if (c != 'd') return false;
            return true;
        }
        if (index != s.length()) return false;
        return true;
    }

    private static int consumeDigits(String s, int index, boolean isHex) {
        while (index < s.length()) {
            char c = s.charAt(index);
            if ((char)(c - 48) <= '\t') {
                ++index;
                continue;
            }
            if (!isHex || (c < 'a' || c > 'f') && (c < 'A' || c > 'F')) break;
            ++index;
        }
        return index;
    }

    public static double min(double ... array) {
        if (array.length <= 0) {
            throw new IllegalArgumentException();
        }
        double min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = Math.min(min, array[i]);
        }
        return min;
    }

    public static double max(double ... array) {
        if (array.length <= 0) {
            throw new IllegalArgumentException();
        }
        double max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = Math.max(max, array[i]);
        }
        return max;
    }

    private DKUDoubles() {
    }
}

