/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;

public class CollectionUtils {
    public static <T> T getMapOnlyValue(Map<? extends Object, T> map) {
        if (map.size() != 1) {
            throw new IllegalArgumentException("Can't get map only value, it has " + map.size() + " elements");
        }
        return map.values().iterator().next();
    }

    public static MapAdder appendableSSMap() {
        return new MapAdder(new HashMap<String, String>());
    }

    public static <T> void setAddAll(Set<T> set, T[] array) {
        for (T t : array) {
            set.add(t);
        }
    }

    public static <T> void listAddAll(List<T> list, T[] array) {
        for (T t : array) {
            list.add(t);
        }
    }

    public static boolean equalsOrBothEmpty(Collection<?> coll1, Collection<?> coll2) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(coll1) && org.apache.commons.collections4.CollectionUtils.isEmpty(coll2)) {
            return true;
        }
        return Objects.equals(coll1, coll2);
    }

    public static boolean equalsOrBothEmpty(Map<?, ?> map1, Map<?, ?> map2) {
        if (MapUtils.isEmpty(map1) && MapUtils.isEmpty(map2)) {
            return true;
        }
        return Objects.equals(map1, map2);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> entriesToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static class MapAdder {
        private Map<String, String> map;

        public MapAdder(Map<String, String> map) {
            this.map = map;
        }

        public MapAdder put(String name, String value) {
            this.map.put(name, value);
            return this;
        }

        public Map<String, String> get() {
            return this.map;
        }
    }
}

