/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WindowsUtils {
    private static final FileVisitor<Path> removeReadOnlyFlagVisitor = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attr) throws IOException {
            Files.setAttribute(dir, "dos:readonly", false, new LinkOption[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
            Files.setAttribute(file, "dos:readonly", false, new LinkOption[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            if (exc instanceof NoSuchFileException) {
                return FileVisitResult.CONTINUE;
            }
            if (exc instanceof AccessDeniedException) {
                logger.warn((Object)("Encountered an AccessDeniedException while visiting file: " + String.valueOf(file)), (Throwable)exc);
                return FileVisitResult.CONTINUE;
            }
            return super.visitFileFailed(file, exc);
        }
    };
    private static final Pattern forbiddenFileNamePattern = Pattern.compile("^((?:(?:CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\.[^.]*)?$)?|.*[<>:\"/\\\\|?*\\x00-\\x1F]+.*|.*[\\ .])$", 66);
    private static final Logger logger = Logger.getLogger((String)"dku.utils.windows");

    public static int getPid(Process p) {
        Class<?> processClass = p.getClass();
        String processClassName = processClass.getName();
        if (processClassName.equals("java.lang.Win32Process") || processClassName.equals("java.lang.ProcessImpl")) {
            ProcessHandle processHandle = p.toHandle();
            return (int)processHandle.pid();
        }
        return 0;
    }

    public static int getOwnPid() {
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            return Integer.parseInt(processName.split("@")[0]);
        }
        catch (Exception e) {
            logger.info((Object)"Unable to inspect JVM to grab its PID", (Throwable)e);
            return 0;
        }
    }

    public static boolean isFilenameValid(String filename) {
        return !forbiddenFileNamePattern.matcher(filename).matches();
    }

    public static void recursivelyRemoveReadOnlyFlag(File root) throws IOException {
        Files.walkFileTree(root.toPath(), removeReadOnlyFlagVisitor);
    }
}

