/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.deployer.common.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.deployer.projectdeployer.published.PublishedProjectsService;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.nodeclients.ProjectDeployerClientProxyUser;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projects.importexport.DesignBundlesService;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public class PrepareBundleStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        public String getType() {
            return "prepare_bundle";
        }

        public Class<? extends StepParams> paramsClass() {
            return PrepareBundleStepParams.class;
        }

        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new PrepareBundleStepRunner(scenario, step, (PrepareBundleStepParams)step.getParamsAs(PrepareBundleStepParams.class));
        }

        public String buildName(Step step) {
            PrepareBundleStepParams params = (PrepareBundleStepParams)step.getParamsAs(PrepareBundleStepParams.class);
            Object name = "Make bundle";
            if (StringUtils.isNotBlank((String)params.bundleId)) {
                name = (String)name + " for " + params.bundleId;
            }
            return name;
        }

        public String buildId(Step step) {
            PrepareBundleStepParams params = (PrepareBundleStepParams)step.getParamsAs(PrepareBundleStepParams.class);
            return "bundle " + params.bundleId;
        }

        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final PrepareBundleStepParams params;
    private final Step step;
    private final Scenario scenario;
    @Autowired
    private DesignBundlesService bundlesServices;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.prepare_bundle");

    public PrepareBundleStepRunner(Scenario scenario, Step step, PrepareBundleStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    private void publishOnDeployer(String designProjectKey, String bundleId, StepRun stepRun) throws IOException, UnauthorizedException {
        String publishedProjectKey = StringUtils.isBlank((String)this.params.publishedProjectKey) ? designProjectKey : this.params.publishedProjectKey;
        ReportItem.PublishedBundle publishedItem = new ReportItem.PublishedBundle((ReportTargetItem)new ReportTargetItem.BundleItem(publishedProjectKey, bundleId)).withBundleId(bundleId);
        publishedItem.withStart(DateTime.now().getMillis());
        try {
            PublishedPackageInfo bundleInfo;
            logger.info((Object)"Publishing new bundle on Deployer");
            GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
            File bundleFile = ApplicationConfigurator.getFile((String[])new String[]{"prepared_bundles", designProjectKey, bundleId, String.format("dss-bundle-%s-%s.zip", designProjectKey, bundleId)});
            DSSAuthCtx user = stepRun.getScenarioRun().getRunAsUser();
            switch (ref.mode) {
                case DISABLED: {
                    throw ErrorContext.iae((String)"Deployer support is disabled");
                }
                case LOCAL: {
                    try (FileInputStream is = new FileInputStream(bundleFile);){
                        bundleInfo = ((PublishedProjectsService)SpringUtils.getBean(PublishedProjectsService.class)).publishBundleFromStream_NT_Check((AuthCtx)user, publishedProjectKey, (InputStream)is);
                        break;
                    }
                }
                case REMOTE: {
                    try (ProjectDeployerClientProxyUser client = new ProjectDeployerClientProxyUser(ref, (AuthCtx)stepRun.getScenarioRun().getRunAsUser());){
                        bundleInfo = client.publishBundle(publishedProjectKey, bundleFile);
                        break;
                    }
                }
                default: {
                    throw ErrorContext.iaef((String)"Invalid mode for Project Deployer: %s", (Object)ref.mode, (Object[])new Object[0]);
                }
            }
            this.bundlesServices.writePublishedBundleState(bundleInfo, designProjectKey, publishedProjectKey, bundleId, (AuthCtx)user);
            publishedItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
            logger.info((Object)"Done publishing on Deployer");
        }
        catch (Throwable ex) {
            publishedItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            throw ex;
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(designProjectKey, bundleId), null, null, stepRun.getScenarioRun(), stepRun, (ReportItem)publishedItem);
        }
    }

    public void run(StepRun stepRun, ReportItem.StepDone reportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        String projectKey = stepRun.getScenarioRun().getScenario().getProjectKey();
        Object bundleId = this.params.bundleId;
        VariablesContext variablesContext = this.variablesService.getForProject(projectKey);
        if (StringUtils.isBlank((String)bundleId)) {
            bundleId = projectKey + "-bundle";
        } else {
            StrSubstitutor substitutor = new StrSubstitutor(variablesContext.getAllVariables());
            logger.info((Object)("Raw bundle id " + (String)bundleId));
            bundleId = substitutor.replace((String)bundleId);
            logger.info((Object)("Replaced bundle id " + (String)bundleId));
        }
        if (this.params.transmogrify) {
            StringTransmogrifier transmogrifier = new StringTransmogrifier("");
            for (CommonBundleUtils.BundleInfoBase bundleInfo : this.bundlesServices.listAvailable((String)projectKey).bundles) {
                if (((CommonBundleUtils.ExportedBundleSummary)bundleInfo).state != CommonBundleUtils.BundleState.BUILT) continue;
                transmogrifier.addAlreadyTransmogrified(bundleInfo.bundleId);
            }
            bundleId = transmogrifier.transmogrify((String)bundleId);
            logger.info((Object)("Transmogrified bundle id " + (String)bundleId));
        }
        ReportItem.MadeBundle bundleItem = new ReportItem.MadeBundle((ReportTargetItem)new ReportTargetItem.BundleItem(projectKey, (String)bundleId)).withBundleId((String)bundleId);
        bundleItem.withStart(DateTime.now().getMillis());
        try {
            FutureResponse fr;
            ExportedProject.ExportUserInfo userInfo = new ExportedProject.ExportUserInfo();
            if (StringUtils.isNotBlank((String)this.params.releaseNotes)) {
                userInfo.releaseNotes = variablesContext.expandAllowUnresolved(this.params.releaseNotes).trim();
                logger.info((Object)"Expanded variables in release notes");
            }
            try (Transaction t = this.transactionService.beginRead();){
                fr = this.bundlesServices.startExportBundle_NT(projectKey, (String)bundleId, DKUApp.getInstallId(), DKUApp.getNodeId(), ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().studioExternalUrl, userInfo, true, (AuthCtx)stepRun.getScenarioRun().getRunAsUser());
            }
            fr = this.futureService.waitForFinalResponse(fr);
            if (fr.result != null) {
                logger.info((Object)("Bundle report : " + String.valueOf(fr.result)));
            }
            bundleItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
            if (StringUtils.isNotBlank((String)this.params.targetVariable)) {
                logger.info((Object)("Setting variable " + this.params.targetVariable + " to new bundle id: " + (String)bundleId));
                stepRun.getScenarioRun().getVariables().addProperty(this.params.targetVariable, (String)bundleId);
            }
        }
        catch (Throwable ex) {
            bundleItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            throw ex;
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(projectKey, (String)bundleId), null, null, stepRun.getScenarioRun(), stepRun, (ReportItem)bundleItem);
        }
        if (this.params.publishOnDeployer && bundleItem.outcome == ReportItem.Outcome.SUCCESS) {
            this.publishOnDeployer(projectKey, (String)bundleId, stepRun);
        }
        logger.info((Object)("Done step " + this.step.name));
    }

    public static class PrepareBundleStepParams
    implements StepParams {
        public String bundleId;
        public boolean transmogrify;
        public String targetVariable;
        public String publishedProjectKey;
        public boolean publishOnDeployer;
        @Nullable
        String releaseNotes;
    }
}

