/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.a2a.DSSA2AUser;
import com.dataiku.dip.server.a2a.DSSAgentExecutor;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.core.TreeNode;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadeliba2a.io.a2a.server.ServerCallContext;
import com.dataiku.dss.shadeliba2a.io.a2a.server.agentexecution.AgentExecutor;
import com.dataiku.dss.shadeliba2a.io.a2a.server.auth.User;
import com.dataiku.dss.shadeliba2a.io.a2a.server.events.InMemoryQueueManager;
import com.dataiku.dss.shadeliba2a.io.a2a.server.events.QueueManager;
import com.dataiku.dss.shadeliba2a.io.a2a.server.extensions.A2AExtensions;
import com.dataiku.dss.shadeliba2a.io.a2a.server.requesthandlers.DefaultRequestHandler;
import com.dataiku.dss.shadeliba2a.io.a2a.server.requesthandlers.RequestHandler;
import com.dataiku.dss.shadeliba2a.io.a2a.server.tasks.BasePushNotificationSender;
import com.dataiku.dss.shadeliba2a.io.a2a.server.tasks.InMemoryPushNotificationConfigStore;
import com.dataiku.dss.shadeliba2a.io.a2a.server.tasks.InMemoryTaskStore;
import com.dataiku.dss.shadeliba2a.io.a2a.server.tasks.PushNotificationConfigStore;
import com.dataiku.dss.shadeliba2a.io.a2a.server.tasks.PushNotificationSender;
import com.dataiku.dss.shadeliba2a.io.a2a.server.tasks.TaskStateProvider;
import com.dataiku.dss.shadeliba2a.io.a2a.server.tasks.TaskStore;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentCapabilities;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentCard;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentInterface;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentProvider;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentSkill;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.CancelTaskRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.DeleteTaskPushNotificationConfigRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetAuthenticatedExtendedCardRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetTaskPushNotificationConfigRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetTaskRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.InternalError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.InvalidRequestError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.JSONRPCError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.JSONRPCErrorResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.JSONRPCResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.ListTaskPushNotificationConfigRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.MethodNotFoundError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.NonStreamingJSONRPCRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SendMessageRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SendMessageResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SendStreamingMessageRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SendStreamingMessageResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SetTaskPushNotificationConfigRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.StreamingJSONRPCRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskResubscriptionRequest;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TransportProtocol;
import com.dataiku.dss.shadeliba2a.io.a2a.transport.jsonrpc.handler.JSONRPCHandler;
import com.dataiku.dss.shadeliba2a.io.a2a.transport.rest.handler.RestHandler;
import com.dataiku.dss.shadeliba2a.io.a2a.util.Utils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PublicAPIA2AController
extends PublicAPIControllerBase {
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    private static final String BASE_PATH = "/publicapi/projects/{projectKey}/agents/{agentId}/a2a";
    private static final String METHOD_MESSAGE_SEND = "message:send";
    private static final String METHOD_MESSAGE_STREAM = "message:stream";
    private static final String METHOD_TASK_GET = "tasks:get";
    private static final String METHOD_TASK_CANCEL = "tasks:cancel";
    private static final String METHOD_TASK_SUBSCRIBE = "tasks:subscribe";
    private static final String METHOD_TASK_PUSH_CONFIG = "tasks:pushNotificationConfigs";
    private Map<String, A2ARuntime> runtimes = new HashMap<String, A2ARuntime>();

    private AuthCtx authAndCheckPerm(HttpServletRequest req, String projectKey) throws DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            AuthCtx authCtx2 = authCtx;
            return authCtx2;
        }
    }

    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}/a2a/.well-known/agent-card.json", "/publicapi/projects/{projectKey}/agents/{agentId}/a2a/.well-known/agent.json"}, method={RequestMethod.GET})
    public void getAgentCard(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String agentId) throws IOException, DKUSecurityException {
        this.authAndCheckPerm(req, projectKey);
        this.sendRestResponse(resp, this.getRuntimeForAgent((String)projectKey, (String)agentId).restHandler.getAgentCard());
    }

    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}/a2a/v1/message:send"}, method={RequestMethod.POST}, consumes={"application/json"})
    public void sendMessage(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String agentId, @RequestBody String body) throws IOException, DKUSecurityException {
        AuthCtx authCtx = this.authAndCheckPerm(req, projectKey);
        ServerCallContext context = this.createCallContext(req, authCtx, METHOD_MESSAGE_SEND);
        this.sendRestResponse(resp, this.getRuntimeForAgent((String)projectKey, (String)agentId).restHandler.sendMessage(body, context));
    }

    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}/a2a/v1/message:stream"}, method={RequestMethod.POST}, consumes={"application/json"})
    public void sendStreamingMessage(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String agentId, @RequestBody String body) throws IOException, DKUSecurityException {
        AuthCtx authCtx = this.authAndCheckPerm(req, projectKey);
        ServerCallContext context = this.createCallContext(req, authCtx, METHOD_MESSAGE_STREAM);
        RestHandler.HTTPRestResponse response = this.getRuntimeForAgent((String)projectKey, (String)agentId).restHandler.sendStreamingMessage(body, context);
        if (!this.streamRestResponse(resp, response)) {
            this.sendRestResponse(resp, response);
        }
    }

    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}/a2a/v1/tasks/{taskId}"}, method={RequestMethod.GET})
    public void getTask(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String agentId, @PathVariable(value="taskId") String taskId, @RequestParam(value="historyLength", required=false) Integer historyLength) throws IOException, DKUSecurityException {
        AuthCtx authCtx = this.authAndCheckPerm(req, projectKey);
        ServerCallContext context = this.createCallContext(req, authCtx, METHOD_TASK_GET);
        int historyLengthValue = historyLength != null ? historyLength : 0;
        this.sendRestResponse(resp, this.getRuntimeForAgent((String)projectKey, (String)agentId).restHandler.getTask(taskId, historyLengthValue, context));
    }

    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}/a2a/v1/tasks/{taskId}:cancel"}, method={RequestMethod.POST})
    public void cancelTask(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String agentId, @PathVariable String taskId) throws IOException, DKUSecurityException {
        AuthCtx authCtx = this.authAndCheckPerm(req, projectKey);
        ServerCallContext context = this.createCallContext(req, authCtx, METHOD_TASK_CANCEL);
        this.sendRestResponse(resp, this.getRuntimeForAgent((String)projectKey, (String)agentId).restHandler.cancelTask(taskId, context));
    }

    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}/a2a/v1/tasks/{taskId}:subscribe"}, method={RequestMethod.POST})
    public void resubscribeTask(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String agentId, @PathVariable String taskId) throws IOException, DKUSecurityException {
        AuthCtx authCtx = this.authAndCheckPerm(req, projectKey);
        ServerCallContext context = this.createCallContext(req, authCtx, METHOD_TASK_SUBSCRIBE);
        RestHandler.HTTPRestResponse response = this.getRuntimeForAgent((String)projectKey, (String)agentId).restHandler.resubscribeTask(taskId, context);
        if (!this.streamRestResponse(resp, response)) {
            this.sendRestResponse(resp, response);
        }
    }

    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}/a2a/v1/tasks/{taskId}/pushNotificationConfigs"}, method={RequestMethod.POST}, consumes={"application/json"})
    public void setPushNotificationConfig(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String agentId, @PathVariable String taskId, @RequestBody String body) throws IOException, DKUSecurityException {
        AuthCtx authCtx = this.authAndCheckPerm(req, projectKey);
        ServerCallContext context = this.createCallContext(req, authCtx, METHOD_TASK_PUSH_CONFIG);
        this.sendRestResponse(resp, this.getRuntimeForAgent((String)projectKey, (String)agentId).restHandler.setTaskPushNotificationConfiguration(taskId, body, context));
    }

    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}/a2a/v1/tasks/{taskId}/pushNotificationConfigs/{configId}"}, method={RequestMethod.GET})
    public void getPushNotificationConfig(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String agentId, @PathVariable String taskId, @PathVariable(value="configId") String configId) throws IOException, DKUSecurityException {
        AuthCtx authCtx = this.authAndCheckPerm(req, projectKey);
        ServerCallContext context = this.createCallContext(req, authCtx, METHOD_TASK_PUSH_CONFIG);
        this.sendRestResponse(resp, this.getRuntimeForAgent((String)projectKey, (String)agentId).restHandler.getTaskPushNotificationConfiguration(taskId, configId, context));
    }

    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}/a2a/v1/tasks/{taskId}/pushNotificationConfigs"}, method={RequestMethod.GET})
    public void listPushNotificationConfigs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String agentId, @PathVariable String taskId) throws Exception {
        AuthCtx authCtx = this.authAndCheckPerm(req, projectKey);
        ServerCallContext context = this.createCallContext(req, authCtx, METHOD_TASK_PUSH_CONFIG);
        this.sendRestResponse(resp, this.getRuntimeForAgent((String)projectKey, (String)agentId).restHandler.listTaskPushNotificationConfigurations(taskId, context));
    }

    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}/a2a/v1/tasks/{taskId}/pushNotificationConfigs/{configId}"}, method={RequestMethod.DELETE})
    public void deletePushNotificationConfig(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String agentId, @PathVariable String taskId, @PathVariable String configId) throws Exception {
        AuthCtx authCtx = this.authAndCheckPerm(req, projectKey);
        ServerCallContext context = this.createCallContext(req, authCtx, METHOD_TASK_PUSH_CONFIG);
        this.sendRestResponse(resp, this.getRuntimeForAgent((String)projectKey, (String)agentId).restHandler.deleteTaskPushNotificationConfiguration(taskId, configId, context));
    }

    private void sendRestResponse(HttpServletResponse resp, RestHandler.HTTPRestResponse response) throws IOException {
        PublicAPIA2AController.setHeader((HttpServletResponse)resp);
        if (response == null) {
            resp.setStatus(204);
        } else {
            resp.setStatus(response.getStatusCode());
            resp.setContentType(response.getContentType());
            resp.getWriter().write(response.getBody());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean streamRestResponse(final HttpServletResponse resp, RestHandler.HTTPRestResponse response) throws IOException {
        if (!(response instanceof RestHandler.HTTPRestStreamingResponse)) {
            return false;
        }
        RestHandler.HTTPRestStreamingResponse streamingResponse = (RestHandler.HTTPRestStreamingResponse)response;
        PublicAPIA2AController.setHeader((HttpServletResponse)resp);
        resp.setStatus(response.getStatusCode());
        resp.setContentType(response.getContentType());
        final Object completedLatch = new Object();
        final MutableBoolean completed = new MutableBoolean();
        Flow.Publisher publisher = streamingResponse.getPublisher();
        publisher.subscribe(new Flow.Subscriber<String>(){
            private Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            @Override
            public void onNext(String item) {
                try {
                    String payload = "data: " + item + "\n\n";
                    resp.getOutputStream().write(payload.getBytes("UTF-8"));
                    resp.getOutputStream().flush();
                }
                catch (IOException e) {
                    PublicAPIControllerBase.logger.warn((Object)"A2A streaming response failed to write", (Throwable)e);
                    if (this.subscription != null) {
                        this.subscription.cancel();
                    }
                    return;
                }
                if (this.subscription != null) {
                    this.subscription.request(1L);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable throwable) {
                PublicAPIControllerBase.logger.warn((Object)"A2A streaming response failed", throwable);
                Object object = completedLatch;
                synchronized (object) {
                    completed.setTrue();
                    completedLatch.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onComplete() {
                Object object = completedLatch;
                synchronized (object) {
                    completed.setTrue();
                    completedLatch.notifyAll();
                }
            }
        });
        try {
            Object object = completedLatch;
            synchronized (object) {
                while (!completed.isTrue()) {
                    completedLatch.wait();
                }
            }
        }
        catch (InterruptedException e) {
            logger.warn((Object)"Interrupted while waiting for streaming completion", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        logger.info((Object)"Completed streaming REST response");
        return true;
    }

    @RequestMapping(value={"/publicapi/projects/{projectKey}/agents/{agentId}/a2a"}, method={RequestMethod.POST}, consumes={"application/json"})
    public void jsonRpc(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String agentId, @RequestBody String body) throws IOException, DKUSecurityException {
        AuthCtx authCtx = this.authAndCheckPerm(req, projectKey);
        JsonNode node = Utils.OBJECT_MAPPER.readTree(body);
        if (node == null) {
            throw new IOException("Invalid JSON-RPC payload: " + body);
        }
        String rpcMethod = node.get("method") != null ? node.get("method").asText() : null;
        String rpcId = node.get("id") != null ? node.get("id").asText() : null;
        logger.info((Object)("Received JSON-RPC request: method=" + rpcMethod + ", id=" + rpcId));
        if (rpcId == null || rpcMethod == null) {
            logger.warn((Object)"Invalid JSON-RPC request: missing method or id");
            this.sendJsonRpcError(resp, rpcId, (JSONRPCError)new InvalidRequestError("Missing method or id"));
            return;
        }
        boolean streaming = "message/stream".equals(rpcMethod) || "tasks/resubscribe".equals(rpcMethod);
        StreamingJSONRPCRequest sRequest = null;
        NonStreamingJSONRPCRequest nsRequest = null;
        if (!"agent/card".equals(rpcMethod)) {
            if (streaming) {
                sRequest = (StreamingJSONRPCRequest)Utils.OBJECT_MAPPER.treeToValue((TreeNode)node, StreamingJSONRPCRequest.class);
            } else {
                nsRequest = (NonStreamingJSONRPCRequest)Utils.OBJECT_MAPPER.treeToValue((TreeNode)node, NonStreamingJSONRPCRequest.class);
            }
        }
        ServerCallContext context = this.createCallContext(req, authCtx, rpcMethod);
        try {
            if ("message/send".equals(rpcMethod)) {
                SendMessageResponse response = this.getRuntimeForAgent((String)projectKey, (String)agentId).jsonRpcHandler.onMessageSend((SendMessageRequest)nsRequest, context);
                this.sendJsonRpcResponse(resp, (JSONRPCResponse<?>)response);
            } else if ("message/stream".equals(rpcMethod)) {
                Flow.Publisher publisher = this.getRuntimeForAgent((String)projectKey, (String)agentId).jsonRpcHandler.onMessageSendStream((SendStreamingMessageRequest)sRequest, context);
                this.streamJsonRpcResponses(resp, publisher);
            } else if ("tasks/cancel".equals(rpcMethod)) {
                this.sendJsonRpcResponse(resp, (JSONRPCResponse<?>)this.getRuntimeForAgent((String)projectKey, (String)agentId).jsonRpcHandler.onCancelTask((CancelTaskRequest)nsRequest, context));
            } else if ("tasks/get".equals(rpcMethod)) {
                this.sendJsonRpcResponse(resp, (JSONRPCResponse<?>)this.getRuntimeForAgent((String)projectKey, (String)agentId).jsonRpcHandler.onGetTask((GetTaskRequest)nsRequest, context));
            } else if ("tasks/resubscribe".equals(rpcMethod)) {
                Flow.Publisher publisher = this.getRuntimeForAgent((String)projectKey, (String)agentId).jsonRpcHandler.onResubscribeToTask((TaskResubscriptionRequest)sRequest, context);
                this.streamJsonRpcResponses(resp, publisher);
            } else if ("tasks/pushNotificationConfig/set".equals(rpcMethod)) {
                this.sendJsonRpcResponse(resp, (JSONRPCResponse<?>)this.getRuntimeForAgent((String)projectKey, (String)agentId).jsonRpcHandler.setPushNotificationConfig((SetTaskPushNotificationConfigRequest)nsRequest, context));
            } else if ("tasks/pushNotificationConfig/get".equals(rpcMethod)) {
                this.sendJsonRpcResponse(resp, (JSONRPCResponse<?>)this.getRuntimeForAgent((String)projectKey, (String)agentId).jsonRpcHandler.getPushNotificationConfig((GetTaskPushNotificationConfigRequest)nsRequest, context));
            } else if ("tasks/pushNotificationConfig/list".equals(rpcMethod)) {
                this.sendJsonRpcResponse(resp, (JSONRPCResponse<?>)this.getRuntimeForAgent((String)projectKey, (String)agentId).jsonRpcHandler.listPushNotificationConfig((ListTaskPushNotificationConfigRequest)nsRequest, context));
            } else if ("tasks/pushNotificationConfig/delete".equals(rpcMethod)) {
                this.sendJsonRpcResponse(resp, (JSONRPCResponse<?>)this.getRuntimeForAgent((String)projectKey, (String)agentId).jsonRpcHandler.deletePushNotificationConfig((DeleteTaskPushNotificationConfigRequest)nsRequest, context));
            } else if ("agent/getAuthenticatedExtendedCard".equals(rpcMethod)) {
                this.sendJsonRpcResponse(resp, (JSONRPCResponse<?>)this.getRuntimeForAgent((String)projectKey, (String)agentId).jsonRpcHandler.onGetAuthenticatedExtendedCardRequest((GetAuthenticatedExtendedCardRequest)nsRequest, context));
            } else if ("agent/card".equals(rpcMethod)) {
                AgentCard ac = this.getRuntimeForAgent((String)projectKey, (String)agentId).agentCard;
                JsonNode why = Utils.OBJECT_MAPPER.createObjectNode().put("jsonrpc", "2.0").put("id", rpcId).set("result", Utils.OBJECT_MAPPER.valueToTree((Object)ac));
                resp.setContentType("application/json");
                resp.getWriter().write(Utils.toJsonString((Object)why));
            } else {
                logger.warn((Object)("Unknown JSON-RPC method: " + rpcMethod));
                this.sendJsonRpcError(resp, rpcId, (JSONRPCError)new MethodNotFoundError());
            }
        }
        catch (JSONRPCError e) {
            logger.error((Object)"JSON-RPC error processing request", (Throwable)e);
            this.sendJsonRpcError(resp, rpcId, e);
        }
        catch (Exception e) {
            logger.error((Object)"Internal error processing JSON-RPC request", (Throwable)e);
            this.sendJsonRpcError(resp, rpcId, (JSONRPCError)new InternalError(e.getMessage()));
        }
    }

    private void sendJsonRpcResponse(HttpServletResponse resp, JSONRPCResponse<?> response) throws IOException {
        logger.info((Object)("Sending JSON-RPC response: " + Utils.toJsonString(response)));
        PublicAPIA2AController.setHeader((HttpServletResponse)resp);
        resp.setStatus(200);
        resp.setContentType("application/json");
        resp.getWriter().write(Utils.toJsonString(response));
    }

    private void sendJsonRpcError(HttpServletResponse resp, Object id, JSONRPCError error) throws IOException {
        this.sendJsonRpcResponse(resp, (JSONRPCResponse<?>)new JSONRPCErrorResponse(id, error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamJsonRpcResponses(final HttpServletResponse resp, Flow.Publisher<SendStreamingMessageResponse> publisher) throws IOException {
        PublicAPIA2AController.setHeader((HttpServletResponse)resp);
        resp.setContentType("text/event-stream");
        final Object completedLatch = new Object();
        final MutableBoolean completed = new MutableBoolean();
        publisher.subscribe(new Flow.Subscriber<SendStreamingMessageResponse>(){
            private Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            @Override
            public void onNext(SendStreamingMessageResponse item) {
                try {
                    String payload = "data: " + Utils.toJsonString((Object)item) + "\n\n";
                    resp.getOutputStream().write(payload.getBytes("UTF-8"));
                    resp.getOutputStream().flush();
                }
                catch (IOException e) {
                    PublicAPIControllerBase.logger.warn((Object)"A2A JSON-RPC streaming response failed to write", (Throwable)e);
                    if (this.subscription != null) {
                        this.subscription.cancel();
                    }
                    return;
                }
                if (this.subscription != null) {
                    this.subscription.request(1L);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable throwable) {
                PublicAPIControllerBase.logger.warn((Object)"A2A JSON-RPC streaming response failed", throwable);
                Object object = completedLatch;
                synchronized (object) {
                    completed.setTrue();
                    completedLatch.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onComplete() {
                Object object = completedLatch;
                synchronized (object) {
                    completed.setTrue();
                    completedLatch.notifyAll();
                }
            }
        });
        try {
            Object object = completedLatch;
            synchronized (object) {
                while (!completed.isTrue()) {
                    completedLatch.wait();
                }
            }
        }
        catch (InterruptedException e) {
            logger.warn((Object)"Interrupted while waiting for streaming completion", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        logger.info((Object)"Completed streaming JSON-RPC responses");
    }

    private ServerCallContext createCallContext(HttpServletRequest req, AuthCtx authCtx, String methodName) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String headerName : Collections.list(req.getHeaderNames())) {
            headers.put(headerName, req.getHeader(headerName));
        }
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("headers", headers);
        state.put("method", methodName);
        ArrayList extensionHeaders = Collections.list(req.getHeaders("X-A2A-Extensions"));
        Set requestedExtensions = A2AExtensions.getRequestedExtensions(extensionHeaders);
        return new ServerCallContext((User)new DSSA2AUser(authCtx), state, requestedExtensions);
    }

    private synchronized A2ARuntime getRuntimeForAgent(String projectKey, String agentId) {
        if (agentId.contains(".")) {
            throw new IllegalArgumentException("Shared agent cannot be used as a2a agent");
        }
        String key = projectKey + "___DKU___" + agentId;
        if (this.runtimes.containsKey(key)) {
            return this.runtimes.get(key);
        }
        A2ARuntime runtime = new A2ARuntime(projectKey, agentId);
        this.runtimes.put(key, runtime);
        return runtime;
    }

    private final class A2ARuntime {
        private final ExecutorService executor = Executors.newCachedThreadPool();
        private final RestHandler restHandler;
        private final JSONRPCHandler jsonRpcHandler;
        private final String projectKey;
        private final String agentId;
        public AgentCard agentCard;

        private A2ARuntime(String projectKey, String agentId) {
            DSSAgentExecutor executorImpl;
            this.projectKey = projectKey;
            this.agentId = agentId;
            try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginRead();){
                executorImpl = new DSSAgentExecutor(projectKey, agentId);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create DSSAgentExecutor", e);
            }
            InMemoryTaskStore taskStore = new InMemoryTaskStore();
            InMemoryQueueManager queueManager = new InMemoryQueueManager((TaskStateProvider)taskStore);
            InMemoryPushNotificationConfigStore notificationConfigStore = new InMemoryPushNotificationConfigStore();
            BasePushNotificationSender notificationSender = new BasePushNotificationSender((PushNotificationConfigStore)notificationConfigStore);
            DefaultRequestHandler requestHandler = DefaultRequestHandler.create((AgentExecutor)executorImpl, (TaskStore)taskStore, (QueueManager)queueManager, (PushNotificationConfigStore)notificationConfigStore, (PushNotificationSender)notificationSender, (Executor)this.executor);
            try {
                int consumptionTimeoutSeconds = DKUApp.getParams().getIntParam("dku.a2a.blocking.consumption.timeout.seconds", Integer.valueOf(150));
                Field f = DefaultRequestHandler.class.getDeclaredField("consumptionCompletionTimeoutSeconds");
                f.setAccessible(true);
                f.setInt(requestHandler, consumptionTimeoutSeconds);
                int agentTimeoutSeconds = DKUApp.getParams().getIntParam("dku.a2a.blocking.agent.timeout.seconds", Integer.valueOf(300));
                f = DefaultRequestHandler.class.getDeclaredField("agentCompletionTimeoutSeconds");
                f.setAccessible(true);
                f.setInt(requestHandler, agentTimeoutSeconds);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                PublicAPIControllerBase.logger.error((Object)"Failed to override A2A timeouts, using defaults", (Throwable)e);
            }
            try {
                this.agentCard = this.buildAgentCard();
                this.restHandler = new RestHandler(this.agentCard, (RequestHandler)requestHandler, (Executor)this.executor);
                this.jsonRpcHandler = new JSONRPCHandler(this.agentCard, (RequestHandler)requestHandler, (Executor)this.executor);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to build agent handlers", e);
            }
        }

        private AgentCard buildAgentCard() throws IOException {
            SavedModel sm;
            AgentCapabilities capabilities = new AgentCapabilities(true, false, false, List.of());
            AgentProvider provider = new AgentProvider("Dataiku", "https://www.dataiku.com");
            try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginRead();){
                sm = (SavedModel)PublicAPIA2AController.this.savedModelsDAO.getMandatory(this.projectKey, this.agentId);
            }
            AgentSkill skill = new AgentSkill(sm.projectKey + "." + sm.id, sm.name, sm.description != null ? sm.description : sm.name, List.of(), List.of(), List.of("text"), List.of("text"), List.of());
            Object dssBaseUrl = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().studioExternalUrl;
            if (dssBaseUrl == null) {
                dssBaseUrl = RemoteRunNetworkingUtils.getBaseProtocol() + "://" + RemoteRunNetworkingUtils.getBackendHost() + ":" + RemoteRunNetworkingUtils.getBasePort();
            }
            String agentUrl = (String)dssBaseUrl + "/public/api/projects/" + sm.projectKey + "/agents/" + sm.id + "/a2a";
            return new AgentCard("DSS Agent " + sm.name, sm.description != null ? sm.description : sm.name, agentUrl, provider, "0.1", "", capabilities, List.of("text"), List.of("text"), List.of(skill), false, Collections.emptyMap(), List.of(), "", List.of(new AgentInterface(TransportProtocol.HTTP_JSON.asString(), agentUrl), new AgentInterface(TransportProtocol.JSONRPC.asString(), agentUrl)), TransportProtocol.JSONRPC.asString(), "0.3.3.Final", List.of());
        }
    }
}

