/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.discussions.Discussion;
import com.dataiku.dip.discussions.DiscussionsCacheService;
import com.dataiku.dip.discussions.DiscussionsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ErrorContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/discussions/{objectType}/{objectId}"})
public class PublicAPIDiscussionsController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private DiscussionsCacheService discussionsCacheService;
    @Autowired
    private DiscussionsService discussionsService;
    @Autowired
    private InterestsService interestsService;

    @AuditedCall(value={"msgType", "discussions-list", "projectKey", "${projectKey}", "objectId", "${objectId}", "objectType", "${objectType}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String objectType, @PathVariable String objectId) throws Exception {
        this.checkEnability();
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf((String)objectType);
        if (objectId.contains(".")) {
            throw ErrorContext.iae((String)"Cannot get discussions for foreign object");
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS});
        }
        List discussions = this.discussionsService.getForObject(projectKey, null, taggableType, objectId);
        try (Transaction t = this.transactionService.beginRead();){
            for (Discussion c : discussions) {
                this.discussionsService.enrich(c);
                c.resetRepliesUnsafe();
            }
        }
        PublicAPIDiscussionsController.writeJSON((HttpServletResponse)resp, (Object)discussions);
    }

    @AuditedCall(value={"msgType", "discussions-create", "projectKey", "${projectKey}", "objectId", "${objectId}", "objectType", "${objectType}"})
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void create(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String objectType, @PathVariable String objectId) throws Exception {
        this.checkEnability();
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf((String)objectType);
        if (objectId.contains(".")) {
            throw ErrorContext.iae((String)"Cannot get discussions for foreign object");
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS});
        }
        NewDiscussionMeta ndm = (NewDiscussionMeta)this.getRequestBodyAs(req, NewDiscussionMeta.class);
        this.require(!StringUtils.isBlank((String)ndm.topic), "topic is missing");
        this.require(!StringUtils.isEmpty((String)ndm.reply), "reply is empty");
        Discussion discu = this.discussionsService.create(taggableType, projectKey, null, objectId, ndm.topic, ndm.reply, authCtx);
        this.interestsService.addWatchIfNotExplicit_NT(authCtx.getIdentifier(), taggableType, projectKey, objectId, null);
        PublicAPIDiscussionsController.writeJSON((HttpServletResponse)resp, (Object)discu);
    }

    @AuditedCall(value={"msgType", "discussions-get", "projectKey", "${projectKey}", "objectId", "${objectId}", "objectType", "${objectType}", "discussionId", "${discussionId}"})
    @RequestMapping(value={"/{discussionId}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String objectType, @PathVariable String objectId, @PathVariable String discussionId) throws Exception {
        this.checkEnability();
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf((String)objectType);
        if (objectId.contains(".")) {
            throw ErrorContext.iae((String)"Cannot get discussions for foreign object");
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS});
        }
        Discussion discussion = this.discussionsService.getDiscussion(projectKey, null, discussionId);
        if (discussion.objectType != taggableType) {
            throw ErrorContext.iaef((String)"ObjectType does not match %s %s", (Object)discussion.objectType, (Object[])new Object[]{taggableType.toString()});
        }
        if (!discussion.objectId.equals(objectId)) {
            throw ErrorContext.iaef((String)"ObjectId does not match %s %s", (Object)discussion.objectId, (Object[])new Object[]{objectId});
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.discussionsService.enrich(discussion);
        }
        PublicAPIDiscussionsController.writeJSON((HttpServletResponse)resp, (Object)discussion);
    }

    @AuditedCall(value={"msgType", "discussions-set", "projectKey", "${projectKey}", "objectId", "${objectId}", "objectType", "${objectType}", "discussionId", "${discussionId}"})
    @RequestMapping(value={"/{discussionId}"}, method={RequestMethod.PUT})
    public void set(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String objectType, @PathVariable String objectId, @PathVariable String discussionId) throws Exception {
        this.checkEnability();
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf((String)objectType);
        if (objectId.contains(".")) {
            throw ErrorContext.iae((String)"Cannot get discussions for foreign object");
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS});
        }
        Discussion discussion = this.discussionsService.getDiscussion(projectKey, null, discussionId);
        if (discussion.objectType != taggableType) {
            throw ErrorContext.iaef((String)"ObjectType does not match %s %s", (Object)discussion.objectType, (Object[])new Object[]{taggableType.toString()});
        }
        if (!discussion.objectId.equals(objectId)) {
            throw ErrorContext.iaef((String)"ObjectId does not match %s %s", (Object)discussion.objectId, (Object[])new Object[]{objectId});
        }
        Discussion editedDiscussion = (Discussion)this.getRequestBodyAs(req, Discussion.class);
        if (discussion.closedOn != editedDiscussion.closedOn || !discussion.closedBy.equals(editedDiscussion.closedBy)) {
            if (StringUtils.isNotBlank((String)editedDiscussion.closedBy) && !authCtx.getIdentifier().equals(editedDiscussion.closedBy)) {
                throw ErrorContext.iaef((String)"You are trying to close a discussion but you specified someone else %s", (Object)editedDiscussion.closedBy, (Object[])new Object[0]);
            }
            if (StringUtils.isBlank((String)editedDiscussion.closedBy)) {
                editedDiscussion.closedOn = 0L;
            }
        }
        if (!projectKey.equals(editedDiscussion.projectKey)) {
            throw ErrorContext.iaef((String)"Project key does not match with URL %s %s", (Object)editedDiscussion.projectKey, (Object[])new Object[]{projectKey});
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, editedDiscussion.projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS});
        }
        this.discussionsService.setDiscussion(editedDiscussion, authCtx);
        if (discussion.closedOn != editedDiscussion.closedOn) {
            this.discussionsCacheService.close_NT(new TaggableObjectsService.TaggableObjectRef(projectKey, discussion.objectType, discussion.objectId, discussion.workspaceKey), discussionId, editedDiscussion.closedOn > 0L);
        }
        PublicAPIDiscussionsController.writeJSON((HttpServletResponse)resp, (Object)this.discussionsService.getDiscussion(editedDiscussion.projectKey, null, editedDiscussion.id));
    }

    @AuditedCall(value={"msgType", "discussions-reply", "projectKey", "${projectKey}", "objectId", "${objectId}", "objectType", "${objectType}", "discussionId", "${discussionId}"})
    @RequestMapping(value={"/{discussionId}/replies/"}, method={RequestMethod.POST})
    public void reply(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String objectType, @PathVariable String objectId, @PathVariable String discussionId) throws Exception {
        this.checkEnability();
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf((String)objectType);
        if (objectId.contains(".")) {
            throw ErrorContext.iae((String)"Cannot get discussions for foreign object");
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS});
        }
        Discussion discussion = this.discussionsService.getDiscussion(projectKey, null, discussionId);
        if (discussion.objectType != taggableType) {
            throw ErrorContext.iaef((String)"ObjectType does not match %s %s", (Object)discussion.objectType, (Object[])new Object[]{taggableType.toString()});
        }
        if (!discussion.objectId.equals(objectId)) {
            throw ErrorContext.iaef((String)"ObjectId does not match %s %s", (Object)discussion.objectId, (Object[])new Object[]{objectId});
        }
        NewReplyMeta nrm = (NewReplyMeta)this.getRequestBodyAs(req, NewReplyMeta.class);
        this.discussionsService.reply(taggableType, projectKey, null, objectId, discussionId, null, nrm.reply, authCtx);
        this.interestsService.addWatchIfNotExplicit_NT(authCtx.getIdentifier(), taggableType, projectKey, objectId, null);
        PublicAPIDiscussionsController.writeJSON((HttpServletResponse)resp, (Object)this.discussionsService.getDiscussion(discussion.projectKey, null, discussion.id));
    }

    private void checkEnability() {
        if (!ApplicationConfigurator.getParams().getBoolParam("dku.catalog.discussions.enabled", true)) {
            throw new IllegalArgumentException("Discussions writes were disabled in the instance configuration");
        }
    }

    private class NewDiscussionMeta {
        String topic;
        String reply;

        private NewDiscussionMeta() {
        }
    }

    private class NewReplyMeta {
        String reply;

        private NewReplyMeta() {
        }
    }
}

