/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterpriseAssetCollectionDetails;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterpriseAssetLibraryService;
import com.dataiku.dip.server.enterpriseassetlibrary.EnterprisePromptWithCollectionId;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIEnterpriseAssetLibraryController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private EnterpriseAssetLibraryService enterpriseAssetLibraryService;

    @AuditedCall(value={"msgType", "enterprise-asset-library-list-collections"})
    @RequestMapping(value={"/publicapi/enterprise-asset-library/collections"}, method={RequestMethod.GET})
    @ResponseBody
    public List<EnterpriseAssetCollectionDetails> listCollections(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            List<EnterpriseAssetCollectionDetails> list = this.enterpriseAssetLibraryService.listCollections().stream().filter(collection -> {
                try {
                    return this.enterpriseAssetLibraryService.hasReadPermissionOnEnterpriseAssetCollection(collection.getId(), (DSSAuthCtx)authCtx);
                }
                catch (Exception ignored) {
                    return false;
                }
            }).map(collection -> {
                EnterpriseAssetCollectionDetails details = new EnterpriseAssetCollectionDetails();
                details.id = collection.id;
                details.name = collection.displayName;
                return details;
            }).toList();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "enterprise-asset-library-list-prompts", "restrictCollections", "${restrictCollections}"})
    @RequestMapping(value={"/publicapi/enterprise-asset-library/prompts"}, method={RequestMethod.GET})
    @ResponseBody
    public List<EnterprisePromptWithCollectionId> listPrompts(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) List<String> restrictCollections) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            List<EnterprisePromptWithCollectionId> list = this.enterpriseAssetLibraryService.listCollections().stream().filter(collection -> {
                try {
                    boolean hasReadPermission = this.enterpriseAssetLibraryService.hasReadPermissionOnEnterpriseAssetCollection(collection.getId(), authCtx);
                    if (restrictCollections != null && !restrictCollections.isEmpty()) {
                        return hasReadPermission && restrictCollections.contains(collection.getId());
                    }
                    return hasReadPermission;
                }
                catch (Exception ignored) {
                    return false;
                }
            }).flatMap(collection -> {
                try {
                    return this.enterpriseAssetLibraryService.getPrompts(collection.getId()).values().stream().map(prompt -> new EnterprisePromptWithCollectionId(collection.getId(), prompt));
                }
                catch (Exception ignored) {
                    return Stream.empty();
                }
            }).toList();
            return list;
        }
    }
}

