/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PublicAPIMLflowBaseController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ManagedFoldersService managedFoldersService;

    protected AuthCtx checkRead(HttpServletRequest req, String projectKey) throws DKUSecurityException {
        AuthCtx authCtx = this.authService.getTicketOrKey(req);
        this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        return authCtx;
    }

    protected AuthCtx checkWrite(HttpServletRequest req, String projectKey) throws DKUSecurityException {
        AuthCtx authCtx = this.authService.getTicketOrKey(req);
        this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        return authCtx;
    }

    protected AuthCtx checkAdmin(HttpServletRequest req, String projectKey) throws DKUSecurityException {
        AuthCtx authCtx = this.authService.getTicketOrKey(req);
        this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
        return authCtx;
    }

    protected String getProjectKeyFromHeaders(HttpServletRequest req) {
        String projectKey = req.getHeader("x-dku-mlflow-project-key");
        if (projectKey == null) {
            throw new IllegalArgumentException("Project key not specified in header x-dku-mlflow-project-key");
        }
        return projectKey;
    }

    protected ManagedFolder getManagedFolderFromHeaders(HttpServletRequest req) throws Exception {
        String managedFolderSmartId = req.getHeader("x-dku-mlflow-managed-folder-id");
        AuthCtx authCtx = this.authService.getTicketOrKey(req);
        if (StringUtils.isEmpty((String)managedFolderSmartId)) {
            throw new IllegalArgumentException("Managed folder key not specified in header x-dku-mlflow-managed-folder-id");
        }
        SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName((ITaggingService.TaggableType)ITaggingService.TaggableType.MANAGED_FOLDER, (String)managedFolderSmartId);
        String contextProjectKey = this.getProjectKeyFromHeaders(req);
        String projectKey = smartObjectRef.getProjectKey(contextProjectKey);
        this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        return this.managedFoldersService.getMandatoryUnsafe(projectKey, smartObjectRef.objectId);
    }
}

