/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.AvailablePythonInterpretersService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvUtilsBase;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginSettingsAccessService;
import com.dataiku.dip.plugins.PluginStoreService;
import com.dataiku.dip.plugins.PluginsLoadService;
import com.dataiku.dip.plugins.RegularPluginsRegistryService;
import com.dataiku.dip.plugins.dev.DevPluginsService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.InstalledPluginState;
import com.dataiku.dip.plugins.model.PluginDisplayMetadata;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.PluginValidatorHelper;
import com.dataiku.dip.server.controllers.PluginsController;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/publicapi/plugins"})
public class PublicAPIPluginsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DevPluginsService devPluginsService;
    @Autowired
    private PluginStoreService pluginStoreService;
    @Autowired
    private PluginsLoadService pluginsLoadService;
    @Autowired
    private PluginSettingsAccessService pluginSettingsAccessService;
    @Autowired
    private RegularPluginsRegistryService registryService;
    @Autowired
    private IPluginsRegistryService pluginsRegistry;
    @Autowired
    private DesignNodeCodeEnvsService designNodeEnvsService;
    @Autowired
    private AutomationNodeCodeEnvsService automationNodeEnvsService;
    @Autowired
    private AvailablePythonInterpretersService availablePythonInterpretersService;
    @Autowired
    private FutureService futureService;
    @Autowired
    PluginUsagesInspector pluginUsagesInspector;
    private static final Logger logger = Logger.getLogger((String)"dku.plugins");

    @AuditedCall(value={"msgType", "plugins-list"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void listPlugins(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Collection loadedPlugins;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
            loadedPlugins = this.pluginsLoadService.getLoadedPlugins();
        }
        PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, loadedPlugins.stream().map(ShortPluginDesc::new).toList());
    }

    @AuditedCall(value={"msgType", "plugin-download", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/download"}, method={RequestMethod.GET})
    public void downloadDevPlugin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        String now = DKUtils.getDateFormatter((String)"_yyyy_MM_dd").print(new Date().getTime());
        String dlName = "dssPlugin_" + pluginId + "_" + now + ".zip";
        String cd = String.format("attachment; filename=\"%s\"", dlName);
        resp.setHeader("Content-Disposition", cd);
        this.devPluginsService.streamPluginContent_NT(pluginId, (OutputStream)resp.getOutputStream());
    }

    @AuditedCall(value={"msgType", "plugin-install-from-zip", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/actions/installFromZip"}, method={RequestMethod.POST})
    public void installFromZip(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        this.installStreamAsPlugin(req, resp, filePart, false);
    }

    @AuditedCall(value={"msgType", "plugin-install-from-zip", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/actions/future/installFromZip"}, method={RequestMethod.POST})
    public void installFromZipWithFuture(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        this.installStreamAsPluginWithFuture(req, resp, filePart, false);
    }

    @AuditedCall(value={"msgType", "plugin-install-from-store", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/actions/installFromStore"}, method={RequestMethod.POST})
    public void installFromStore(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        InstallFromStoreParams params = (InstallFromStoreParams)this.getRequestBodyAs(req, InstallFromStoreParams.class);
        PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginStoreService.downloadAndInstall(params.pluginId, authCtx, false));
    }

    @AuditedCall(value={"msgType", "plugin-install-from-git", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/actions/installFromGit"}, method={RequestMethod.POST})
    public void installFromGit(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        InstallFromGitParams params = (InstallFromGitParams)this.getRequestBodyAs(req, InstallFromGitParams.class);
        PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginStoreService.startCloneAndInstall(params.gitRepositoryUrl, params.gitCheckout, params.gitSubpath, authCtx, false));
    }

    @AuditedCall(value={"msgType", "plugin-update-from-zip", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/actions/updateFromZip"}, method={RequestMethod.POST})
    public void updateFromZip(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        this.installStreamAsPlugin(req, resp, filePart, true);
    }

    @AuditedCall(value={"msgType", "plugin-update-from-zip", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/actions/future/updateFromZip"}, method={RequestMethod.POST})
    public void updateFromZipWithFuture(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        this.installStreamAsPluginWithFuture(req, resp, filePart, true);
    }

    @AuditedCall(value={"msgType", "plugin-update-from-store", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/actions/updateFromStore"}, method={RequestMethod.POST})
    public void updateFromStore(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginStoreService.downloadAndInstall(pluginId, authCtx, true));
    }

    @AuditedCall(value={"msgType", "plugin-update-from-git", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/actions/updateFromGit"}, method={RequestMethod.POST})
    public void updateFromGit(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        InstallFromGitParams params;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            params = (InstallFromGitParams)this.getRequestBodyAs(req, InstallFromGitParams.class);
            if (StringUtils.isBlank((String)params.gitRepositoryUrl)) {
                File stateFile = new File(this.registryService.getActualPluginFolder(pluginId), "state.json");
                if (!stateFile.exists()) {
                    throw new IllegalArgumentException("No Git repository specified to update plugin");
                }
                InstalledPluginState pluginState = (InstalledPluginState)JSON.parseFile((File)stateFile, InstalledPluginState.class);
                params.gitRepositoryUrl = pluginState.gitState.repository;
                params.gitCheckout = pluginState.gitState.checkout;
                params.gitSubpath = pluginState.gitState.path;
            }
        }
        PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginStoreService.startCloneAndInstall(params.gitRepositoryUrl, params.gitCheckout, params.gitSubpath, authCtx, true));
    }

    @AuditedCall(value={"msgType", "plugin-move-to-dev"})
    @RequestMapping(value={"/{pluginId}/actions/moveToDev"}, method={RequestMethod.POST})
    public void moveToDev(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginStoreService.movePluginToDev_NT(pluginId));
    }

    private void installStreamAsPluginWithFuture(HttpServletRequest req, HttpServletResponse resp, MultipartFile filePart, boolean isUpdate) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        logger.info((Object)("Uploading " + filePart.getOriginalFilename()));
        AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"plugin-uploads");
        FileUtils.copyInputStreamToFile((InputStream)filePart.getInputStream(), (File)this.pluginStoreService.getPluginArchive((File)tmpDir));
        logger.info((Object)"Plugin received, installing it");
        PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginStoreService.startUploadAndInstall(tmpDir, authCtx, isUpdate));
    }

    private void installStreamAsPlugin(HttpServletRequest req, HttpServletResponse resp, MultipartFile filePart, boolean isUpdate) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        logger.info((Object)("Uploading " + filePart.getOriginalFilename()));
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"plugin-uploads");){
            File pluginArchive = this.pluginStoreService.getPluginArchive((File)tmpDir);
            FileUtils.copyInputStreamToFile((InputStream)filePart.getInputStream(), (File)pluginArchive);
            logger.info((Object)"Plugin received, installing it");
            PluginStoreService.InstallationResult ret = this.pluginStoreService.installUploaded(authCtx, pluginArchive, isUpdate, null);
            if (!ret.success) {
                throw new Exception(ret.errorMessage);
            }
            PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "plugindev-get", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/contents"}, method={RequestMethod.GET})
    public void listPluginContents(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
            PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.devPluginsService.getDevPluginContent_NT(pluginId));
        }
    }

    @AuditedCall(value={"msgType", "plugindev-get", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/details/**"}, method={RequestMethod.GET})
    public void getFileDetails(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        String itemPath = PublicAPIPluginsController.extractPathFromRequest((HttpServletRequest)req);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        t = this.devPluginsService.getTransactionProvider(pluginId).beginRead();
        try {
            PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.devPluginsService.getFileDetails(pluginId, itemPath, t));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "plugindev-get", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/contents/**"}, method={RequestMethod.GET})
    public void getPluginContent(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        String itemPath = PublicAPIPluginsController.extractPathFromRequest((HttpServletRequest)req);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        this.devPluginsService.getRawDevPluginContent_NT(resp, pluginId, itemPath);
    }

    @AuditedCall(value={"msgType", "plugindev-edit", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/contents/**"}, method={RequestMethod.POST})
    public void setPluginContent(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        String itemPath = PublicAPIPluginsController.extractPathFromRequest((HttpServletRequest)req);
        if (Strings.isNullOrEmpty((String)itemPath)) {
            throw new IllegalArgumentException("No file path retrieved from request");
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        byte[] requestBodyAsByteArray = IOUtils.toByteArray((InputStream)req.getInputStream());
        String data = new String(requestBodyAsByteArray, StandardCharsets.UTF_8);
        this.devPluginsService.setOrAddDevPluginContent_NT(pluginId, itemPath, data, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-add-folder", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/folders/**"}, method={RequestMethod.POST})
    public void addPluginFolder(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        String itemPath = PublicAPIPluginsController.extractPathFromRequest((HttpServletRequest)req);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        this.devPluginsService.addDevPluginContent_NT(pluginId, itemPath, true, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-delete", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/contents/**"}, method={RequestMethod.DELETE})
    public void deletePluginContent(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        String itemPath = PublicAPIPluginsController.extractPathFromRequest((HttpServletRequest)req);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        this.devPluginsService.removeDevPluginContent_NT(pluginId, itemPath, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-rename", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/contents-actions/rename"}, method={RequestMethod.POST})
    public void renamePluginContent(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        RenameParameters renameParameters = (RenameParameters)this.getRequestBodyAs(req, RenameParameters.class);
        if (Strings.isNullOrEmpty((String)renameParameters.oldPath)) {
            throw new IllegalArgumentException("Old path should not be empty");
        }
        if (Strings.isNullOrEmpty((String)renameParameters.newName)) {
            throw new IllegalArgumentException("New name should not be empty");
        }
        if (renameParameters.newName.contains("/")) {
            throw new IllegalArgumentException("Invalid character '/' in " + renameParameters.newName);
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        this.devPluginsService.renameDevPluginContent_NT(pluginId, renameParameters.oldPath, renameParameters.newName, authCtx);
    }

    @AuditedCall(value={"msgType", "plugindev-move", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/contents-actions/move"}, method={RequestMethod.POST})
    public void movePluginContent(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        MoveParameters moveParameters = (MoveParameters)this.getRequestBodyAs(req, MoveParameters.class);
        if (Strings.isNullOrEmpty((String)moveParameters.oldPath)) {
            throw new IllegalArgumentException("Old path should not be empty");
        }
        if (Strings.isNullOrEmpty((String)moveParameters.newPath)) {
            throw new IllegalArgumentException("New path should not be empty");
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        this.devPluginsService.moveDevPluginContent_NT(pluginId, moveParameters.oldPath, moveParameters.newPath, authCtx);
    }

    @AuditedCall(value={"msgType", "plugin-get-settings", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/settings"}, method={RequestMethod.GET})
    public void getPluginSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId, @RequestParam(defaultValue="") String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            boolean allowed;
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            boolean bl = allowed = authCtx.isAdmin() || authCtx.getPermissions().mayDevelopPlugins() && this.devPluginsService.isPluginDev(pluginId);
            if (!allowed) {
                throw new UnauthorizedException("Action forbidden", "plugin-save-settings");
            }
            PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginSettingsAccessService.get((AuthCtx)authCtx, pluginId, StringUtils.defaultIfBlank((String)projectKey, null)));
        }
    }

    @AuditedCall(value={"msgType", "plugin-set-settings", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/settings"}, method={RequestMethod.POST, RequestMethod.PUT})
    public void savePluginSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId, @RequestParam(defaultValue="") String projectKey) throws Exception {
        PluginSettingsAccessService.PluginSettingsSaveResult result = null;
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.checkSavePermissions(authCtx, pluginId);
            PluginSettingsAccessService.PluginUISettings settings = (PluginSettingsAccessService.PluginUISettings)this.getRequestBodyAs(req, PluginSettingsAccessService.PluginUISettings.class);
            result = this.pluginSettingsAccessService.save((AuthCtx)authCtx, pluginId, projectKey, settings);
            t.commit("Saved settings on plugin " + pluginId);
        }
        if (result != null) {
            PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginSettingsAccessService.handleSavePostActions(result, null));
        }
    }

    @AuditedCall(value={"msgType", "plugin-set-settings", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/settings/future"}, method={RequestMethod.POST, RequestMethod.PUT})
    public void savePluginSettingsWithFuture(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId, @RequestParam(defaultValue="") String projectKey) throws Exception {
        PluginSettingsAccessService.PluginSettingsSaveResult result = null;
        DSSAuthCtx authCtx = null;
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.checkSavePermissions(authCtx, pluginId);
            PluginSettingsAccessService.PluginUISettings settings = (PluginSettingsAccessService.PluginUISettings)this.getRequestBodyAs(req, PluginSettingsAccessService.PluginUISettings.class);
            result = this.pluginSettingsAccessService.save((AuthCtx)authCtx, pluginId, projectKey, settings);
            t.commit("Saved settings on plugin " + pluginId);
        }
        if (result != null) {
            PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.futureService.runFuture((FutureThreadBase)this.pluginSettingsAccessService.getSavePostActionFuture((AuthCtx)authCtx, pluginId, result), 0L, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){}));
        }
    }

    private void checkSavePermissions(DSSAuthCtx authCtx, String pluginId) throws UnauthorizedException {
        boolean allowed;
        boolean bl = allowed = authCtx.isAdmin() || authCtx.getPermissions().mayDevelopPlugins() && this.devPluginsService.isPluginDev(pluginId);
        if (!allowed) {
            throw new UnauthorizedException("Action forbidden", "plugin-save-settings");
        }
    }

    @AuditedCall(value={"msgType", "plugin-update-code-env", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/code-env/actions/update"}, method={RequestMethod.POST})
    public void updateCodeEnv(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        CodeEnvModel.EnvLang codeEnvLang;
        String codeEnvName;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            codeEnvName = this.pluginsRegistry.getSettings((String)pluginId).codeEnvName;
            InstalledPluginDesc installedPluginDesc = this.pluginsRegistry.getInstalledDesc(pluginId);
            codeEnvLang = installedPluginDesc.codeEnvLang;
            this.permissionsService.checkCodeEnvPrivileges(authCtx, codeEnvLang, codeEnvName, new Privileges.CodeEnvLevelPrivilegeType[]{Privileges.CodeEnvLevelPrivilegeType.UPDATE});
        }
        if (StringUtils.isBlank((String)codeEnvName)) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_WITHOUT_CODEENV, "The plugin " + pluginId + " doesn't specify a code env, cannot update");
        }
        CodeEnvModel.CodeEnvUpdateSettings updateSettings = (CodeEnvModel.CodeEnvUpdateSettings)this.getRequestBodyAsOrNull(req, CodeEnvModel.CodeEnvUpdateSettings.class);
        if (updateSettings == null) {
            updateSettings = new CodeEnvModel.CodeEnvUpdateSettings();
        }
        File pluginEnvFolder = DKUFileUtils.build((File)this.pluginsRegistry.getActualPluginFolder(pluginId), (String[])new String[]{"code-env", codeEnvLang.getFolderName()});
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.automationNodeEnvsService.startUpdatePluginEnv(authCtx, codeEnvLang, codeEnvName, pluginEnvFolder, updateSettings, pluginId));
                break;
            }
            case DESIGN: {
                PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.designNodeEnvsService.startUpdatePluginEnv(authCtx, codeEnvLang, codeEnvName, pluginEnvFolder, updateSettings, pluginId));
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
    }

    @AuditedCall(value={"msgType", "plugin-create-code-env", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/code-env/actions/create"}, method={RequestMethod.POST})
    public void createCodeEnv(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        CodeEnvModel.AbstractEnvDesc envDesc;
        CodeEnvModel.EnvLang codeEnvLang;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            InstalledPluginDesc installedPluginDesc = this.pluginsRegistry.getInstalledDescMand(pluginId);
            codeEnvLang = installedPluginDesc.codeEnvLang;
            this.permissionsService.checkCreateCodeEnvPrivilege(authCtx);
        }
        if (codeEnvLang == null) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_WITHOUT_CODEENV, "The plugin " + pluginId + " doesn't specify a code env, cannot create it");
        }
        if (codeEnvLang == CodeEnvModel.EnvLang.PYTHON) {
            envDesc = (CodeEnvModel.AbstractEnvDesc)this.getRequestBodyAs(req, CodeEnvModel.PythonEnvDesc.class);
        } else if (codeEnvLang == CodeEnvModel.EnvLang.R) {
            envDesc = (CodeEnvModel.AbstractEnvDesc)this.getRequestBodyAs(req, CodeEnvModel.REnvDesc.class);
        } else {
            throw new Error("unreachable");
        }
        String initialEnvName = "plugin_" + pluginId + "_" + (envDesc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED ? "managed" : "non_managed");
        StringTransmogrifier st = new StringTransmogrifier();
        for (String name : CodeEnvUtilsBase.getEnvNamesSet()) {
            st.addAlreadyTransmogrified(name);
        }
        String envName = st.transmogrify(initialEnvName);
        File envFolder = DKUFileUtils.build((File)this.pluginsRegistry.getActualPluginFolder(pluginId), (String[])new String[]{"code-env", codeEnvLang.getFolderName()});
        File unzipDir = CodeEnvUtilsBase.preparePluginImport((File)envFolder, (CodeEnvModel.EnvLang)codeEnvLang, (CodeEnvModel.AbstractEnvDesc)envDesc, (List)this.availablePythonInterpretersService.getAvailablePythonInterpreters());
        CodeEnvModel.CodeEnvUpdateSettings updateSettings = new CodeEnvModel.CodeEnvUpdateSettings();
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.automationNodeEnvsService.startImportEnv(authCtx, authCtx.getIdentifier(), envDesc.deploymentMode, envName, codeEnvLang, unzipDir, unzipDir, updateSettings, pluginId, false, null, false));
                break;
            }
            case DESIGN: {
                PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.designNodeEnvsService.startImportEnv(authCtx, authCtx.getIdentifier(), envDesc.deploymentMode, envName, codeEnvLang, unzipDir, unzipDir, updateSettings, pluginId, false, null, false));
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
    }

    @AuditedCall(value={"msgType", "plugin-list-usages", "pluginId", "${pluginId}", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{pluginId}/actions/listUsages"}, method={RequestMethod.GET})
    public void listUsages(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId, @RequestParam(required=false) String projectKey) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginUsagesInspector.getUsages(authCtx, projectKey, pluginId));
    }

    @AuditedCall(value={"msgType", "plugin-delete", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/actions/delete"}, method={RequestMethod.POST})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        this.pluginUsagesInspector.restrictToAdminAndDevPluginDeveloper(authCtx, pluginId);
        InstalledPluginDesc installedDesc = PluginsController.getInstalledPluginDesc((IPluginsRegistryService)this.pluginsRegistry, (String)pluginId);
        PluginValidatorHelper.checkDeletablePlugin((InstalledPluginDesc)installedDesc);
        DeleteParams params = (DeleteParams)this.getRequestBodyAs(req, DeleteParams.class);
        if (!params.force) {
            PluginUsagesInspector.PluginUsages usages = this.pluginUsagesInspector.getUsages(null, pluginId);
            if (!usages.usages.isEmpty()) {
                throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_USED_PLUGIN_DELETION, "The plugin " + pluginId + " is used; its deletion may be forced");
            }
            if (!usages.missingTypes.isEmpty()) {
                throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_USED_PLUGIN_DELETION, "Types were missing when looking for usages of the plugin " + pluginId + "; its deletion may be forced");
            }
        }
        PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginStoreService.remove(pluginId, authCtx));
    }

    public static class InstallFromStoreParams {
        public String pluginId;
    }

    public static class InstallFromGitParams {
        public String gitRepositoryUrl;
        public String gitCheckout;
        public String gitSubpath;
    }

    private static class RenameParameters {
        public String oldPath;
        public String newName;

        private RenameParameters() {
        }
    }

    private static class MoveParameters {
        public String oldPath;
        public String newPath;

        private MoveParameters() {
        }
    }

    public static class DeleteParams {
        public boolean force = false;
    }

    public static class ShortPluginDesc {
        public final boolean isDev;
        public final String id;
        public final PluginDisplayMetadata meta;
        public final String version;

        public ShortPluginDesc(InstalledPluginDesc ipd) {
            this.isDev = ipd.origin == InstalledPluginDesc.PluginOrigin.DEV;
            this.id = ipd.desc.id;
            this.meta = ipd.desc.meta;
            this.version = ipd.desc.version;
        }
    }
}

