/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.auth;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIPermissionsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.security.permissions.api");

    @AuditedCall(value={"msgType", "security-check-objects-permissions"})
    @RequestMapping(value={"/publicapi/permissions/actions/check-objects"}, method={RequestMethod.POST})
    @ResponseBody
    public PermissionCheckResponse checkObjectsPermissions(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        PermissionCheckRequest preq = (PermissionCheckRequest)this.getRequestBodyAs(req, PermissionCheckRequest.class);
        PermissionCheckResponse presp = new PermissionCheckResponse();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            for (PermissionCheckRequestItem reqItem : preq.items) {
                PermissionCheckResponseItem respItem = new PermissionCheckResponseItem();
                respItem.objectType = reqItem.objectType;
                respItem.objectProjectKey = reqItem.objectProjectKey;
                respItem.objectId = reqItem.objectId;
                respItem.mode = reqItem.mode;
                try {
                    respItem.permitted = this.projectsService.hasPermissionRegardlessOfContext(authCtx, reqItem.objectProjectKey, reqItem.objectType, reqItem.objectId, reqItem.mode);
                }
                catch (Exception e) {
                    logger.warn((Object)("Could not check permissions for " + JSON.log((Object)reqItem)), (Throwable)e);
                }
                presp.items.add(respItem);
            }
        }
        return presp;
    }

    public static class PermissionCheckRequest {
        public List<PermissionCheckRequestItem> items = new ArrayList<PermissionCheckRequestItem>();
    }

    public static class PermissionCheckResponse {
        public List<PermissionCheckResponseItem> items = new ArrayList<PermissionCheckResponseItem>();
    }

    public static class PermissionCheckRequestItem {
        public ITaggingService.TaggableType objectType;
        public String objectProjectKey;
        public String objectId;
        public SerializedProject.ReaderAuthorization.Mode mode = SerializedProject.ReaderAuthorization.Mode.READ;
    }

    public static class PermissionCheckResponseItem
    extends PermissionCheckRequestItem {
        public boolean permitted;
    }
}

