/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.integrations;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.IntegrationChannelHead;
import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.integrations.IntegrationChannelsRegistry;
import com.dataiku.dip.integrations.mail.Mail;
import com.dataiku.dip.integrations.mail.MailChannelConfiguration;
import com.dataiku.dip.scheduler.IntegrationChannelsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.IntegrationChannelPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.notifications.emails.IEmailService;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.google.common.base.Preconditions;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/publicapi/messaging-channels"})
public class PublicAPIIntegrationChannelsController
extends PublicAPIControllerBase {
    @Autowired
    private IntegrationChannelsDAO integrationChannelsDAO;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IEmailService emailService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private PasswordEncryptionService symmetricCryptoService;

    @RequestMapping(value={"/"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<IntegrationChannelHead> list(HttpServletRequest req, @RequestParam(required=false) String channelFamily, @RequestParam(required=false) String channelType) throws Exception {
        String dssEmail;
        List channels;
        Preconditions.checkArgument((boolean)PublicAPIIntegrationChannelsController.checkChannelType(channelType), (String)"Unknown messaging channel type: %s", (Object)channelType);
        Preconditions.checkArgument((boolean)PublicAPIIntegrationChannelsController.checkChannelFamily(channelFamily), (String)"Unknown messaging channel family: %s", (Object)channelFamily);
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getTicketOrKey(req);
            channels = this.integrationChannelsDAO.list();
            dssEmail = this.generalSettingsDAO.getUnsafe().studioMailAddress;
        }
        return channels.stream().map(channel -> PublicAPIIntegrationChannelsController.createIntegrationChannelHead(channel, dssEmail)).filter(channel -> StringUtils.isBlank((CharSequence)channelFamily) || channelFamily.equals(channel.family)).filter(channel -> StringUtils.isBlank((CharSequence)channelType) || IntegrationChannelsRegistry.getMeta((String)channelType).getType().equals(channel.type)).toList();
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public IntegrationChannelHead create(HttpServletRequest req, @RequestBody IntegrationChannel messagingChannel) throws IOException, DKUSecurityException {
        String dssEmail;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        String id = messagingChannel.getId();
        messagingChannel.withId(id == null || id.isBlank() ? SecretKeyGenerator.generate((int)8) : id.trim());
        IntegrationChannelParams configuration = messagingChannel.getConfiguration();
        if (configuration == null) {
            throw new IllegalArgumentException("Messaging channel configuration not provided");
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            List messagingChannels = this.integrationChannelsDAO.list();
            Preconditions.checkArgument((boolean)messagingChannels.stream().noneMatch(channel -> Objects.equals(channel.getId(), messagingChannel.getId())), (String)"Messaging channel ID already exists: %s", (Object)messagingChannel.getId());
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.getUnsafe();
            if (generalSettings.security.secureSecretKeys) {
                messagingChannel.getConfiguration().encryptFields(this.symmetricCryptoService);
            }
            messagingChannels.add(messagingChannel);
            this.integrationChannelsDAO.save(messagingChannels);
            dssEmail = generalSettings.studioMailAddress;
            t.commit("Saved messaging channel with ID: " + messagingChannel.getId());
        }
        return PublicAPIIntegrationChannelsController.createIntegrationChannelHead(messagingChannel, dssEmail);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public IntegrationChannelHead get(HttpServletRequest req, @PathVariable(value="id") String channelId) throws IOException, DKUSecurityException {
        String dssEmail;
        IntegrationChannel channel;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getTicketOrKey(req);
            channel = this.integrationChannelsDAO.getMandatory(channelId);
            dssEmail = this.generalSettingsDAO.getUnsafe().studioMailAddress;
        }
        return PublicAPIIntegrationChannelsController.createIntegrationChannelHead(channel, dssEmail);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest req, @PathVariable(value="id") String channelId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        t = this.transactionService.beginWriteForAPI(req);
        try {
            List messagingChannels = this.integrationChannelsDAO.list();
            Preconditions.checkArgument((boolean)messagingChannels.stream().anyMatch(channel -> Objects.equals(channel.getId(), channelId)), (String)"Messaging channel ID not found: %s", (Object)channelId);
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsService.read();
            boolean isSetAsNotificationEmailsChannel = Objects.equals(generalSettings.notifications.emailChannelId, channelId);
            if (isSetAsNotificationEmailsChannel) {
                generalSettings.notifications.emailChannelId = null;
                this.generalSettingsService.save(authCtx, generalSettings);
            }
            this.integrationChannelsDAO.save(messagingChannels.stream().filter(channel -> !Objects.equals(channel.getId(), channelId)).toList());
            t.commit("Deleted messaging channel with ID: " + channelId + (isSetAsNotificationEmailsChannel ? " (unset from general settings notification emails)" : ""));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @RequestMapping(value={"/{id}/settings"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public IntegrationChannelParams getSettings(HttpServletRequest req, @PathVariable(value="id") String channelId) throws IOException, DKUSecurityException {
        IntegrationChannel messagingChannel;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            messagingChannel = this.integrationChannelsDAO.getMandatory(channelId);
        }
        return messagingChannel.configuration;
    }

    @RequestMapping(value={"/{id}/settings"}, method={RequestMethod.PUT})
    public void setSettings(HttpServletRequest req, @PathVariable(value="id") String channelId) throws IOException, IllegalArgumentException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        t = this.transactionService.beginWriteForAPI(req);
        try {
            List messagingChannels = this.integrationChannelsDAO.list();
            IntegrationChannel messagingChannel = messagingChannels.stream().filter(channel -> Objects.equals(channel.getId(), channelId)).findFirst().orElse(null);
            if (messagingChannel == null) {
                throw new IllegalArgumentException("Settings for messaging channel ID not found: " + channelId);
            }
            IntegrationChannelParams messagingChannelConfiguration = (IntegrationChannelParams)this.getRequestBodyAs(req, IntegrationChannelsRegistry.getMeta((String)messagingChannel.type).paramsClass());
            if (this.generalSettingsDAO.getUnsafe().security.secureSecretKeys) {
                messagingChannelConfiguration.encryptFields(this.symmetricCryptoService);
            }
            this.integrationChannelsDAO.save(messagingChannels.stream().map(channel -> Objects.equals(channel.getId(), channelId) ? channel.withConfiguration(messagingChannelConfiguration) : channel).toList());
            t.commit("Saved settings for messaging channel with ID: " + channelId);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @RequestMapping(value={"/{id}/permissions"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<IntegrationChannelPermissionsService.IntegrationChannelPermissionItem> getPermissions(HttpServletRequest req, @PathVariable(value="id") String channelId) throws IOException, DKUSecurityException {
        IntegrationChannel messagingChannel;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            messagingChannel = this.integrationChannelsDAO.getMandatory(channelId);
        }
        return messagingChannel.permissions;
    }

    @RequestMapping(value={"/{id}/permissions"}, method={RequestMethod.PUT})
    public void setPermissions(HttpServletRequest req, @PathVariable(value="id") String channelId) throws IOException, IllegalArgumentException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        t = this.transactionService.beginWriteForAPI(req);
        try {
            List messagingChannels = this.integrationChannelsDAO.list();
            IntegrationChannel messagingChannel = messagingChannels.stream().filter(channel -> Objects.equals(channel.getId(), channelId)).findFirst().orElse(null);
            if (messagingChannel == null) {
                throw new IllegalArgumentException("Permissions for messaging channel ID not found: " + channelId);
            }
            List permissions = (List)this.getRequestBodyAs(req, (TypeToken)new TypeToken<List<IntegrationChannelPermissionsService.IntegrationChannelPermissionItem>>(){});
            permissions.removeIf(perm -> perm.group == null && perm.user == null);
            this.integrationChannelsDAO.save(messagingChannels.stream().map(channel -> Objects.equals(channel.getId(), channelId) ? channel.withPermissions(permissions) : channel).toList());
            t.commit("Saved permissions for messaging channel with ID: " + channelId);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @RequestMapping(value={"/{id}/actions/send"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public void send(MultipartHttpServletRequest req, @PathVariable(value="id") String channelId, @RequestParam String projectKey, @RequestPart Mail message, @RequestPart(required=false) List<MultipartFile> attachments) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getTicketOrKey((HttpServletRequest)req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        if (message.to == null || message.to.isEmpty()) {
            throw new IllegalArgumentException("At least one recipient in 'to' must be specified");
        }
        this.emailService.send(user, channelId, message, attachments);
    }

    private static boolean checkChannelType(String channelType) {
        if (StringUtils.isBlank((CharSequence)channelType)) {
            return true;
        }
        try {
            IntegrationChannelsRegistry.getMeta((String)channelType);
            return true;
        }
        catch (Error e) {
            return false;
        }
    }

    private static boolean checkChannelFamily(String channelTypeFamily) {
        return StringUtils.isBlank((CharSequence)channelTypeFamily) || channelTypeFamily.equals("mail");
    }

    private static IntegrationChannelHead createIntegrationChannelHead(IntegrationChannel channel, String dssEmail) {
        IntegrationChannelHead channelHead = new IntegrationChannelHead();
        channelHead.id = channel.id;
        channelHead.type = channel.type;
        if (channel.getConfiguration() instanceof MailChannelConfiguration) {
            MailChannelConfiguration config = (MailChannelConfiguration)channel.getConfiguration();
            channelHead.family = "mail";
            channelHead.useCurrentUserAsSender = config.useCurrentUserAsSender;
            channelHead.sender = config.useCurrentUserAsSender ? (StringUtils.isNotBlank((CharSequence)config.sender) ? config.sender : dssEmail) : config.sender;
        }
        return channelHead;
    }
}

