/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.projects;

import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.aiexplanations.ExplainStuffFrontendResponse;
import com.dataiku.dip.aiexplanations.flow.AIFlowExplanationService;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.FlowZone;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.pivot.frontend.color.Color;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.api.projects.PublicAPIFlowController;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/flow/zones"})
public class PublicAPIFlowZonesController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private ZonesDAO zonesDAO;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private AIFlowExplanationService aiFlowExplanationService;
    @Autowired
    private FutureService futureService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.api.projects.flow.zones");

    @AuditedCall(value={"msgType", "flow-zone-create", "projectKey", "${projectKey}"})
    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseBody
    public Zone createZone(HttpServletRequest req, @PathVariable String projectKey, @RequestBody Zone data) throws DKUSecurityException, IOException {
        this.require(StringUtils.isNotBlank((String)data.getColor()), "Required field 'color' is missing.");
        this.require(StringUtils.isNotBlank((String)data.getName()), "Required field 'name' is missing.");
        Color.fromHTML((String)data.getColor());
        data.setId(null);
        data.getShared().clear();
        data.getItems().clear();
        data.setProjectKey(projectKey);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.flowZonesService.create(projectKey, data, authCtx);
            this.flowGraphService.invalidateCache(projectKey);
            t.commit("Created zone");
        }
        return data;
    }

    @AuditedCall(value={"msgType", "flow-zones-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<Zone> retrieveZones(HttpServletRequest req, @PathVariable String projectKey) throws DKUSecurityException, IOException {
        List zones;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            zones = this.zonesDAO.listUnsafe(projectKey);
        }
        return zones;
    }

    @AuditedCall(value={"msgType", "flow-zone-get", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/{zoneId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Zone retrieveZone(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String zoneId) throws DKUSecurityException, IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            Zone zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneId);
            this.flowZonesService.enrichWithItemsUnsafe(zone);
            Zone zone2 = zone;
            return zone2;
        }
    }

    @AuditedCall(value={"msgType", "flow-zone-update", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/{zoneId}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateZone(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String zoneId, @RequestBody ZoneUpdate zoneUpdate) throws DKUSecurityException, IOException {
        this.require(StringUtils.isNotBlank((String)zoneUpdate.name), "Required field 'name' is missing.");
        this.require(StringUtils.isNotBlank((String)zoneUpdate.color), "Required field 'color' is missing.");
        Color.fromHTML((String)zoneUpdate.color);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            Zone zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneId);
            zone.setColor(zoneUpdate.color);
            zone.setName(zoneUpdate.name);
            zone.shortDesc = zoneUpdate.shortDesc;
            zone.tags = zoneUpdate.tags;
            zone.description = zoneUpdate.description;
            zone.customFields = zoneUpdate.customFields;
            this.flowZonesService.edit(projectKey, zone, authCtx);
            this.flowGraphService.invalidateCache(projectKey);
            t.commitV("Zone:%s updated", new Object[]{zone.getId()});
        }
    }

    @AuditedCall(value={"msgType", "flow-zone-delete", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/{zoneId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteZone(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String zoneId) throws DKUSecurityException, IOException {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.flowZonesService.delete(projectKey, zoneId, authCtx);
            t.commitV("Zone:%s deleted", new Object[]{zoneId});
        }
        this.flowGraphService.invalidateCache(projectKey);
    }

    @AuditedCall(value={"msgType", "flow-zone-items-list", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/{zoneId}/items"}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<SmartObjectRef> retrieveZoneItems(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String zoneId) throws DKUSecurityException, IOException {
        Zone zone;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneId);
            this.flowZonesService.enrichWithItemsUnsafe(zone);
        }
        return zone.getItems();
    }

    @AuditedCall(value={"msgType", "flow-zone-item-add", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/{zoneId}/items"}, method={RequestMethod.POST})
    @ResponseBody
    public Zone addZoneItem(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String zoneId, @RequestBody SmartObjectRef data) throws DKUSecurityException, IOException {
        Zone zone;
        this.require(this.isValidType(data.objectType), "Required field 'objectType' is not a flow computable, a recipe or a labeling task.");
        SmartObjectRef item = SmartObjectRef.fromResolved((ITaggingService.TaggableType)data.objectType, (String)data.projectKey, (String)data.objectId, (String)projectKey);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.zonesDAO.getMandatory(projectKey, zoneId);
            if (!this.taggableObjectsReadService.exists(item.toTaggableObjectRef(projectKey))) {
                throw new NotFoundException(String.format("Item of type: %s with id: %s does not exist", item.objectType, item.getSmartName()));
            }
            List impacts = this.flowZonesService.attachObjectToZoneWithImpacts(zoneId, projectKey, item, true);
            zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneId);
            t.commitV("Item:%s added to the zone:%s" + (impacts.isEmpty() ? "" : String.format(" and %d impacted items have been moved also", impacts.size())), new Object[]{item.getSmartName(), zone.getId()});
        }
        this.flowGraphService.invalidateCache();
        return zone;
    }

    @AuditedCall(value={"msgType", "flow-zone-add-items", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/{zoneId}/add-items"}, method={RequestMethod.POST})
    @ResponseBody
    public Zone addZoneItems(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String zoneId, @RequestBody List<SmartObjectRef> itemsSerialised) throws DKUSecurityException, IOException {
        Zone zone;
        itemsSerialised.forEach(i -> this.require(this.isValidType(i.objectType), "Required field 'objectType' is not a flow computable or a recipe."));
        List items = itemsSerialised.stream().map(i -> SmartObjectRef.fromResolved((ITaggingService.TaggableType)i.objectType, (String)i.projectKey, (String)i.objectId, (String)projectKey)).collect(Collectors.toList());
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.zonesDAO.getMandatory(projectKey, zoneId);
            ArrayList impacts = new ArrayList();
            for (SmartObjectRef item : items) {
                if (this.taggableObjectsReadService.exists(item.toTaggableObjectRef(projectKey))) continue;
                throw new NotFoundException(String.format("Item of type: %s with id: %s does not exist", item.objectType, item.getSmartName()));
            }
            for (SmartObjectRef item : items) {
                impacts.addAll(this.flowZonesService.attachObjectToZoneWithImpacts(zoneId, projectKey, item, false));
            }
            this.flowGraphService.invalidateCache(projectKey);
            zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneId);
            t.commitV("Items:%s added to the zone:%s" + (impacts.isEmpty() ? "" : String.format(" and %d impacted items have been moved also", impacts.size())), new Object[]{items.stream().map(SmartObjectRef::getSmartName).collect(Collectors.joining(",")), zone.getId()});
        }
        this.flowGraphService.invalidateCache();
        return zone;
    }

    @AuditedCall(value={"msgType", "flow-zone-shared-list", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/{zoneId}/shared"}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<SmartObjectRef> retrieveZoneShared(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String zoneId) throws DKUSecurityException, IOException {
        Zone zone;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneId);
        }
        return zone.getShared();
    }

    @AuditedCall(value={"msgType", "flow-zone-shared-add", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/{zoneId}/shared"}, method={RequestMethod.POST})
    @ResponseBody
    public Zone addZoneShared(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String zoneId, @RequestBody SmartObjectRef data) throws DKUSecurityException, IOException {
        Zone zone;
        this.require(this.isValidType(data.objectType), "Required field 'objectType' is not a flow computable, a recipe or a labeling task.");
        SmartObjectRef item = SmartObjectRef.fromResolved((ITaggingService.TaggableType)data.objectType, (String)data.projectKey, (String)data.objectId, (String)projectKey);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            if (!this.taggableObjectsReadService.exists(item.toTaggableObjectRef(projectKey))) {
                throw new NotFoundException(String.format("Item of type:%s with id:%s does not exist", item.objectType, item.getSmartName()));
            }
            this.flowZonesService.shareObjectToZone(zoneId, projectKey, item);
            this.flowGraphService.invalidateCache(projectKey);
            zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneId);
            t.commitV("Item:%s shared to the zone:%s", new Object[]{item.getSmartName(), zone.getId()});
        }
        this.flowGraphService.invalidateCache();
        return zone;
    }

    @AuditedCall(value={"msgType", "flow-zone-shared-delete", "projectKey", "${projectKey}", "zoneId", "${zoneId}", "type", "${type}", "smartId", "${smartId}"})
    @RequestMapping(value={"/{zoneId}/shared/{objectType}/{smartId:.+}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Zone deleteZoneShared(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String zoneId, @PathVariable String objectType, @PathVariable String smartId) throws DKUSecurityException, IOException {
        Zone zone;
        SmartObjectRef smartRefCandidate = SmartObjectRef.fromSmartName((ITaggingService.TaggableType)ITaggingService.TaggableType.valueOf((String)objectType.toUpperCase()), (String)smartId);
        SmartObjectRef ref = SmartObjectRef.fromResolved((ITaggingService.TaggableType)smartRefCandidate.objectType, (String)smartRefCandidate.projectKey, (String)smartRefCandidate.objectId, (String)projectKey);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.flowZonesService.unshareObjectFromZone(projectKey, zoneId, ref);
            this.flowGraphService.invalidateCache(projectKey);
            zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneId);
            t.commitV("Removed shared:%s of type:%s from zone:%s", new Object[]{ref.getSmartName(), objectType, zoneId});
        }
        this.flowGraphService.invalidateCache();
        return zone;
    }

    @AuditedCall(value={"msgType", "flow-zone-graph-get", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/{zoneId}/graph"}, method={RequestMethod.GET})
    @ResponseBody
    public SerializedFlowZoneGraph getZoneGraph(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String zoneId) throws DKUSecurityException, IOException {
        ProjectFlowGraph graph;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            graph = this.flowGraphService.getProjectGraph(projectKey, true);
        }
        return new SerializedFlowZoneGraph(graph.getFlowZone(zoneId), projectKey);
    }

    @AuditedCall(value={"msgType", "generate-ai-description", "projectKey", "${projectKey}", "zoneId", "${zoneId}"})
    @RequestMapping(value={"/{zoneId}/generate-ai-description"}, method={RequestMethod.POST})
    public void generateAiDescription(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String zoneId, @RequestParam(defaultValue="english") String language, @RequestParam(defaultValue="generic") String purpose, @RequestParam(defaultValue="medium") String length, @RequestParam(defaultValue="false") boolean saveDescription) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{saveDescription ? Privileges.ProjectLevelPrivilegeType.WRITE_CONF : Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        JsonObject explanationOptions = new JsonObject();
        explanationOptions.addProperty("language", language.toLowerCase());
        explanationOptions.addProperty("purpose", purpose.toUpperCase());
        explanationOptions.addProperty("verbosity", length.toUpperCase());
        FutureResponse fr = this.aiFlowExplanationService.startExplainingFlowZone(authCtx, projectKey, zoneId, explanationOptions.toString(), false);
        fr = this.futureService.waitForFinalResponse(fr);
        if (!((ExplainStuffFrontendResponse)fr.result).ok) {
            throw new ApplicativeException("Exception while getting AI explanation", ((ExplainStuffFrontendResponse)fr.result).reason);
        }
        String aiExplanation = ((ExplainStuffFrontendResponse)fr.result).explanation;
        if (saveDescription) {
            try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
                Zone zone = (Zone)this.zonesDAO.getMandatory(projectKey, zoneId);
                zone.description = aiExplanation;
                this.flowZonesService.edit(projectKey, zone, authCtx);
                this.flowGraphService.invalidateCache(projectKey);
                t.commitV("Description of zone:%s updated", new Object[]{zone.getId()});
            }
        }
        PublicAPIFlowZonesController.writeJSON((HttpServletResponse)resp, (Object)aiExplanation);
    }

    private boolean isValidType(ITaggingService.TaggableType type) {
        return FlowComputable.FCType.isFlowComputable((ITaggingService.TaggableType)type) || ITaggingService.TaggableType.RECIPE.equals((Object)type) || ITaggingService.TaggableType.LABELING_TASK.equals((Object)type);
    }

    public class ZoneUpdate
    extends TaggableObjectsService.TaggableObjectMetadata {
        @Nullable
        String name;
        @Nullable
        String color;
    }

    public static class SerializedFlowZoneGraph
    extends PublicAPIFlowController.SerializedFlowGraph<FlowZoneSerializedFlowGraphNode, FlowZone> {
        SerializedFlowZoneGraph() {
        }

        public SerializedFlowZoneGraph(FlowZone graph, String projectKey) {
            super(graph, projectKey);
        }

        @Override
        public FlowZoneSerializedFlowGraphNode get(GraphNode graphNode, String projectKey, PublicAPIFlowController.SerializedFlowGraphNodeType type, FlowZone flowZone) {
            SmartObjectRef ref = SmartObjectRef.fromSmartName((ITaggingService.TaggableType)type.toTaggableType(), (String)graphNode.getRef(projectKey));
            boolean belongsToZone = flowZone.getZone().getItems().contains(ref) || Zone.DEFAULT_ZONE.getId().equals(flowZone.getZone().getId()) && !flowZone.getZone().getShared().contains(ref);
            return new FlowZoneSerializedFlowGraphNode(graphNode, projectKey, type, belongsToZone);
        }
    }

    public static class FlowZoneSerializedFlowGraphNode
    extends PublicAPIFlowController.SerializedFlowGraphNode {
        public boolean belongsToZone;

        FlowZoneSerializedFlowGraphNode() {
        }

        public FlowZoneSerializedFlowGraphNode(GraphNode internalNode, String contextProjectKey, PublicAPIFlowController.SerializedFlowGraphNodeType type, boolean belongsToZone) {
            super(internalNode, contextProjectKey, type);
            this.belongsToZone = belongsToZone;
        }
    }
}

