/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.unifiedmonitoring;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.dataquality.DataQualitySummaryService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.ModelStatus;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringAutomationComputationService;
import com.dataiku.dip.unifiedmonitoring.project.ProjectDataQualityDTO;
import com.dataiku.dip.unifiedmonitoring.project.ProjectModelStatus;
import com.dataiku.dip.unifiedmonitoring.project.ProjectScenarioRunsDTO;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/unified-monitoring-automation"})
public class PublicAPIUnifiedMonitoringAutomationController
extends PublicAPIControllerBase {
    @Autowired
    TransactionService transactionService;
    @Autowired
    ProjectsService projectsService;
    @Autowired
    UnifiedMonitoringAutomationComputationService unifiedMonitoringAutomationComputationService;
    @Autowired
    MetaAuthService authService;
    @Autowired
    PermissionsService permissionsService;
    @Autowired
    DatasetsDAO datasetsDAO;
    @Autowired
    UsersService usersService;
    @Autowired
    DataQualitySummaryService dataQualitySummaryService;

    @AuditedCall(value={"msgType", "unified-monitoring-automation-model-status-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/models-status"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectModelStatus getProjectModelStatus(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.unifiedMonitoringAutomationComputationService.getProjectModelStatus(projectKey);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-automation-model-status-get", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/model-status/{modelId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ModelStatus getModelStatus(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String modelId, @RequestParam(required=false) List<String> mesToFilterOn) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.unifiedMonitoringAutomationComputationService.getOrComputeModelStatus(projectKey, FullModelId.parse((String)modelId), mesToFilterOn);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-automation-latest-scenario-run-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/latest-scenario-run"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectScenarioRunsDTO getLatestScenarioRun(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.unifiedMonitoringAutomationComputationService.getScenariosRun(projectKey);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-automation-data-quality-status-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/data-quality-status"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectDataQualityDTO getDataQualityStatus(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        PublicUser owner;
        SerializedProject prj;
        List sds;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sds = this.datasetsDAO.listUnsafe(projectKey);
            prj = this.projectsService.getMandatoryUnsafe(projectKey);
            owner = prj != null && prj.owner != null ? this.usersService.getPublicUser(prj.owner) : new PublicUser();
        }
        DataQualitySummaryService.UIProjectDataQuality prjDataQuality = this.dataQualitySummaryService.getProjectStatus_NT(prj, sds, owner, projectKey);
        List lastOutcomes = prjDataQuality.items.stream().filter(x -> x.monitored).collect(Collectors.toList());
        long emptyCount = lastOutcomes.stream().filter(x -> x.datasetQuality.lastOutcome == AbstractCheckContext.CheckOutcome.EMPTY).count();
        long errorCount = lastOutcomes.stream().filter(x -> x.datasetQuality.lastOutcome == AbstractCheckContext.CheckOutcome.ERROR).count();
        long warningCount = lastOutcomes.stream().filter(x -> x.datasetQuality.lastOutcome == AbstractCheckContext.CheckOutcome.WARNING).count();
        long okCount = lastOutcomes.stream().filter(x -> x.datasetQuality.lastOutcome == AbstractCheckContext.CheckOutcome.OK).count();
        int activeRules = lastOutcomes.stream().map(x -> x.numberEnabledRules).reduce(0, Integer::sum);
        return new ProjectDataQualityDTO(prjDataQuality.hasDataset, prjDataQuality.lastRunRuleDate, activeRules, emptyCount, errorCount, warningCount, okCount);
    }
}

