/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.catalog.IndexNotBuiltException;
import com.dataiku.dip.server.services.catalog.IndexingDisabledException;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.external.ExternalDataCatalogService;
import com.dataiku.dip.server.services.catalog.internal.IInternalDataCatalogService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DataCatalogController
extends DIPInternalControllerBase {
    @Autowired
    private IInternalDataCatalogService catalogService;
    @Autowired
    private ExternalDataCatalogService externalDataCatalogService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;

    @AuditedCall(value={"msgType", "catalog-search", "query", "${query}", "facets", "${facets}", "type", "${type}"})
    @RequestMapping(value={"/api/catalog/search"})
    public void search(HttpServletRequest req, HttpServletResponse resp, @RequestParam String query, @RequestParam String facets, @Nullable Boolean useCountAccuracy, @Nullable String explainDocId, @Nullable String explainDocType, @RequestParam(required=false, defaultValue="-1") int maxSize) throws Exception {
        Map facetMap;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        if (useCountAccuracy == null) {
            useCountAccuracy = false;
        }
        if (!(facetMap = (Map)JSON.parse((String)facets, (TypeToken)new TypeToken<Map<String, List<String>>>(){})).containsKey("scope")) {
            facetMap.put("scope", Lists.newArrayList((Object[])new String[]{"dss"}));
        }
        TreeSet scopes = new TreeSet((Collection)facetMap.get("scope"));
        String type = Joiner.on((String)"+").join(scopes);
        try {
            String jsonOutput = this.catalogService.searchResultPostTreatment(user, (Iterable)(switch (type) {
                case "all" -> this.catalogService.search(query, facetMap, user, IInternalDataCatalogService.Options.getDefaultOptions().withAccurateTotalHits(useCountAccuracy.booleanValue()).withExplainDocId(explainDocId).withExplainDocType(explainDocType).withMaxSize(maxSize));
                case "dss" -> this.catalogService.searchInternal(query, facetMap, user, IInternalDataCatalogService.Options.getDefaultOptions().withAccurateTotalHits(useCountAccuracy.booleanValue()).withExplainDocId(explainDocId).withExplainDocType(explainDocType).withMaxSize(maxSize), null);
                case "dss-column" -> this.catalogService.searchColumn(query, facetMap, user, explainDocId);
                case "meanings" -> this.catalogService.searchMeaning(query, facetMap, user, true, explainDocId);
                case "external" -> this.externalDataCatalogService.searchExternal(query, facetMap, user, true, explainDocId);
                default -> throw new IllegalArgumentException("Invalid search type: " + type);
            }).hits, (switch (type) {
                case "all" -> this.catalogService.search(query, facetMap, user, IInternalDataCatalogService.Options.getDefaultOptions().withAccurateTotalHits(useCountAccuracy.booleanValue()).withExplainDocId(explainDocId).withExplainDocType(explainDocType).withMaxSize(maxSize));
                case "dss" -> this.catalogService.searchInternal(query, facetMap, user, IInternalDataCatalogService.Options.getDefaultOptions().withAccurateTotalHits(useCountAccuracy.booleanValue()).withExplainDocId(explainDocId).withExplainDocType(explainDocType).withMaxSize(maxSize), null);
                case "dss-column" -> this.catalogService.searchColumn(query, facetMap, user, explainDocId);
                case "meanings" -> this.catalogService.searchMeaning(query, facetMap, user, true, explainDocId);
                case "external" -> this.externalDataCatalogService.searchExternal(query, facetMap, user, true, explainDocId);
                default -> throw new IllegalArgumentException("Invalid search type: " + type);
            }).serializeHits(), base -> base.getAsJsonObject("hits").getAsJsonArray("hits"));
            DataCatalogController.writeJSONString((HttpServletResponse)resp, (String)jsonOutput);
        }
        catch (IndexNotBuiltException e) {
            DataCatalogController.sendErrorExplicit((int)503, (String)"NotReady", (String)"Data catalog is not ready yet (indexing)", (HttpServletResponse)resp);
        }
        catch (IndexingDisabledException e) {
            DataCatalogController.sendErrorExplicit((int)503, (String)"Disabled", (String)"Indexing is disabled", (HttpServletResponse)resp);
        }
    }

    @AuditedCall(value={"msgType", "catalog-flush"})
    @RequestMapping(value={"/api/catalog/flush"})
    public void flush(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        this.catalogService.flush();
    }

    @AuditedCall(value={"msgType", "catalog-list-dashboards"})
    @RequestMapping(value={"/api/catalog/list-dashboards"})
    public void listDashboards(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        LuceneResponseWrapper resultsLucene = this.catalogService.getListedNonEmptyDashboards(user);
        DataCatalogController.writeJSONString((HttpServletResponse)resp, (String)resultsLucene.serializeHits());
    }

    @AuditedCall(value={"msgType", "catalog-get-data-source-dataset-details"})
    @RequestMapping(value={"/api/catalog/get-data-source-dataset-details"})
    public void getDataSourcesDatasetDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermissionRegardlessOfContext(user, projectKey, ITaggingService.TaggableType.DATASET, id, SerializedProject.ReaderAuthorization.Mode.READ);
        }
        DataCatalogController.writeJSON((HttpServletResponse)resp, (Object)this.catalogService.getReadableDatasetItemDetails_NT(user, projectKey, id));
    }
}

