/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.lambda;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.lambda.mgmt.LambdaServicesCRUDService;
import com.dataiku.dip.lambda.mgmt.PackagesMgmtServiceImpl;
import com.dataiku.dip.lambda.mgmt.PackagesService;
import com.dataiku.dip.lambda.mgmt.devserver.APIDesignerTestQueriesService;
import com.dataiku.dip.lambda.mgmt.devserver.LambdaDevServerService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.openapi.OpenAPIService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.lambda.APIServiceCodes;
import com.dataiku.lambda.model.serverconfig.QueryAPIKey;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.dataiku.lambda.model.studioconfig.OpenAPIDoc;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/lambda-services"})
public class LambdaServicesController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private LambdaDevServerService lambdaDevServerService;
    @Autowired
    private APIDesignerTestQueriesService devtoolsService;
    @Autowired
    private LambdaServicesCRUDService crudService;
    @Autowired
    private PackagesMgmtServiceImpl packagesMgmtService;
    @Autowired
    private PackagesService packagesService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private OpenAPIService openAPIService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    private VariablesService variablesService;
    private static final DKULogger logger;

    @AuditedCall(value={"msgType", "lambda-get", "projectKey", "${projectKey}", "serviceId", "${id}"})
    @RequestMapping(value={"/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        AuthCtx authCtx;
        LambdaService.LambdaServiceSummary summary = new LambdaService.LambdaServiceSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            LambdaService service = this.crudService.getMandatory(projectKey, id);
            if (service.authRealm != null) {
                service.authRealm.decryptKeysIfEncrypted(this.passwordEncryptionService);
            }
            summary.object = service;
            summary.packages = this.getSummaryPackages(req, projectKey, id);
        }
        summary.timeline = this.timelinesService.getObjectTimeline_NT(summary.object, 0, 100);
        summary.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summary.object);
        LambdaServicesController.writeJSONWithNoNaNAndNull((HttpServletResponse)resp, (Object)summary);
    }

    @AuditedCall(value={"msgType", "lambda-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/list"})
    public void listServices(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            LambdaServicesController.writeJSON((HttpServletResponse)resp, this.crudService.list(projectKey));
        }
    }

    @AuditedCall(value={"msgType", "lambda-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/list-heads"})
    public void listHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx user;
        TaggableObjectsService.FilteredTaggableItems heads = new TaggableObjectsService.FilteredTaggableItems();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            for (LambdaService service : this.crudService.list(projectKey)) {
                LambdaService.LambdaServiceListItem listItem = new LambdaService.LambdaServiceListItem(service);
                this.taggableObjectsService.setEditionInfoFromTags((TaggableObjectsService.TaggableObject)service, (TaggableObjectsService.TaggableListItem)listItem);
                heads.items.add(listItem);
            }
        }
        this.interestsService.enrichHeads(user.getAssociatedDSSUser(), projectKey, heads.items);
        LambdaServicesController.writeJSON((HttpServletResponse)resp, (Object)heads);
    }

    @AuditedCall(value={"msgType", "lambda-save", "projectKey", "${projectKey}", "serviceId", "${id}"})
    @RequestMapping(value={"/save"})
    public void saveService(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String service) throws Exception {
        LambdaService serviceObj = (LambdaService)JSON.parse((String)service, LambdaService.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            for (QueryAPIKey qak : serviceObj.authRealm.queryKeys) {
                if (!StringUtils.isBlank((String)qak.key)) continue;
                qak.key = SecretKeyGenerator.generate((int)32);
                qak.createdOn = System.currentTimeMillis();
                qak.createdBy = t.getUser().getIdentifier();
            }
            this.openAPIService.updateServiceEndpointsAutomatedOpenAPIDoc(req, projectKey, serviceObj);
            this.crudService.save(serviceObj);
            t.commit("Updated Lambda service config");
        }
        LambdaServicesController.writeJSON((HttpServletResponse)resp, (Object)serviceObj);
    }

    @AuditedCall(value={"msgType", "lambda-save", "projectKey", "${projectKey}", "serviceId", "${id}"})
    @RequestMapping(value={"/add-endpoint"})
    public void addEndpoint(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String serviceId, @RequestParam String endpoint, @RequestParam String createService) throws Exception {
        LambdaService service;
        SavedModel sm;
        DSSLambdaEndpointConfig endpointObj = (DSSLambdaEndpointConfig)JSON.parse((String)endpoint, DSSLambdaEndpointConfig.class);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            sm = this.openAPIService.getSavedModelFromEndpointForOpenAPIDocGenerationOrNull_Check(req, projectKey, endpointObj);
        }
        this.openAPIService.addDefaultOpenAPIDocToEndpoint(endpointObj, sm);
        t = this.transactionService.beginWriteForUI(req);
        try {
            boolean serviceCreation = "true".equals(createService);
            service = this.crudService.addEndpoint(projectKey, serviceId, endpointObj, serviceCreation);
            t.commit("Updated Lambda service config: added an endpoint");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        LambdaServicesController.writeJSON((HttpServletResponse)resp, (Object)service);
    }

    @AuditedCall(value={"msgType", "lambda-delete", "projectKey", "${projectKey}", "serviceId", "${id}"})
    @RequestMapping(value={"/delete"})
    public void deleteService(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.crudService.delete(projectKey, id);
            t.commit("Deleted Lambda service");
        }
    }

    @RequestMapping(value={"/delete-multi"})
    public void deleteServiceMulti(HttpServletRequest req, HttpServletResponse resp, @RequestParam String requests, @RequestParam String contextProjectKey) throws Exception {
        Set refs = (Set)JSON.parse((String)requests, (TypeToken)new TypeToken<HashSet<TaggableObjectsDeletionService.DeletionRequestItem>>(){});
        HashSet<TaggableObjectsDeletionService.DeletionRequestItem> toDelete = new HashSet<TaggableObjectsDeletionService.DeletionRequestItem>();
        AuthCtx authCtx = null;
        HashMap<TaggableObjectsDeletionService.DeletionRequestItem, TaggableObjectsService.TaggableObject> tObjects = new HashMap<TaggableObjectsDeletionService.DeletionRequestItem, TaggableObjectsService.TaggableObject>(refs.size());
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            for (TaggableObjectsDeletionService.DeletionRequestItem dr : refs) {
                boolean isForeign = dr.id.contains(".") || contextProjectKey != null && !contextProjectKey.equals(dr.projectKey);
                if (isForeign) continue;
                toDelete.add(dr);
                this.failIfCannotDelete((TaggableObjectsService.TaggableObjectRef)dr, authCtx);
                tObjects.put(dr, this.getTaggableObjectAndCheckPerm((TaggableObjectsService.TaggableObjectRef)dr, authCtx));
            }
        }
        TaggableObjectsDeletionService.DeletionResult result = new TaggableObjectsDeletionService.DeletionResult();
        for (TaggableObjectsDeletionService.DeletionRequestItem dr : toDelete) {
            try {
                TaggableObjectsService.TaggableObject to = (TaggableObjectsService.TaggableObject)tObjects.get(dr);
                RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
                try {
                    this.crudService.delete(to.getProjectKey(), to.getId());
                    t.commit("Deleted " + to.getTaggableType().toHumanReadableString() + " " + to.getFullId());
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to delete item ", (Throwable)e);
                result.withWarningV((InfoMessage.MessageCode)APIServiceCodes.ERR_ENDPOINT_INVALID_CONFIG, "Failed to delete item: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
        }
        LambdaServicesController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditedCall(value={"msgType", "lambda-create", "projectKey", "${projectKey}", "serviceId", "${id}"})
    @RequestMapping(value={"/create"})
    public void createNewService(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            LambdaService config = this.crudService.create(projectKey, id);
            LambdaServicesController.writeJSON((HttpServletResponse)resp, (Object)config);
            t.commit("Created new Lambda service");
        }
    }

    @AuditedCall(value={"msgType", "lambda-generate-endpoint-open-api", "projectKey", "${projectKey}", "endpoint", "${endpoint}", "enabled", "${enabled}", "isManual", "${isManual}"})
    @RequestMapping(value={"/generate-endpoint-open-api"})
    public void generateEndpointOpenAPI(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String endpoint, @RequestParam(defaultValue="true") boolean enabled, @RequestParam(defaultValue="true") boolean isManual) throws Exception {
        DSSLambdaEndpointConfig endpointObj = (DSSLambdaEndpointConfig)JSON.parse((String)endpoint, DSSLambdaEndpointConfig.class);
        SavedModel savedModel = null;
        if (!isManual) {
            try (Transaction t = this.transactionService.beginRead();){
                savedModel = this.openAPIService.getSavedModelFromEndpointForOpenAPIDocGenerationOrNull_Check(req, projectKey, endpointObj);
            }
        }
        OpenAPIDoc openAPI = this.openAPIService.generateEndpointOpenAPIDoc(endpointObj, savedModel, enabled, isManual);
        logger.infoV("Generate OpenAPI doc for endpoint %s", new Object[]{endpointObj.id});
        LambdaServicesController.writeJSON((HttpServletResponse)resp, (Object)openAPI);
    }

    @AuditedCall(value={"msgType", "lambda-start-prepare", "projectKey", "${projectKey}", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/packages/start-prepare"})
    public void startPreparePackage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String serviceId, @RequestParam String packageId, @RequestParam(required=false) @Nullable String releaseNotes) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            FutureResponse<InfoMessage.InfoMessages> fr;
            this.projectsService.checkPerm(req, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            AuthCtx liu = this.authService.getMandatoryUser(req);
            LambdaService config = this.crudService.getOrNull(projectKey, serviceId);
            if (StringUtils.isNotBlank((String)releaseNotes)) {
                VariablesContext context = this.variablesService.getForProject(projectKey);
                config.releaseNotes = context.expandAllowUnresolved(releaseNotes).trim();
            }
            SerializedProject project = this.projectsService.getMandatory(projectKey);
            File destDir = this.packagesService.mkdir(projectKey, serviceId, packageId);
            try {
                fr = this.packagesMgmtService.startGeneratingPackage(destDir, projectKey, config, project.permissions, liu, false);
            }
            catch (Exception e) {
                logger.debugV("Failed to generate package '%s' for API service '%s'. Deleting the package directory.", new Object[]{packageId, serviceId});
                this.packagesService.delete(projectKey, serviceId, packageId);
                throw e;
            }
            logger.info((Object)("Writing into " + String.valueOf(destDir)));
            LambdaServicesController.writeJSON((HttpServletResponse)resp, fr);
        }
    }

    @AuditedCall(value={"msgType", "lambda-get-sample-queries", "projectKey", "${projectKey}", "queriesName", "${queriesName}", "dataset", "${datasetName}"})
    @RequestMapping(value={"/get-sample-queries"})
    public void getSampleQueryFromDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam @Nullable Set<String> queriesName, @RequestParam String datasetName, @RequestParam int batchSize, @RequestParam String method, @RequestParam boolean shouldIncludeNulls, @RequestParam(required=false) String modelRef) throws Exception {
        SerializedDataset serializedDataset;
        AuthCtx u;
        SavedModel savedModel = null;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(u, SmartObjectRef.fromSmartName((ITaggingService.TaggableType)ITaggingService.TaggableType.DATASET, (String)datasetName), projectKey);
            serializedDataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe((AnyLoc)DatasetLocUtils.resolveSmart((String)projectKey, (String)datasetName));
            if (StringUtils.isNotBlank((String)modelRef)) {
                AnyLoc modelLoc = AnyLoc.resolveSmart((String)projectKey, (String)modelRef);
                this.projectsService.checkPerm(req, modelLoc.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
                savedModel = (SavedModel)this.savedModelsDAO.getOrNullUnsafe(modelLoc);
            }
        }
        List<ApiEndpointQuery> queries = this.devtoolsService.getSampleQueriesFromDataset(serializedDataset, u, batchSize, method, savedModel, queriesName, shouldIncludeNulls);
        LambdaServicesController.writeJSONWithNoNaNAndNull((HttpServletResponse)resp, queries);
    }

    @AuditedCall(value={"msgType", "lambda-play-test-queries", "projectKey", "${projectKey}", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/play-test-queries"})
    public void playTestQueries(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String serviceId, @RequestParam String endpointId, @RequestParam String queries, @RequestParam String testType) throws Exception {
        LambdaService apiService;
        AuthCtx user;
        List queriesObj = (List)JSON.parse((String)queries, (TypeToken)new TypeToken<List<ApiEndpointQuery>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            user = this.authService.getMandatoryUser(req);
            apiService = this.crudService.getMandatoryUnsafe(projectKey, serviceId);
        }
        APIDesignerTestQueriesService.LambdaTestType type = APIDesignerTestQueriesService.LambdaTestType.valueOf(testType.toUpperCase().replace('-', '_'));
        String apiKey = apiService.getAPIKeyOrNull();
        LambdaServicesController.writeJSON((HttpServletResponse)resp, (Object)this.devtoolsService.playTestQueries_NT(serviceId, endpointId, queriesObj, type, apiKey, user, projectKey));
    }

    @AuditedCall(value={"msgType", "lambda-deploy-to-dev", "projectKey", "${projectKey}", "serviceId", "${id}"})
    @RequestMapping(value={"/deploy-to-dev"})
    public void deployHeadToDev(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            liu = this.authService.getMandatoryUser(req);
        }
        logger.info((Object)"Starting Lambda service deployment to dev");
        LambdaServicesController.writeJSON((HttpServletResponse)resp, (Object)this.lambdaDevServerService.deployService_NT(projectKey, id, liu));
    }

    @AuditedCall(value={"msgType", "lambda-get-packages", "projectKey", "${projectKey}", "serviceId", "${serviceId}"})
    @RequestMapping(value={"/packages"})
    public void getPackages(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String serviceId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            List<LambdaService.LambdaServiceSummary.Package> packages = this.getSummaryPackages(req, projectKey, serviceId);
            LambdaServicesController.writeJSON((HttpServletResponse)resp, packages);
        }
    }

    @Nonnull
    private List<LambdaService.LambdaServiceSummary.Package> getSummaryPackages(HttpServletRequest req, String projectKey, String serviceId) throws DKUSecurityException, IOException {
        this.projectsService.checkPerm(req, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        return this.packagesService.listSummaries(projectKey, serviceId);
    }

    @AuditedCall(value={"msgType", "lambda-get-package-summary", "projectKey", "${projectKey}", "serviceId", "${serviceId}", "packageId", "${packageId}"})
    @RequestMapping(value={"/package/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String serviceId, @RequestParam String packageId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        LambdaService.LambdaServiceSummary.Package packageDetails = this.packagesService.getSummary(projectKey, serviceId, packageId);
        LambdaServicesController.writeJSON((HttpServletResponse)resp, (Object)packageDetails);
    }

    @AuditedCall(value={"msgType", "lambda-delete-package", "projectKey", "${projectKey}", "serviceId", "${serviceId}", "packageId", "${packageId}"})
    @RequestMapping(value={"/package/delete"})
    public void deletePackage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String serviceId, @RequestParam String packageId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.packagesService.delete(projectKey, serviceId, packageId);
        }
    }

    @AuditedCall(value={"msgType", "lambda-download-package", "projectKey", "${projectKey}", "serviceId", "${id}", "packageId", "${packageId}"})
    @RequestMapping(value={"/package/download"})
    public void downloadPackage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String serviceId, @RequestParam String packageId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(user, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            File dir = this.packagesService.get(projectKey, serviceId, packageId);
            File zip = new File(dir, "package.zip");
            if (!zip.exists()) {
                throw new FileNotFoundException("Package archive does not exist " + zip.getAbsolutePath());
            }
            resp.setHeader("Content-Length", "" + zip.length());
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + serviceId + "_" + packageId + ".zip\"");
            try (FileInputStream fis = new FileInputStream(zip);){
                IOUtils.copyLarge((InputStream)fis, (OutputStream)resp.getOutputStream());
            }
        }
    }

    @AuditedCall(value={"msgType", "lambda-publish-to-api-deployer", "projectKey", "${projectKey}", "serviceId", "${id}", "packageId", "${packageId}"})
    @RequestMapping(value={"/package/publish-to-api-deployer"}, method={RequestMethod.POST})
    public void publishPackageToAPIDeployer(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String serviceId, @RequestParam String packageId, @RequestParam String publishedServiceId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        this.packagesService.publish_NT(user, projectKey, serviceId, packageId, publishedServiceId);
    }

    private void failIfCannotDelete(TaggableObjectsService.TaggableObjectRef ref, AuthCtx authCtx) throws Exception {
        AnyLoc loc = AnyLoc.resolveSmart((String)ref.projectKey, (String)ref.id);
        this.projectsService.checkPerm(authCtx, loc.getProjectKey(), new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
    }

    private TaggableObjectsService.TaggableObject getTaggableObjectAndCheckPerm(TaggableObjectsService.TaggableObjectRef ref, AuthCtx authCtx) throws Exception {
        AnyLoc loc = ref.getLoc().resolved();
        return this.crudService.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
    }

    static {
        DKUtils.forceInit(DSSLambdaEndpointConfig.class);
        logger = DKULogger.getLogger((String)"dku.lambda.controller");
    }
}

