/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.docportal;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.docportal.PythonDocPortalService;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.catalog.AbstractIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.LuceneDocBuilder;
import com.dataiku.dip.server.services.catalog.LuceneIndexManager;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PythonDocPortalIndexingQueueHandler
extends AbstractIndexingQueueHandler {
    public static final Set<String> FACETS = new HashSet<String>();
    public static final String TYPE = IndexableType.DOC_PORTAL.index();
    public static final String PACKAGE_SCOPE_FIELD = "packageScope";
    public static final String PROJECT_KEY_FIELD = "projectKey";
    public static final String DOCSTRING_FIELD = "docstring";
    public static final String NODE_TYPE_FIELD = "nodeType";
    public static final String IMPORT_PATH_FIELD = "importPath";
    public static final String ARGUMENTS_FIELD = "arguments";
    public static final String NAME_FIELD = "name";
    public static final String FUNCTION_NAME_FIELD = "functionName";
    public static final String CLASS_NAME_FIELD = "className";
    public static final String MODULE_NAME_FIELD = "moduleName";
    public static final String PACKAGE_NAME_FIELD = "packageName";
    @Autowired
    private PythonDocPortalService docPortalService;
    @Autowired
    @Qualifier(value="pythonDocPortalMappingsAnalyzer")
    private LuceneMappingsAnalyzer pythonDocPortalMappingsAnalyzer;
    @Autowired
    @Qualifier(value="pythonDocPortalIndexManager")
    private LuceneIndexManager pythonDocPortalIndexManager;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.docportal.indexer");

    public PythonDocPortalIndexingQueueHandler() {
        super("doc-portal");
    }

    @Override
    public void handleQueueEvent(BackendEvent event) throws Exception {
        switch (event.getName()) {
            case "docportal-documentation-generated": {
                PythonDocPortalService.DocPortalDocumentationGeneratedEvent docEvent = (PythonDocPortalService.DocPortalDocumentationGeneratedEvent)event;
                this.indexPackages(docEvent.clearAllPreviousDocuments, docEvent.packagesToIndex);
                if (!this.initialized) {
                    this.pythonDocPortalIndexManager.startRefreshThread();
                }
                this.initialized = true;
                break;
            }
            case "docportal-documentation-project-deleted": {
                PythonDocPortalService.DocPortalDocumentationProjectDeletedEvent docEvent = (PythonDocPortalService.DocPortalDocumentationProjectDeletedEvent)event;
                this.removePreviouslyIndexedPackage(docEvent.projectKey, PythonDocPortalService.PackageScope.PROJECT);
                break;
            }
            case "flush-requested": {
                this.pythonDocPortalIndexManager.commitIndexWriterAndRefreshIndexSearcherOrWait();
            }
        }
    }

    private void indexPackages(boolean clearAllPreviousDocuments, List<PythonDocPortalService.DocPortalPackagesToIndex> packagesToIndex) throws InterruptedException, IOException {
        if (clearAllPreviousDocuments) {
            logger.debug((Object)"clearing documentation portal index");
            this.pythonDocPortalIndexManager.clearIndex();
        }
        logger.debugV("Will index %d packages", new Object[]{packagesToIndex.size()});
        for (PythonDocPortalService.DocPortalPackagesToIndex packageToIndex : packagesToIndex) {
            try {
                if (!clearAllPreviousDocuments) {
                    this.removePreviouslyIndexedPackage(packageToIndex.projectKey(), packageToIndex.packageScope());
                }
                this.indexPackage(packageToIndex);
            }
            catch (Exception e) {
                logger.error((Object)"Could not index python package", (Throwable)e);
            }
        }
        if (clearAllPreviousDocuments) {
            logger.debug((Object)"Complete reindexing done");
            this.pythonDocPortalIndexManager.commitIndexWriterAndRefreshIndexSearcherOrWait();
        }
    }

    public void removePreviouslyIndexedPackage(String projectKey, PythonDocPortalService.PackageScope scope) throws IOException, InterruptedException {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        if (projectKey != null) {
            booleanQueryBuilder.add((Query)new TermQuery(new Term(PROJECT_KEY_FIELD, projectKey)), BooleanClause.Occur.FILTER);
        }
        booleanQueryBuilder.add((Query)new TermQuery(new Term(PACKAGE_SCOPE_FIELD, scope.toString())), BooleanClause.Occur.FILTER);
        BooleanQuery booleanQuery = booleanQueryBuilder.build();
        this.pythonDocPortalIndexManager.deleteDocuments((Query)booleanQuery);
    }

    private void indexPackage(PythonDocPortalService.DocPortalPackagesToIndex packagesToIndex) throws IOException, InterruptedException {
        String filePathRelativeToHome = this.docPortalService.getOutputPath(packagesToIndex.projectKey(), packagesToIndex.packageScope().toString()).getAbsolutePath().substring(DKUApp.getBaseFolder().length() + 1);
        logger.info((Object)("Start indexing for: " + filePathRelativeToHome));
        List packages = this.docPortalService.listPackages(packagesToIndex.projectKey(), packagesToIndex.packageScope().toString());
        for (String p : packages) {
            PythonDocPortalService.Package docPackage = this.docPortalService.getProjectPythonDoc(packagesToIndex.projectKey(), p, packagesToIndex.packageScope().toString());
            this.indexPackage(docPackage, packagesToIndex.projectKey(), packagesToIndex.packageScope(), filePathRelativeToHome);
        }
        PythonDocPortalService.Package root = this.docPortalService.getProjectPythonDoc(packagesToIndex.projectKey(), null, packagesToIndex.packageScope().toString());
        this.indexPackage(root, packagesToIndex.projectKey(), packagesToIndex.packageScope(), filePathRelativeToHome);
        logger.info((Object)("Done indexing for: " + filePathRelativeToHome));
    }

    private void indexPackage(PythonDocPortalService.Package p, String projectKey, PythonDocPortalService.PackageScope scope, String filePathRelativeToHome) throws InterruptedException {
        if (p == null) {
            if (projectKey != null) {
                logger.debugV("Not indexing %s (%s) because package is empty for packageScope %s", new Object[]{projectKey, filePathRelativeToHome, scope});
            } else {
                logger.debugV("Not indexing %s because package is empty for packageScope %s", new Object[]{filePathRelativeToHome, scope});
            }
            return;
        }
        if (p.documentationError != null) {
            logger.infoV("Not indexing %s from %s because of documentation error for packageScope %s", new Object[]{p.name, projectKey, scope});
            return;
        }
        String packageName = p.name;
        String importPath = p.importPath;
        if (".".equals(p.importPath)) {
            packageName = null;
            importPath = null;
        }
        if (packageName != null) {
            IndexedEntry entry = new IndexedEntry(projectKey, null, importPath, packageName, null, null, null, packageName, null, null, filePathRelativeToHome, scope);
            this.indexSingleEntry(entry, "PACKAGE");
        }
        if (p.modules == null) {
            return;
        }
        for (PythonDocPortalService.Module m : p.modules) {
            IndexedEntry moduleEntry = new IndexedEntry(projectKey, null, importPath, packageName, m.name, null, null, m.name, null, m.docstring, filePathRelativeToHome, scope);
            this.indexSingleEntry(moduleEntry, "MODULE");
            if (m.classes != null) {
                for (PythonDocPortalService.Class c : m.classes) {
                    IndexedEntry classEntry = new IndexedEntry(projectKey, null, importPath, packageName, m.name, c.name, null, c.name, c.params, c.docstring, filePathRelativeToHome, scope);
                    this.indexSingleEntry(classEntry, "CLASS");
                    this.indexFunction(projectKey, importPath, packageName, m.name, c.name, filePathRelativeToHome, c.functions, scope);
                }
            }
            this.indexFunction(projectKey, importPath, packageName, m.name, null, filePathRelativeToHome, m.functions, scope);
        }
    }

    private void indexFunction(String projectKey, String importPath, String packageName, String moduleName, String className, String filePathRelativeToHome, List<PythonDocPortalService.Function> functions, PythonDocPortalService.PackageScope scope) throws InterruptedException {
        if (functions == null) {
            return;
        }
        for (PythonDocPortalService.Function f : functions) {
            IndexedEntry funcEntry = new IndexedEntry(projectKey, null, importPath, packageName, moduleName, className, f.name, f.name, f.params, f.docstring, filePathRelativeToHome, scope);
            this.indexSingleEntry(funcEntry, "FUNCTION");
        }
    }

    public void indexSingleEntry(IndexedEntry e, String nodeType) throws InterruptedException {
        String params = null;
        if (e.arguments != null) {
            ArrayList<CallSite> ss = new ArrayList<CallSite>();
            for (PythonDocPortalService.Param param : e.arguments) {
                if (StringUtils.isBlank((String)param.name) || !StringUtils.isNotBlank((String)param.type)) continue;
                ss.add((CallSite)((Object)(param.name + ": " + param.type)));
            }
            params = String.join((CharSequence)", ", ss);
        }
        LuceneDocBuilder doc = LuceneDocBuilder.from((String)TYPE, (LuceneMappingsAnalyzer)this.pythonDocPortalMappingsAnalyzer);
        doc.addString(PROJECT_KEY_FIELD, e.projectKey);
        doc.addString(PACKAGE_NAME_FIELD, e.packageName);
        doc.addString(MODULE_NAME_FIELD, e.moduleName);
        doc.addString(CLASS_NAME_FIELD, e.className);
        doc.addString(FUNCTION_NAME_FIELD, e.functionName);
        doc.addString(NAME_FIELD, e.name);
        doc.addString(ARGUMENTS_FIELD, params);
        doc.addString(IMPORT_PATH_FIELD, e.importPath);
        doc.addString(DOCSTRING_FIELD, e.docstring);
        doc.addString(NODE_TYPE_FIELD, nodeType);
        doc.addString(PACKAGE_SCOPE_FIELD, e.packageScope.toString());
        this.pythonDocPortalIndexManager.addDocument(doc);
    }

    public static class IndexedEntry {
        public String projectKey;
        public String authorized_members;
        public String packageName;
        public String moduleName;
        public String className;
        public String functionName;
        public String name;
        public List<PythonDocPortalService.Param> arguments;
        public String importPath;
        public String docstring;
        public PythonDocPortalService.PackageScope packageScope;

        public IndexedEntry(String projectKey, String authorized_members, String importPath, String packageName, String moduleName, String className, String functionName, String name, List<PythonDocPortalService.Param> arguments, String docstring, String path, PythonDocPortalService.PackageScope scope) {
            this.projectKey = projectKey;
            this.authorized_members = authorized_members;
            this.importPath = importPath;
            this.packageName = packageName;
            this.moduleName = moduleName;
            this.className = className;
            this.functionName = functionName;
            this.name = name;
            this.arguments = arguments;
            this.docstring = docstring;
            this.packageScope = scope;
        }
    }
}

