/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.common.rpc;

import com.dataiku.common.rpc.NoAuthAPIClient;
import com.dataiku.common.server.APIError;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class NoAuthThrottlingAPIClient
extends NoAuthAPIClient {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.api.intercom.noauththrottlingapiclient");
    private final int maxRetries;
    private final int defaultSleepSeconds;

    public NoAuthThrottlingAPIClient(String url, boolean trustAllCerts, ProxySettings proxySettings, int connectionTimeout, int socketTimeout, int maxRetries, int defaultSleepSeconds) {
        super(url, trustAllCerts, proxySettings, connectionTimeout, socketTimeout);
        this.maxRetries = maxRetries;
        this.defaultSleepSeconds = defaultSleepSeconds;
    }

    private <T> T executeWithRetry(RequestExecutor<T> executor) throws IOException {
        int attempt = 0;
        while (true) {
            try {
                if (attempt > 0) {
                    logger.info((Object)("Retrying query " + this.baseURI));
                }
                return executor.execute();
            }
            catch (APIError.APIErrorException e) {
                APIError error = (APIError)e.error;
                if (error.httpStatusCode != null && error.httpStatusCode == 429 && ++attempt <= this.maxRetries) {
                    String retryAfterHeader;
                    long sleepSeconds = this.defaultSleepSeconds;
                    if (error.headers != null && (retryAfterHeader = error.headers.get("retry-after")) != null) {
                        try {
                            sleepSeconds = Long.parseLong(retryAfterHeader) + 1L;
                        }
                        catch (NumberFormatException nfe) {
                            logger.warn((Object)("Could not parse retry-after header: " + retryAfterHeader + ". Using " + sleepSeconds + " instead"));
                        }
                    }
                    logger.warn((Object)String.format("HTTP 429. Waiting %d seconds and retry (%d/%d)", sleepSeconds, attempt, this.maxRetries));
                    try {
                        TimeUnit.SECONDS.sleep(sleepSeconds);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new IOException("Interrupted while waiting to retry", ie);
                    }
                    continue;
                }
                if (error.httpStatusCode != null && error.httpStatusCode == 429) {
                    logger.error((Object)("Too many retries (" + this.maxRetries + "), giving up."));
                }
                throw e;
            }
            break;
        }
    }

    @Override
    public <T> T postObject(String method, Class<T> ofClazz, Object arg) throws IOException {
        return (T)this.executeWithRetry(() -> super.postObject(method, ofClazz, arg));
    }

    @Override
    public <T> T postObject(String method, int timeout, Class<T> ofClazz, Object arg) throws IOException {
        return (T)this.executeWithRetry(() -> super.postObject(method, timeout, ofClazz, arg));
    }

    @Override
    public <T> T postObject(String method, TypeToken<T> ofClazz, Object arg) throws IOException {
        return (T)this.executeWithRetry(() -> super.postObject(method, ofClazz, arg));
    }

    @Override
    public <T> T postObject(String method, int timeout, TypeToken<T> ofClazz, Object arg) throws IOException {
        return (T)this.executeWithRetry(() -> super.postObject(method, timeout, ofClazz, arg));
    }

    @FunctionalInterface
    private static interface RequestExecutor<T> {
        public T execute() throws IOException;
    }
}

