/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip;

import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.module.ModuleUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.CloudStacksCloud;
import com.dataiku.dip.server.services.DeploymentMode;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.RateLimiter;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.INIConfiguration;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.builder.BuilderParameters;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.builder.fluent.INIBuilderParameters;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.builder.fluent.Parameters;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.ex.ConfigurationException;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class DKUApp {
    protected static Logger logger = Logger.getLogger(DKUApp.class);
    private static boolean runsWithoutConfig = false;
    public static final String JAVA_COMPILER_TARGET_VERSION = "17";
    private static final RateLimiter dipPropertiesRateLimiter = RateLimiter.create((double)1.0);
    private static volatile File dataikuApplicationStringF;
    private static Boolean hideLogs_;
    private static boolean hideErrorStacks_;
    private static boolean hideLogTails_;
    private static Boolean secureCookies_;
    private static Boolean sameSiteNoneCookies_;
    static File baseFolderF;
    static File installFolderF;
    static Params params;
    static long paramsTS;
    private static volatile String localHostnameCache;
    private static volatile String cachedLicenseInstanceId;
    private static INIConfiguration cachedIni;
    private static long cachedIniTS;
    private static volatile boolean hasCachedInstallId;
    private static volatile String cachedInstallId;
    private static volatile boolean hasCachedNodeId;
    private static volatile String cachedNodeId;
    private static volatile boolean hasCachedInstallNodeType;
    private static volatile String cachedInstallNodeType;
    private static MainLoggingConfigurator.ProcessType processType;
    public static final String DATAIKU_PREFIX = "DKU";
    public static final String LICENSE = "LICENSE";

    protected static void ensureCorrectJavaVersionForDev() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("11.")) {
            throw new IllegalArgumentException(String.format("Detected runtime java version '%s', requires java %s+", javaVersion, JAVA_COMPILER_TARGET_VERSION));
        }
        ModuleUtils.openAllModules();
    }

    public static void setBaseFolder(String baseFolder, String installFolder) {
        baseFolderF = new File(baseFolder);
        installFolderF = new File(installFolder);
        runsWithoutConfig = false;
        DKUApp.loadProperties();
    }

    public static void configureNoConfig(String baseFolder, String installFolder) {
        baseFolderF = new File(baseFolder);
        installFolderF = new File(installFolder);
        runsWithoutConfig = true;
    }

    public static boolean isConfigured() {
        return baseFolderF != null;
    }

    public static File getResourceFile(String path) {
        return DKUFileUtils.getWithin((File)new File(DKUApp.getInstallFolder(), "resources"), (String[])new String[]{path});
    }

    public static File getResourceFile(String ... chunks) {
        return DKUFileUtils.getWithin((File)new File(DKUApp.getInstallFolder(), "resources"), (String[])chunks);
    }

    public static File getUserResourceFile(String ... chunks) {
        return DKUFileUtils.getWithin((File)new File(DKUApp.getBaseFolder(), "resources"), (String[])chunks);
    }

    public static void touchProperties() {
        paramsTS = -1L;
    }

    public static synchronized void setForcedParams(Params p) {
        params = p;
    }

    private static void loadProperties() {
        if (runsWithoutConfig) {
            if (params == null) {
                params = new Params();
            }
            return;
        }
        try {
            if (params != null && paramsTS != -1L && !dipPropertiesRateLimiter.tryAcquire()) {
                return;
            }
            File f = new File(baseFolderF, "config/dip.properties");
            if (!f.exists()) {
                throw new RuntimeException("DIP properties config file does not exist");
            }
            if (f.lastModified() != paramsTS) {
                logger.info((Object)("Loading DIP properties from " + f.getAbsolutePath()));
                Properties config = new Properties();
                FileInputStream fis = new FileInputStream(f);
                config.load(fis);
                fis.close();
                params = new Params((Map)Maps.fromProperties((Properties)config));
                params.add("dip.home", baseFolderF.getAbsolutePath());
                paramsTS = f.lastModified();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load DIP properties", e);
        }
    }

    public static boolean debugEnabled() {
        String val = System.getenv("DKU_DEBUG_MODE");
        return val != null && val.toLowerCase().equals("debug");
    }

    public static String getBaseFolder() {
        if (baseFolderF == null) {
            throw new Error("DIP configuration not initialized, look for previous error");
        }
        return baseFolderF.getAbsolutePath();
    }

    public static File getBaseFolderF() {
        if (baseFolderF == null) {
            throw new Error("DIP configuration not initialized, look for previous error");
        }
        assert (baseFolderF != null);
        return baseFolderF;
    }

    public static String getInstallFolder() {
        if (installFolderF == null) {
            throw new Error("DIP installation not initialized, look for previous error");
        }
        return installFolderF.getAbsolutePath();
    }

    public static File getInstallFolderF() {
        if (installFolderF == null) {
            throw new Error("DIP installation not initialized, look for previous error");
        }
        assert (installFolderF != null);
        return installFolderF;
    }

    public static boolean exists(String path) {
        return DKUFileUtils.exists((File)DKUApp.getBaseFolderF(), (String[])new String[]{path});
    }

    public static File getFile(String path) {
        return DKUFileUtils.getWithin((File)DKUApp.getBaseFolderF(), (String[])new String[]{path});
    }

    public static File getFile(String ... pathChunks) {
        return DKUFileUtils.getWithin((File)DKUApp.getBaseFolderF(), (String[])pathChunks);
    }

    public static File getFile(File base, String ... pathChunks) {
        return DKUFileUtils.getWithin((File)base, (String[])pathChunks);
    }

    public static File getInstallFile(String ... pathChunks) {
        return DKUFileUtils.getWithin((File)new File(DKUApp.getInstallFolder()), (String[])pathChunks);
    }

    public static String getRelativePath(File f) throws IOException {
        return StringUtils.replaceOnce((String)f.getCanonicalPath(), (String)DKUApp.getBaseFolderF().getCanonicalPath(), (String)"");
    }

    public static synchronized Params getParams() {
        if (baseFolderF == null) {
            throw new Error("DIP configuration not initialized, look for previous error");
        }
        DKUApp.loadProperties();
        return params;
    }

    public static synchronized String getMandatoryProperty(String key) {
        DKUApp.loadProperties();
        return params.getNonEmptyMandParam(key);
    }

    public static synchronized String getProperty(String key, String defaultValue) {
        DKUApp.loadProperties();
        return params.getParam(key, defaultValue);
    }

    public static synchronized int getProperty(String key, int defaultValue) {
        return Integer.parseInt(DKUApp.getProperty(key, String.valueOf(defaultValue)));
    }

    public static synchronized long getProperty(String key, long defaultValue) {
        return Long.parseLong(DKUApp.getProperty(key, String.valueOf(defaultValue)));
    }

    public static synchronized boolean getProperty(String key, boolean defaultValue) {
        return Boolean.parseBoolean(DKUApp.getProperty(key, String.valueOf(defaultValue)));
    }

    public static DSSVersion getDSSVersion() {
        try {
            return (DSSVersion)JSON.parseFile((File)DKUApp.getDSSVersionF(), DSSVersion.class);
        }
        catch (IOException e) {
            DSSVersion ret = new DSSVersion();
            ret.product_version = "Unknown";
            return ret;
        }
    }

    public static String getDSSVersionTag() {
        return DKUApp.getDSSVersion().product_version.replace('/', '_').toLowerCase();
    }

    public static File getDSSVersionF() {
        return DKUApp.getFile("dss-version.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getDataikuApplicationStringF() throws IOException {
        if (dataikuApplicationStringF != null) return dataikuApplicationStringF;
        Class<DKUApp> clazz = DKUApp.class;
        synchronized (DKUApp.class) {
            if (dataikuApplicationStringF != null) return dataikuApplicationStringF;
            String applicationString = DKUApp.getDataikuApplicationString();
            File versionFolder = DKUApp.getFile("tmp", "application-version", DigestUtils.md5Hex((String)applicationString));
            dataikuApplicationStringF = DKUApp.getFile(versionFolder, "dataiku-app-str.txt");
            if (dataikuApplicationStringF.exists()) return dataikuApplicationStringF;
            File tmpFile = DKUApp.getFile(versionFolder, UUID.randomUUID().toString());
            DKUFileUtils.writeFileUTF8((File)tmpFile, (String)applicationString, (boolean)true);
            if (tmpFile.renameTo(dataikuApplicationStringF)) return dataikuApplicationStringF;
            if (!dataikuApplicationStringF.exists()) throw new IOException("Unable to rename temporary file into " + dataikuApplicationStringF.getName());
            if (tmpFile.delete()) return dataikuApplicationStringF;
            logger.warn((Object)("Unable to delete temporary file " + tmpFile.getAbsolutePath()));
            // ** MonitorExit[var0] (shouldn't be in output)
            return dataikuApplicationStringF;
        }
    }

    public static String getDataikuApplicationString() {
        return "dataiku_dss";
    }

    public static boolean isDataikuCloud() {
        return new File("/etc/dataiku-cloud").isFile();
    }

    private static File getCloudStacksF() {
        return new File("/etc/dataiku-cloudstacks");
    }

    private static boolean isCloudStacks() {
        return DKUApp.getCloudStacksF().isFile();
    }

    public static DeploymentMode getDeploymentMode() {
        if (DKUApp.isCloudStacks()) {
            return DeploymentMode.CLOUDSTACKS;
        }
        if (DKUApp.isDataikuCloud()) {
            return DeploymentMode.CLOUD;
        }
        return DeploymentMode.CUSTOM;
    }

    public static CloudStacksCloud getCloudStacksCloud() {
        if (!DKUApp.isCloudStacks()) {
            return CloudStacksCloud.NONE;
        }
        try {
            String content;
            return switch (content = DKUFileUtils.readFileToStringUTF8((File)DKUApp.getCloudStacksF()).trim()) {
                case "AWS" -> CloudStacksCloud.AWS;
                case "AZURE" -> CloudStacksCloud.AZURE;
                case "GCP" -> CloudStacksCloud.GCP;
                default -> CloudStacksCloud.UNKNOWN;
            };
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read /etc/dataiku-cloudstacks", (Throwable)e);
            return CloudStacksCloud.UNKNOWN;
        }
    }

    public static boolean hideLogs() {
        return hideLogs_;
    }

    public static boolean hideErrorStacks() {
        return hideErrorStacks_;
    }

    public static boolean hideLogTails() {
        return hideLogTails_;
    }

    public static boolean secureCookies() {
        return secureCookies_;
    }

    public static boolean sameSiteNoneCookies() {
        return sameSiteNoneCookies_;
    }

    public static void setSecurityFlags(boolean hideLogs, boolean hideErrorStacks, boolean hideLogTails, boolean secureCookies, boolean sameSiteNoneCookies) {
        hideLogs_ = hideLogs;
        hideErrorStacks_ = hideErrorStacks;
        hideLogTails_ = hideLogTails;
        secureCookies_ = secureCookies;
        sameSiteNoneCookies_ = sameSiteNoneCookies;
    }

    public static void setSecurityFlags(boolean hideLogs, boolean hideErrorStacks, boolean secureCookies, boolean sameSiteNoneCookies) {
        DKUApp.setSecurityFlags(hideLogs, hideErrorStacks, false, secureCookies, sameSiteNoneCookies);
    }

    public static void setSecurityFlags(boolean hideErrorStacks, boolean secureCookies, boolean sameSiteNoneCookies) {
        DKUApp.setSecurityFlags(false, hideErrorStacks, false, secureCookies, sameSiteNoneCookies);
    }

    private static String licenseInstanceId() {
        LicenseStatusService lss = SpringUtils.getBean(LicenseStatusService.class);
        LicenseStatusService.LicensingStatus status = lss.getLicensingStatus();
        try {
            if (!status.hasLicense) {
                return "NOLIC";
            }
            if (status.licenseContent.instanceId != null) {
                return status.licenseContent.instanceId;
            }
            return "OLDLIC";
        }
        catch (Throwable e) {
            return "ERR";
        }
    }

    private static String getLocalHostnameCached() {
        if (localHostnameCache != null) {
            return localHostnameCache;
        }
        try {
            String osName = System.getProperty("os.name");
            if ("Mac OS X".equals(osName)) {
                byte[] raw = DKUtils.execAndGetOutput((String[])new String[]{"hostname"}, null);
                String s = new String(raw, StandardCharsets.UTF_8);
                localHostnameCache = s.trim();
            } else {
                localHostnameCache = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (Throwable e) {
            logger.info((Object)"Failed to resolve local hostname", e);
            localHostnameCache = "unknown";
        }
        logger.info((Object)("Computed local hostname: " + localHostnameCache));
        return localHostnameCache;
    }

    public static void invalidateCachedLicenseInstanceId() {
        cachedLicenseInstanceId = null;
    }

    public static String dipInstanceId() {
        if (System.getenv("DKU_INSTANCE_ID") != null) {
            return System.getenv("DKU_INSTANCE_ID");
        }
        if (cachedLicenseInstanceId == null) {
            logger.info((Object)"Computing license instance id");
            cachedLicenseInstanceId = DKUApp.licenseInstanceId();
            logger.info((Object)("Computed license instance id: " + cachedLicenseInstanceId));
        }
        String hostHash = DigestUtils.md5Hex((String)DKUApp.getLocalHostnameCached());
        String homeHash = DigestUtils.md5Hex((String)DKUApp.getBaseFolder());
        return cachedLicenseInstanceId + "-" + hostHash + "-" + homeHash;
    }

    private static void loadIni() throws IOException, ConfigurationException {
        File f;
        if (runsWithoutConfig && cachedIni == null) {
            cachedIni = new INIConfiguration();
            cachedIniTS = System.currentTimeMillis();
        }
        if (!(f = DKUApp.getFile("install.ini")).exists()) {
            throw new FileNotFoundException("install.ini file does not exist");
        }
        if (f.lastModified() != cachedIniTS) {
            logger.info((Object)("Reading " + f.getAbsolutePath()));
            INIBuilderParameters params = (INIBuilderParameters)new Parameters().ini().setFileName(f.getAbsolutePath());
            FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(INIConfiguration.class).configure(new BuilderParameters[]{params});
            cachedIni = (INIConfiguration)builder.getConfiguration();
            cachedIniTS = f.lastModified();
        }
    }

    public static String getInstallId() {
        if (!hasCachedInstallId) {
            cachedInstallId = DKUApp.getIniValue("general", "installid", "notattributed", "error");
            hasCachedInstallId = true;
        }
        return cachedInstallId;
    }

    public static String getNodeId() {
        if (!hasCachedNodeId) {
            cachedNodeId = DKUApp.getIniValue("general", "nodeid", null, null);
            hasCachedNodeId = true;
        }
        return cachedNodeId;
    }

    public static String getInstallNodeType() {
        if (!hasCachedInstallNodeType) {
            cachedInstallNodeType = DKUApp.getIniValue("general", "nodetype", "design");
            if ("automation".equals(cachedInstallNodeType) && "false".equals(DKUApp.getIniValue("modules", "projects"))) {
                cachedInstallNodeType = "deployer";
            }
            hasCachedInstallNodeType = true;
        }
        return cachedInstallNodeType;
    }

    public static String getIniValue(String section, String key) {
        return DKUApp.getIniValue(section, key, null);
    }

    public static String getIniValue(String section, String key, String defaultValue) {
        try {
            DKUApp.loadIni();
            String configurationKey = String.format("%s.%s", section.replace(".", ".."), key.replace(".", ".."));
            return cachedIni.getString(configurationKey, defaultValue);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read install.ini file", e);
        }
    }

    public static String getIniValue(String section, String key, String defaultValue, String errorValue) {
        try {
            return DKUApp.getIniValue(section, key, defaultValue);
        }
        catch (Exception e) {
            return errorValue;
        }
    }

    public static String findJar(String jarName) {
        for (URL url : ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs()) {
            String file = url.getFile();
            if (!file.endsWith(jarName)) continue;
            return file;
        }
        return null;
    }

    public static LicensingMode getLicensingMode() {
        String mode = DKUApp.getProperty("licensingMode", "ON_PREMISE_DISCONNECTED");
        LicensingMode licensingMode = LicensingMode.valueOf(mode);
        return licensingMode;
    }

    public static boolean isSAASLicensing() {
        return DKUApp.getLicensingMode() == LicensingMode.SAAS;
    }

    public static boolean isSAASAuth() {
        return DKUApp.getLicensingMode() == LicensingMode.SAAS && DKUApp.getProperty("saasAuth", "false").equals("true");
    }

    public static MainLoggingConfigurator.ProcessType getProcessType() {
        return processType;
    }

    public static void setProcessType(MainLoggingConfigurator.ProcessType processType) {
        DKUApp.processType = processType;
    }

    public static boolean getRunsWithoutConfig() {
        return runsWithoutConfig;
    }

    public static String getContainerUIDGID() {
        String uid = DKUApp.getParams().getParam("dku.container.dataiku.uid", "500");
        String gid = DKUApp.getParams().getParam("dku.container.dataiku.gid", null);
        return gid != null ? String.format("%s:%s", uid, gid) : uid;
    }

    static {
        paramsTS = -1L;
        processType = MainLoggingConfigurator.ProcessType.UNKNOWN;
    }

    @UIModel
    public static class DSSVersion {
        public String conf_version;
        public String product_version;
        String product_commitid;
    }

    @UIModel
    public static enum LicensingMode {
        NONE,
        SAAS,
        ON_PREMISE_CONNECTED,
        ON_PREMISE_DISCONNECTED;

    }
}

