/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip;

import com.dataiku.dip.DKUApp;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FeatureFlags {
    public static final String APINODE_CODEENVS_GLOBAL_CACHE = "apinode_codeenvs_global_cache";
    public static Set<String> DEFAULT_ENABLED_FEATURE_FLAGS = Sets.newHashSet((Object[])new String[]{"homepageRedesign", "allowForeignInProjectObjectLists", "generateFlowWithAI", "enableForeignSavedModelView", "newSQLNotebookEditor"});

    public static boolean isEnabled(String name) {
        if (System.getenv("DKU_" + name) != null) {
            return true;
        }
        boolean defaultValue = DEFAULT_ENABLED_FEATURE_FLAGS.contains(name);
        return DKUApp.getParams().getBoolParam("dku.feature." + name + ".enabled", defaultValue);
    }

    public static List<String> listEnabled() {
        HashSet<String> result = new HashSet<String>(DEFAULT_ENABLED_FEATURE_FLAGS);
        Pattern featureFlagPattern = Pattern.compile("dku\\.feature\\.(.*)\\.enabled");
        for (Map.Entry kv : DKUApp.getParams().getAll().entrySet()) {
            Matcher featureFlagMatcher = featureFlagPattern.matcher((CharSequence)kv.getKey());
            if (featureFlagMatcher.matches() && "true".equalsIgnoreCase((String)kv.getValue())) {
                result.add(featureFlagMatcher.group(1));
                continue;
            }
            if (!featureFlagMatcher.matches() || !"false".equalsIgnoreCase((String)kv.getValue())) continue;
            result.remove(featureFlagMatcher.group(1));
        }
        return Lists.newArrayList(result);
    }
}

