/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.dao.IGlobalDAO;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractGlobalDAO<T>
implements IGlobalDAO<T> {
    protected Logger logger = Logger.getLogger((String)"dku.dao");

    protected abstract T getOrNull(String var1, boolean var2) throws IOException;

    protected abstract List<T> list(boolean var1) throws IOException;

    protected abstract RelFile getDAOFile(String var1);

    protected abstract String getType();

    @Override
    public List<T> list() throws IOException {
        return this.list(false);
    }

    @Override
    public List<T> listUnsafe() throws IOException {
        return this.list(true);
    }

    @Override
    public T getOrNull(String id) throws IOException {
        return this.getOrNull(id, false);
    }

    @Override
    public T getOrNullUnsafe(String id) throws IOException {
        return this.getOrNull(id, true);
    }

    @Override
    public T getMandatory(String id) throws IOException {
        return this.getMandatory(id, false);
    }

    @Override
    public T getMandatoryUnsafe(String id) throws IOException {
        return this.getMandatory(id, true);
    }

    protected T getMandatory(String id, boolean unsafe) throws IOException {
        T obj = this.getOrNull(id, unsafe);
        if (obj == null) {
            throw new NotFoundException(this.getType() + " does not exist: " + id);
        }
        return obj;
    }

    @Override
    public int approximateCount() throws IOException {
        return this.listUnsafe().size();
    }

    @Override
    public boolean exists(String id) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile daoFile = this.getDAOFile(id);
        return t.isFile(daoFile);
    }
}

