/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUProfiler;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DkuProfilingDAO<T extends DkuProfilerSettings> {
    @Autowired
    TransactionService transactionService;
    private static final RelFile configPath = new RelFile("profiling.json");
    private final Class<T> clazz;

    protected DkuProfilingDAO(Class<T> clazz) {
        this.clazz = clazz;
    }

    public T getProfilerSettings_AutoTXN() throws IOException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            DkuProfilerSettings dkuProfilerSettings = (DkuProfilerSettings)t.readObjectDefault(configPath, this.clazz);
            return (T)dkuProfilerSettings;
        }
    }

    public void saveProfilerSettings(T settings) throws IOException {
        TransactionContext.retrieveWrite().writeObject(configPath, (DkuProfilerSettings)Preconditions.checkNotNull(settings));
    }

    @UIModel
    public static class DkuProfilerSettings {
        public boolean backendProfilingEnabled;
        public int maxSizeMB = 500;
        public DKUProfiler.JFRConfigName jfrConfigName = DKUProfiler.JFRConfigName.DEFAULT;
    }
}

