/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.dip.futures.FutureProgressState;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;

public class FutureProgressStateSnapshot {
    public Deque<FutureProgressState> states = new ArrayDeque<FutureProgressState>();

    public synchronized FutureProgressStateSnapshot getSnapshot() {
        FutureProgressStateSnapshot copy = new FutureProgressStateSnapshot();
        for (FutureProgressState state : this.states) {
            copy.push(state.getSnapshot());
        }
        return copy;
    }

    public synchronized int size() {
        return this.states.size();
    }

    public synchronized void push(FutureProgressState state) {
        this.states.addLast(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushAll(FutureProgressStateSnapshot snapshot) {
        ArrayList tmp = Lists.newArrayList();
        FutureProgressStateSnapshot futureProgressStateSnapshot = snapshot;
        synchronized (futureProgressStateSnapshot) {
            tmp.addAll(snapshot.states);
        }
        futureProgressStateSnapshot = this;
        synchronized (futureProgressStateSnapshot) {
            for (FutureProgressState state : tmp) {
                this.states.addLast(state);
            }
        }
    }

    public synchronized FutureProgressState pop() {
        return this.states.size() > 0 ? this.states.removeLast() : null;
    }

    public synchronized FutureProgressState safePeek() {
        return this.states.size() > 0 ? this.states.peekLast() : null;
    }

    public synchronized void clear() {
        this.states.clear();
    }
}

