/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.git;

import com.dataiku.dip.git.DKUDiffFormatter;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.utils.ErrorContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.DiffCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class BaseDiffBuilder {
    protected Git git;
    private DKUDiffFormatter diffFormatter;

    public BaseDiffBuilder(Git git) {
        this.git = git;
        this.diffFormatter = new DKUDiffFormatter(git);
    }

    public BaseDiffBuilder() {
        this.diffFormatter = new DKUDiffFormatter(null);
    }

    public DKUDiffFormatter getDiffFormatter() {
        return this.diffFormatter;
    }

    private List<DiffEntry> makeGitDiffCall(TreeFilter tf, ObjectId fromTree, ObjectId toTree) throws IncorrectObjectTypeException, IOException, GitAPIException {
        ObjectReader reader = this.git.getRepository().newObjectReader();
        CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
        oldTreeIter.reset(reader, (AnyObjectId)fromTree);
        CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
        newTreeIter.reset(reader, (AnyObjectId)toTree);
        DiffCommand dc = this.git.diff().setOldTree((AbstractTreeIterator)oldTreeIter).setNewTree((AbstractTreeIterator)newTreeIter);
        if (tf != null) {
            dc = dc.setPathFilter(tf);
        }
        List listDiffs = dc.call();
        return listDiffs;
    }

    private List<DiffEntry> makeGitDiffCall(TreeFilter tf, ObjectId toTree) throws IOException, GitAPIException {
        ObjectReader reader = this.git.getRepository().newObjectReader();
        CanonicalTreeParser oldTree = new CanonicalTreeParser();
        oldTree.reset(reader, (AnyObjectId)toTree);
        DiffCommand dc = this.git.diff().setOldTree((AbstractTreeIterator)oldTree);
        if (tf != null) {
            dc = dc.setPathFilter(tf);
        }
        List listDiffs = dc.call();
        return listDiffs;
    }

    protected List<GitModel.DKUDiffEntry> diffTrees(TreeFilter tf, ObjectId fromTree, ObjectId toTree, boolean nameOnly) throws GitAPIException, IOException {
        ArrayList<GitModel.DKUDiffEntry> ret = new ArrayList<GitModel.DKUDiffEntry>();
        List<DiffEntry> listDiffs = this.makeGitDiffCall(tf, fromTree, toTree);
        for (DiffEntry diff : listDiffs) {
            ret.add(this.diffFormatter.buildDiffEntry(diff, nameOnly));
        }
        return ret;
    }

    protected List<GitModel.DKUDiffEntry> diffTrees(TreeFilter tf, ObjectId toTree, boolean nameOnly) throws GitAPIException, IOException {
        ArrayList<GitModel.DKUDiffEntry> ret = new ArrayList<GitModel.DKUDiffEntry>();
        List<DiffEntry> listDiffs = this.makeGitDiffCall(tf, toTree);
        for (DiffEntry diff : listDiffs) {
            ret.add(this.diffFormatter.buildDiffEntry(diff, nameOnly));
        }
        return ret;
    }

    protected GitModel.LimitedDKUDiffEntryList diffTreesLimited(TreeFilter tf, ObjectId fromTree, ObjectId toTree, long limit) throws GitAPIException, IOException {
        GitModel.LimitedDKUDiffEntryList ret = new GitModel.LimitedDKUDiffEntryList();
        List<DiffEntry> listDiffs = this.makeGitDiffCall(tf, fromTree, toTree);
        int count = 0;
        long estimatedFootprint = 0L;
        for (DiffEntry diff : listDiffs) {
            GitModel.DKUDiffEntry entry = this.diffFormatter.buildDiffEntry(diff, false);
            if ((estimatedFootprint += entry.estimatedFootprint()) <= limit) {
                ret.add(entry);
            }
            ++count;
        }
        ret.setTrueCount(count);
        Logger.getLogger((String)"dip.jgit").info((Object)("Found " + count + " diffs, estimated footprint " + estimatedFootprint + " bytes (returned=" + ret.size() + ")"));
        return ret;
    }

    public List<GitModel.DKUDiffEntry> diffWorkingCopy(TreeFilter tf) throws IOException {
        ArrayList<GitModel.DKUDiffEntry> ret = new ArrayList<GitModel.DKUDiffEntry>();
        Repository repository = this.git.getRepository();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DiffFormatter df = new DiffFormatter((OutputStream)baos);){
            df.setRepository(repository);
            df.setPathFilter(tf);
            List result = df.scan((AbstractTreeIterator)new DirCacheIterator(repository.readDirCache()), (AbstractTreeIterator)new FileTreeIterator(repository));
            for (DiffEntry diffEntry : result) {
                GitModel.DKUDiffEntry out = new GitModel.DKUDiffEntry();
                out.changeType = diffEntry.getChangeType();
                out.oldPath = diffEntry.getOldPath();
                out.newPath = diffEntry.getNewPath();
                df.format(diffEntry);
                df.flush();
                out.fileChange = this.diffFormatter.formatFileChange(baos.toByteArray());
                baos.reset();
                ret.add(out);
            }
        }
        return ret;
    }

    public List<GitModel.DKUDiffEntry> diffSingleCommit(TreeFilter tf, RevCommit commit) throws IOException {
        ArrayList<GitModel.DKUDiffEntry> ret = new ArrayList<GitModel.DKUDiffEntry>();
        Repository repository = this.git.getRepository();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DiffFormatter df = new DiffFormatter((OutputStream)baos);){
            df.setRepository(repository);
            if (tf != null) {
                df.setPathFilter(tf);
            }
            List result = null;
            try (RevWalk rw = new RevWalk(repository);){
                RevCommit parent = null;
                if (commit.getParentCount() > 0 && commit.getParent(0) != null) {
                    parent = rw.parseCommit((AnyObjectId)commit.getParent(0).getId());
                }
                result = parent == null ? df.scan((AbstractTreeIterator)new EmptyTreeIterator(), (AbstractTreeIterator)new CanonicalTreeParser(null, rw.getObjectReader(), (AnyObjectId)commit.getTree())) : df.scan(parent.getTree(), commit.getTree());
            }
            for (DiffEntry diffEntry : result) {
                GitModel.DKUDiffEntry out = new GitModel.DKUDiffEntry();
                out.changeType = diffEntry.getChangeType();
                out.oldPath = diffEntry.getOldPath();
                out.newPath = diffEntry.getNewPath();
                df.format(diffEntry);
                df.flush();
                out.fileChange = this.diffFormatter.formatFileChange(baos.toByteArray());
                baos.reset();
                ret.add(out);
            }
        }
        return ret;
    }

    public GitModel.FileChange diffStrings(String s1, String s2) throws IOException {
        if (s1 == null) {
            throw ErrorContext.iae((String)"null provided for comparison as a string before");
        }
        if (s2 == null) {
            throw ErrorContext.iae((String)"null provided for comparison as a string after");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DiffFormatter df = new DiffFormatter((OutputStream)baos);){
            RawText rt1 = new RawText(s1.getBytes());
            RawText rt2 = new RawText(s2.getBytes());
            EditList diffList = new EditList();
            diffList.addAll((Collection)new HistogramDiff().diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)rt1, (Sequence)rt2));
            df.format(diffList, rt1, rt2);
            df.flush();
        }
        return this.diffFormatter.formatFileChange(baos.toByteArray(), 0);
    }
}

