/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.git;

import com.dataiku.dip.transactions.git.GitModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

public class JGitLogBuilder {
    private final Git git;
    private final Map<String, Set<GitModel.GitTag>> tagsByCommitId;

    public JGitLogBuilder(Git git, Map<String, Set<GitModel.GitTag>> tagsByCommitId) {
        this.git = git;
        this.tagsByCommitId = tagsByCommitId;
    }

    public List<GitModel.DKULogEntry> build(ObjectId since, ObjectId to, String basePath) throws GitAPIException, IOException {
        Iterable<RevCommit> commits = this.makeGitLogCall(since, to, basePath);
        ArrayList<GitModel.DKULogEntry> ret = new ArrayList<GitModel.DKULogEntry>();
        for (RevCommit rc : commits) {
            ret.add(GitModel.DKULogEntry.fromCommit(rc, this.tagsByCommitId));
        }
        return ret;
    }

    public GitModel.LimitedDKULogEntryList buildLimited(ObjectId since, ObjectId to, long limit, String basePath) throws GitAPIException, IOException {
        Iterable<RevCommit> commits = this.makeGitLogCall(since, to, basePath);
        GitModel.LimitedDKULogEntryList ret = new GitModel.LimitedDKULogEntryList();
        int count = 0;
        long estimatedFootprint = 0L;
        for (RevCommit rc : commits) {
            GitModel.DKULogEntry c = GitModel.DKULogEntry.fromCommit(rc, this.tagsByCommitId);
            if ((estimatedFootprint += c.estimatedFootprint()) <= limit) {
                ret.add(c);
            }
            rc.disposeBody();
            ++count;
        }
        ret.setTrueCount(count);
        Logger.getLogger((String)"dip.jgit").info((Object)("Found " + count + " commits, estimated footprint " + estimatedFootprint + " bytes (returned=" + ret.size() + ")"));
        return ret;
    }

    private Iterable<RevCommit> makeGitLogCall(ObjectId since, ObjectId to, String basePath) throws MissingObjectException, IncorrectObjectTypeException, GitAPIException {
        LogCommand command = this.git.log();
        command.addRange((AnyObjectId)since, (AnyObjectId)to);
        if (!StringUtils.isBlank((String)basePath)) {
            command.addPath(basePath);
        }
        Iterable commits = command.call();
        return commits;
    }

    public List<GitModel.DKULogEntry> build(ObjectId since, int count, List<String> paths) throws GitAPIException, IOException {
        LogCommand command = this.git.log();
        if (since != null) {
            command.add((AnyObjectId)since);
        }
        if (count != 0) {
            command.setMaxCount(count);
        }
        if (paths != null) {
            for (String path : paths) {
                command.addPath(path);
            }
        }
        Iterable commits = command.call();
        return StreamSupport.stream(commits.spliterator(), true).map(rc -> GitModel.DKULogEntry.fromCommit(rc, this.tagsByCommitId)).collect(Collectors.toList());
    }

    public List<GitModel.DKULogEntry> buildSince(ObjectId reference, ObjectId since, int count, List<String> paths) throws GitAPIException, IOException {
        LogCommand command = this.git.log();
        if (reference != null) {
            command.add((AnyObjectId)reference);
        }
        if (count != 0 && since == null) {
            command.setMaxCount(count);
        }
        if (paths != null) {
            for (String path : paths) {
                command.addPath(path);
            }
        }
        Iterable commits = command.call();
        ArrayList<GitModel.DKULogEntry> ret = new ArrayList<GitModel.DKULogEntry>();
        boolean found = since == null;
        int currentCount = 0;
        for (RevCommit rc : commits) {
            if (!found && rc.getId().equals((AnyObjectId)since)) {
                found = true;
            }
            if (!found) continue;
            if (currentCount >= count) break;
            ++currentCount;
            ret.add(GitModel.DKULogEntry.fromCommit(rc, this.tagsByCommitId));
        }
        return ret;
    }

    public LogsUntil buildUntil(ObjectId reference, ObjectId until, int count, List<String> paths) throws GitAPIException, IOException {
        RevCommit rc;
        LogCommand command = this.git.log();
        if (reference != null) {
            command.add((AnyObjectId)reference);
        }
        if (paths != null) {
            for (String path : paths) {
                command.addPath(path);
            }
        }
        Iterable commits = command.call();
        LinkedList<RevCommit> retCommits = new LinkedList<RevCommit>();
        LogsUntil logsUntil = new LogsUntil();
        Iterator iterator = commits.iterator();
        while (iterator.hasNext() && !(rc = (RevCommit)iterator.next()).getId().equals((AnyObjectId)until)) {
            ++logsUntil.countUntil;
            retCommits.add(rc);
            if (retCommits.size() <= count) continue;
            retCommits.remove(0);
        }
        logsUntil.countUntil -= retCommits.size();
        logsUntil.logEntries = retCommits.stream().map(revCommit -> GitModel.DKULogEntry.fromCommit(revCommit, this.tagsByCommitId)).collect(Collectors.toList());
        return logsUntil;
    }

    public List<GitModel.DKULogEntry> build(List<String> paths) throws GitAPIException, IOException {
        LogCommand command = this.git.log();
        for (String path : paths) {
            command.addPath(path);
        }
        Iterable commits = command.call();
        ArrayList<GitModel.DKULogEntry> ret = new ArrayList<GitModel.DKULogEntry>();
        for (RevCommit rc : commits) {
            ret.add(GitModel.DKULogEntry.fromCommit(rc, this.tagsByCommitId));
        }
        return ret;
    }

    public class LogsUntil {
        public int countUntil;
        public List<GitModel.DKULogEntry> logEntries;
    }
}

