/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.mail;

import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.security.AuthCtx;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class MailChannelConfiguration
implements IntegrationChannelParams {
    public boolean useCurrentUserAsSender;
    public String sender;
    public String authorizedDomain;

    public String computeFromField(@Nullable AuthCtx authCtx, @Nullable String messageFrom, @Nullable String defaultFrom) {
        if (this.useCurrentUserAsSender && authCtx != null && StringUtils.isNotBlank((String)authCtx.getUserEmail())) {
            return authCtx.getUserEmail();
        }
        if (StringUtils.isNotBlank((String)this.sender)) {
            return this.sender;
        }
        if (StringUtils.isNotBlank((String)messageFrom) && !this.useCurrentUserAsSender) {
            return messageFrom;
        }
        if (StringUtils.isBlank((String)defaultFrom)) {
            throw new IllegalArgumentException("Missing sender email address");
        }
        return defaultFrom;
    }
}

