/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.license;

import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.license.Keys;
import com.dataiku.dip.license.License;
import com.dataiku.dip.license.TrialToken;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.net.NetworkInterface;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LicenseUtils {
    private static Logger logger = Logger.getLogger((String)"dku.license");

    public static boolean verifySignature(byte[] pubkeyBytes, byte[] signature, byte[] signedData) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(pubkeyBytes));
        Signature signer = Signature.getInstance("SHA256WithRSA");
        signer.initVerify(pubKey);
        signer.update(signedData);
        return signer.verify(signature);
    }

    public static String sign(byte[] dataToSign, byte[] privkeyBytes) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privkeyBytes));
        Signature signature = Signature.getInstance("SHA256WithRSA");
        signature.initSign(privKey);
        signature.update(dataToSign);
        byte[] signatureBytes = signature.sign();
        return Base64.encodeBase64String((byte[])signatureBytes);
    }

    public static void verify(License license) throws Exception {
        if (StringUtils.isBlank((String)license.r1Pub) || StringUtils.isBlank((String)license.r1Sig) || StringUtils.isBlank((String)license.r1PubSig)) {
            throw new ApplicativeException("Invalid license", "Your license key is not validly signed");
        }
        if (!LicenseUtils.verifySignature(Keys.getR0pubkey(), Base64.decodeBase64((String)license.r1PubSig), Base64.decodeBase64((String)license.r1Pub))) {
            throw new ApplicativeException("Invalid license", "Your license key is not validly signed");
        }
        String licenseContent = JSON.json((Object)license.content);
        if (!LicenseUtils.verifySignature(Base64.decodeBase64((String)license.r1Pub), Base64.decodeBase64((String)license.r1Sig), licenseContent.getBytes("utf8"))) {
            throw new ApplicativeException("Invalid license", "Your license is not validly signed");
        }
    }

    private static String hostnameHash() {
        try {
            return DigestUtils.md5Hex((byte[])FileUtils.readFileToByteArray((File)new File("/etc/hostname")));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read hostname", (Throwable)e);
            throw new IllegalArgumentException("Failed to compute node ID, please contact Dataiku: " + e.getMessage(), e);
        }
    }

    public static String getMainNodeId() throws Exception {
        ArrayList<String> nodeIds = new ArrayList<String>();
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            byte[] hwAddr;
            NetworkInterface ni = en.nextElement();
            if (ni.isLoopback() || (hwAddr = ni.getHardwareAddress()) == null) continue;
            Object mac = "";
            for (byte b : ni.getHardwareAddress()) {
                if (((String)mac).length() > 0) {
                    mac = (String)mac + ":";
                }
                mac = (String)mac + String.format("%02X", b);
            }
            nodeIds.add((String)mac);
        }
        if (nodeIds.size() == 0) {
            nodeIds.add(LicenseUtils.hostnameHash());
        }
        Collections.sort(nodeIds);
        return ((String)nodeIds.get(nodeIds.size() - 1)).toLowerCase();
    }

    public static boolean verifyNode(List<String> allowedNodes) throws Exception {
        if (allowedNodes == null) {
            return true;
        }
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            byte[] hwAddr = ni.getHardwareAddress();
            if (hwAddr == null) continue;
            Object mac = "";
            for (byte b : ni.getHardwareAddress()) {
                if (((String)mac).length() > 0) {
                    mac = (String)mac + ":";
                }
                mac = (String)mac + String.format("%02X", b);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Checking if mac " + (String)mac + " is allowed"));
            }
            if (!allowedNodes.contains(((String)mac).toLowerCase())) continue;
            return true;
        }
        logger.info((Object)"MAC not found: Fallback on hostname");
        return allowedNodes.contains(LicenseUtils.hostnameHash());
    }

    public static void verify(TrialToken token) throws Exception {
        if (StringUtils.isBlank((String)token.r1Pub) || StringUtils.isBlank((String)token.r1Sig) || StringUtils.isBlank((String)token.r1PubSig)) {
            throw new ApplicativeException("Invalid trial token", "Your trial token is not validly signed");
        }
        if (!LicenseUtils.verifySignature(Keys.getR0pubkey(), Base64.decodeBase64((String)token.r1PubSig), Base64.decodeBase64((String)token.r1Pub))) {
            throw new ApplicativeException("Invalid trial token", "Your trial token is not validly signed");
        }
        String tokenContent = JSON.json((Object)token.content);
        if (!LicenseUtils.verifySignature(Base64.decodeBase64((String)token.r1Pub), Base64.decodeBase64((String)token.r1Sig), tokenContent.getBytes("utf8"))) {
            throw new ApplicativeException("Invalid trial token", "Your trial token is not validly signed");
        }
    }
}

