/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.classpathfix.DKULongs;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class AccessLogRotation
implements Job {
    static DKULogger logger = DKULogger.getLogger((String)"dku.maint.logrotation");

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        logger.info((Object)"Rotating nginx access log");
        String iniVal = DKUApp.getIniValue("logs", "rotate_accesslog");
        if ("false".equals(iniVal)) {
            logger.info((Object)"disabled by configuration, aborting");
            return;
        }
        File accessLogFile = DKUApp.getFile("run", "nginx", "access.log");
        if (!accessLogFile.exists()) {
            logger.info((Object)("Access log file not found, doing nothing (" + String.valueOf(accessLogFile) + ")"));
        }
        try {
            Long p;
            String suffix = DKUDateUtils.isoFormatFileFriendlyLocalNow();
            File newLogFile = DKUApp.getFile("run", "nginx", "access-" + suffix + ".log");
            if (!accessLogFile.renameTo(newLogFile)) {
                throw new IOException("failed to move access log to " + String.valueOf(newLogFile));
            }
            logger.info((Object)("new log file " + String.valueOf(newLogFile) + " successfully created"));
            File dss = DKUApp.getFile("bin", "dss");
            DKUtils.execAndLogThrows((String[])new String[]{dss.getAbsolutePath(), "reopenlogs"}, null, (File)null);
            long purgeThreshold = 0x4000000L;
            String purgeThresholdStr = DKUApp.getIniValue("logs", "accesslog_purge_size");
            if (StringUtils.isNotBlank((String)purgeThresholdStr) && (p = DKULongs.tryParse((String)purgeThresholdStr)) != null && p > 0L) {
                purgeThreshold = p;
            }
            logger.info((Object)("Purging old logs (max size = " + purgeThreshold + ")"));
            File nginxDir = DKUApp.getFile("run", "nginx");
            DKUFileUtils.compressAndKeepLastFilesUpToSize((File)nginxDir, (String)"access-", (String)".log", (long)purgeThreshold, null);
            logger.info((Object)"Access log rotation done");
        }
        catch (Exception e) {
            logger.error((Object)"nginx access.log rotation failed", (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
    }
}

