/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SymetricCrypto {
    private static final byte[] X1_OBFUSCATION = new byte[]{-59, -109, 107, -117, 96, 28, -8, -111, -118, 111, 37, -63, 113, 105, 90, -64};
    private static final String X1_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String X1_PREFIX = "e:AES:X1:";
    private static final String X2_PREFIX = "e:AES:X2:";
    private static final String X2_ALGORITHM = "AES/CTR/NoPadding";
    private static final String X2_MAC = "HmacSHA256";
    private final Key key;
    private final Key hmacKey;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.config.crypto");

    public SymetricCrypto(byte[] keyBytes) {
        if (keyBytes != null) {
            logger.debug((Object)"Initializing config crypto");
            this.key = new SecretKeySpec(keyBytes, "AES");
            this.hmacKey = new SecretKeySpec(keyBytes, X2_MAC);
        } else {
            logger.debug((Object)"Not initializing config crypto (no key)");
            this.key = null;
            this.hmacKey = null;
        }
    }

    public String encrypt(String message) {
        try {
            if (this.key == null) {
                return message;
            }
            byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
            byte[] iv = SecretKeyGenerator.getRandomBytes(16);
            Cipher c = Cipher.getInstance(X2_ALGORITHM);
            c.init(1, this.key, new IvParameterSpec(iv));
            byte[] es = c.doFinal(messageBytes);
            Mac m = Mac.getInstance(X2_MAC);
            m.init(this.hmacKey);
            m.update(iv);
            byte[] hmac = m.doFinal(es);
            byte[] os = new byte[iv.length + es.length + hmac.length];
            System.arraycopy(iv, 0, os, 0, iv.length);
            System.arraycopy(es, 0, os, iv.length, es.length);
            System.arraycopy(hmac, 0, os, iv.length + es.length, hmac.length);
            return X2_PREFIX + Base64.encodeBase64String((byte[])os);
        }
        catch (Exception e) {
            throw new RuntimeException("Encryption failed", e);
        }
    }

    public String encryptIfNotEncrypted(String password) {
        if (this.key == null) {
            return password;
        }
        if (password == null) {
            return null;
        }
        if (password.startsWith(X1_PREFIX) || password.startsWith(X2_PREFIX)) {
            return password;
        }
        return this.encrypt(password);
    }

    public String decryptIfEncrypted(String message) {
        if (this.key == null) {
            return message;
        }
        try {
            if (message != null && message.startsWith(X1_PREFIX) && message.length() > X1_PREFIX.length()) {
                String realMessage = message.substring(X1_PREFIX.length());
                Cipher c = Cipher.getInstance(X1_ALGORITHM);
                c.init(2, this.key);
                byte[] decrypted = c.doFinal(Base64.decodeBase64((String)realMessage));
                byte[] unobfuscated = this.x1BlockXor(decrypted, X1_OBFUSCATION);
                return new String(unobfuscated, StandardCharsets.UTF_8);
            }
            if (message != null && message.startsWith(X2_PREFIX) && message.length() > X2_PREFIX.length()) {
                String realMessage = message.substring(X2_PREFIX.length());
                byte[] messageBytes = Base64.decodeBase64((String)realMessage);
                byte[] iv = Arrays.copyOfRange(messageBytes, 0, 16);
                byte[] es = Arrays.copyOfRange(messageBytes, 16, messageBytes.length - 32);
                byte[] hmac = Arrays.copyOfRange(messageBytes, messageBytes.length - 32, messageBytes.length);
                Mac m = Mac.getInstance(X2_MAC);
                m.init(this.hmacKey);
                m.update(iv);
                byte[] expectedHmac = m.doFinal(es);
                if (!MessageDigest.isEqual(hmac, expectedHmac)) {
                    throw new SecurityException("Invalid HMAC");
                }
                Cipher c = Cipher.getInstance(X2_ALGORITHM);
                c.init(2, this.key, new IvParameterSpec(iv));
                byte[] decrypted = c.doFinal(es);
                return new String(decrypted, StandardCharsets.UTF_8);
            }
            return message;
        }
        catch (Exception e) {
            throw new CodedRuntimeException(SecurityCodes.ERR_SECURITY_DECRYPTION_FAILED, e.getMessage());
        }
    }

    private byte[] x1BlockXor(byte[] msg, byte[] key) {
        byte[] out = new byte[msg.length];
        for (int i = 0; i < msg.length; ++i) {
            out[i] = (byte)(msg[i] ^ key[i % key.length]);
        }
        return out;
    }
}

