/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAuthenticationException;
import com.dataiku.dip.security.auth.UserCredentialsAuthenticator;
import com.dataiku.dip.security.auth.UserCredentialsAuthenticatorSettings;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.server.services.DkuUsersService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocalUserCredentialsAuthenticator
implements UserCredentialsAuthenticator {
    private final UserCredentialsAuthenticatorSettings userCredentialsAuthenticatorSettings = new UserCredentialsAuthenticatorSettings(){

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public Integer getOrder() {
            return this.getUserSourceType().getDefaultOrder();
        }

        @Override
        public boolean isAuthenticationEnabled() {
            return true;
        }

        @Override
        public UserSourceType getUserSourceType() {
            return UserSourceType.LOCAL;
        }

        @Override
        public Set<String> getAuthorizedGroups() {
            return Collections.emptySet();
        }
    };
    protected TransactionService transactionService;
    protected DkuUsersService usersService;

    @Autowired
    public LocalUserCredentialsAuthenticator(TransactionService transactionService, DkuUsersService usersService) {
        this.transactionService = transactionService;
        this.usersService = usersService;
    }

    @Override
    public UserCredentialsAuthenticatorSettings getAuthenticatorSettings() {
        return this.userCredentialsAuthenticatorSettings;
    }

    @Override
    public UserIdentity authenticate(String login, String password) throws ServerAuthenticationFailure, UserAuthenticationException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            if (!this.usersService.checkPassword(login, password)) {
                throw new UserAuthenticationException("Invalid password");
            }
        }
        catch (CodedException | IOException e) {
            throw new ServerAuthenticationFailure("Could not verify user local credentials", e);
        }
        return new UserIdentity(UserSourceType.LOCAL, login);
    }
}

