/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;

public class UserDiff {
    private static final List<String> OBFUSCATED_FIELDS = List.of("password", "credentials", "trialToken", "secrets");
    private JsonObject diff = new JsonObject();

    public JsonObject getDiff() {
        return this.diff;
    }

    public void addChange(String field, JsonElement oldValue, JsonElement newValue) {
        JsonObject change = new JsonObject();
        change.add("oldValue", oldValue);
        change.add("newValue", newValue);
        this.diff.add(field, (JsonElement)change);
    }

    public void addObfuscatedChange(String field) {
        JsonObject change = new JsonObject();
        change.add("oldValue", (JsonElement)new JsonPrimitive("xxxx"));
        change.add("newValue", (JsonElement)new JsonPrimitive("xxxx"));
        this.diff.add(field, (JsonElement)change);
    }

    public String toString() {
        return this.diff.toString();
    }

    public static UserDiff calculateDiff(JsonObject oldUser, JsonObject newUser) {
        String key;
        UserDiff userDiff = new UserDiff();
        for (Map.Entry entry : oldUser.entrySet()) {
            key = (String)entry.getKey();
            JsonElement oldValue = (JsonElement)entry.getValue();
            JsonElement newValue = newUser.get(key);
            if (newUser.has(key) && oldValue.equals(newValue)) continue;
            if (OBFUSCATED_FIELDS.contains(key)) {
                userDiff.addObfuscatedChange(key);
                continue;
            }
            userDiff.addChange(key, oldValue, newValue);
        }
        for (Map.Entry entry : newUser.entrySet()) {
            key = (String)entry.getKey();
            if (oldUser.has(key)) continue;
            if (OBFUSCATED_FIELDS.contains(key)) {
                userDiff.addObfuscatedChange(key);
                continue;
            }
            userDiff.addChange(key, null, (JsonElement)entry.getValue());
        }
        return userDiff;
    }
}

