/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.process;

import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.InheritableNDC;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public abstract class AbstractIsolableProcess
implements IsolableProcess {
    private final ProcessBuilder def;
    private final File runDir;
    private final Thread waitingThread;
    private Process p;
    private File linkedDirToCleanUp;
    private int pid = 0;
    private int returnCode = -1;
    private Chattiness chattiness = Chattiness.STARTING_AND_PID;
    private static Logger logger = Logger.getLogger((String)"dku.process");

    public void setChattiness(Chattiness chattiness) {
        this.chattiness = chattiness;
    }

    public AbstractIsolableProcess(ProcessBuilder def, File runDir) {
        this.def = def;
        this.runDir = runDir;
        this.waitingThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.currentThread().setName("RegularExec-" + Thread.currentThread().getId());
                    InheritableNDC.inheritNDC();
                    AbstractIsolableProcess.this.returnCode = AbstractIsolableProcess.this.p.waitFor();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Unexpected interruption!!!!", (Throwable)e);
                }
                finally {
                    if (AbstractIsolableProcess.this.linkedDirToCleanUp != null) {
                        logger.info((Object)("Deleting junction: " + AbstractIsolableProcess.this.linkedDirToCleanUp.getAbsolutePath()));
                        if (AbstractIsolableProcess.this.linkedDirToCleanUp.delete()) {
                            AbstractIsolableProcess.this.linkedDirToCleanUp = null;
                        } else {
                            logger.error((Object)("Failed to delete junction: " + AbstractIsolableProcess.this.linkedDirToCleanUp.getAbsolutePath()));
                        }
                    }
                }
            }
        };
    }

    @Override
    public void start() throws IOException {
        if (DKUtils.isOsWindows() && this.runDir != null && this.runDir.getAbsolutePath().length() > 250) {
            File shortPath = new File(System.getenv("DIP_HOME") + "/tmp/shortpath/");
            if (!shortPath.exists()) {
                shortPath.mkdirs();
            }
            boolean shouldCreateJunction = false;
            File linkedDir = new File(shortPath, SecretKeyGenerator.generate(12));
            if (linkedDir.exists()) {
                Path realPath = linkedDir.toPath().toRealPath(new LinkOption[0]);
                if (realPath.compareTo(this.runDir.toPath()) != 0) {
                    linkedDir.delete();
                    shouldCreateJunction = true;
                }
            } else {
                shouldCreateJunction = true;
            }
            if (shouldCreateJunction) {
                DKUtils.SmartLogTailBuilder logBuilder = new DKUtils.SmartLogTailBuilder();
                try {
                    logger.info((Object)("Creating junction: " + linkedDir.getAbsolutePath()));
                    DKUtils.execAndLogThrows((String[])new String[]{"cmd.exe", "/c", "mklink /J \"" + linkedDir.getAbsolutePath() + "\" \"" + this.runDir.getAbsolutePath() + "\""}, null, (DKUtils.SmartLogTailBuilder)logBuilder);
                    this.linkedDirToCleanUp = linkedDir;
                }
                catch (IOException | InterruptedException e) {
                    throw new IOException("An error occurred when trying to create a symbolic link: " + String.join((CharSequence)"\n", logBuilder.get().lines));
                }
            }
            this.def.directory(linkedDir);
        } else {
            this.def.directory(this.runDir);
        }
        if (this.chattiness != Chattiness.SILENT) {
            logger.info((Object)"Starting process (regular)");
        }
        this.p = this.def.start();
        this.pid = DKUtils.getPid((Process)this.p);
        if (this.chattiness != Chattiness.SILENT) {
            logger.info((Object)("Process started with pid=" + this.pid));
        }
        this.preStartHook(this.pid);
        this.waitingThread.start();
    }

    public abstract void preStartHook(int var1) throws IOException;

    @Override
    public int getWorkingPid() {
        return this.pid;
    }

    @Override
    public int getPidIfAvailable() {
        return this.pid;
    }

    @Override
    public void niceKill() throws IOException {
        DKUtils.niceKill((Process)this.p);
    }

    @Override
    public void evilKill() throws IOException {
        DKUtils.evilKill((Process)this.p);
    }

    @Override
    public void evilKillTree() throws IOException {
        DKUtils.killProcessTree((Process)this.p);
    }

    @Override
    public void evilKillWholeTree() throws IOException {
        DKUtils.evilKillWholeProcessTree((Process)this.p);
    }

    @Override
    public void niceThenEvilKill() throws IOException {
        if (this.isRunning()) {
            logger.info((Object)"Process is still running, sending SIGINT...");
            this.niceKill();
            try {
                this.waitFor(15000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)"Unexpected interruption", (Throwable)e);
            }
            if (this.isRunning()) {
                logger.info((Object)"Process is still running after 15000ms, sending SIGKILL...");
                this.evilKill();
                try {
                    this.waitFor(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Unexpected interruption", (Throwable)e);
                }
                if (this.isRunning()) {
                    logger.info((Object)"Process is still alive after SIGINT and SIGKILL. Too strong for us...");
                } else {
                    logger.info((Object)"Process has been abruptly killed. Cleanup may be incomplete.");
                }
            } else {
                logger.info((Object)"Process has been nicely interrupted!");
            }
        }
    }

    private boolean isRunning() {
        return this.waitingThread.isAlive();
    }

    public int waitFor(long timeout) throws InterruptedException {
        this.waitingThread.join(timeout);
        return this.returnCode;
    }

    @Override
    public int waitFor() throws InterruptedException {
        this.waitingThread.join();
        return this.returnCode;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.p.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.p.getInputStream();
    }

    @Override
    public InputStream getErrorStream() throws IOException {
        return this.p.getErrorStream();
    }

    public static enum Chattiness {
        SILENT,
        STARTING_AND_PID;

    }
}

