/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.sso;

import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAttributes;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserQueryFilter;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.auth.UserSupplier;
import com.dataiku.dip.security.auth.UserSupplierSettings;
import java.util.Set;

public class SSOUserSupplier
implements UserSupplier {
    protected SSOSettings ssoSettings;

    @Override
    public boolean canSyncOnDemand() {
        return false;
    }

    @Override
    public boolean canFetchUsers() {
        return false;
    }

    @Override
    public boolean canFetchGroups() {
        return false;
    }

    @Override
    public UserSupplierSettings getUserSupplierSettings() {
        return this.ssoSettings;
    }

    @Override
    public UserAttributes getUserAttributes(UserIdentity userIdentity) throws ServerAuthenticationFailure {
        if (userIdentity.sourceType != UserSourceType.LOCAL_NO_AUTH) {
            throw new ServerAuthenticationFailure("Unable to read a user of a different source type than SSO: " + String.valueOf((Object)userIdentity.sourceType));
        }
        return new UserAttributes(userIdentity);
    }

    @Override
    public Set<UserAttributes> fetchUsers(UserQueryFilter filter) throws ServerAuthenticationFailure {
        throw new ServerAuthenticationFailure("SSO supplier cannot fetch users");
    }

    @Override
    public Set<String> fetchGroups() throws ServerAuthenticationFailure {
        throw new ServerAuthenticationFailure("SSO supplier cannot fetch groups");
    }

    @Override
    public String getDefaultProfile() {
        return this.ssoSettings.defaultUserProfile;
    }
}

