/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InternalAPIKeysService {
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    private transient Collection<APIKey> tempInternalApiKeys = new HashSet<APIKey>();
    private final RelFile dataFile = RelFile.global("internal-apikeys.json");
    private long apiKeyFileTimestamp = 0L;
    private APIKeysFile apiKeysFile;
    static Logger logger = Logger.getLogger((String)"dip.services.apikeys");

    private APIKeysFile readAndDecrypt() throws IOException {
        TransactionRef tr = TransactionContext.retrieveRead();
        if (tr.isFile(this.dataFile)) {
            long lastModified = tr.getLastModified(this.dataFile);
            if (this.apiKeyFileTimestamp < lastModified) {
                this.apiKeyFileTimestamp = lastModified;
                this.apiKeysFile = tr.readObjectUnsafe(this.dataFile, APIKeysFile.class);
                if (this.apiKeysFile != null) {
                    this.apiKeysFile.keys.forEach(key -> {
                        key.key = this.passwordEncryptionService.decryptIfEncrypted(key.key);
                    });
                }
            }
            if (this.apiKeysFile == null) {
                this.apiKeysFile = new APIKeysFile();
            }
            return this.apiKeysFile;
        }
        this.apiKeyFileTimestamp = 0L;
        return new APIKeysFile();
    }

    private APIKey getKey(String key) {
        for (APIKey apiKey : this.list()) {
            if (!apiKey.key.equals(key)) continue;
            return apiKey;
        }
        return null;
    }

    public APIKey get(String key) {
        return this.getKey(key);
    }

    public synchronized APIKey createTmpKey(AuthCtx ctx) {
        APIKey internalKey = new APIKey();
        internalKey.createdOn = System.currentTimeMillis();
        internalKey.key = SecretKeyGenerator.generate(32);
        internalKey.associatedUser = ctx.getAssociatedDSSUser() != null ? ctx.getAssociatedDSSUser() : ctx.getDSSUserForImpersonation();
        this.tempInternalApiKeys.add(internalKey);
        return internalKey;
    }

    public synchronized void deleteTmpKey(APIKey key) {
        this.tempInternalApiKeys.remove(key);
    }

    public synchronized List<APIKey> list() {
        ArrayList<APIKey> internalAPIKeyList = new ArrayList<APIKey>();
        internalAPIKeyList.addAll(this.tempInternalApiKeys);
        try {
            internalAPIKeyList.addAll(this.readAndDecrypt().keys);
        }
        catch (IOException e) {
            logger.error((Object)("Error while reading internal-apikeys.json file: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        return internalAPIKeyList;
    }

    public static class APIKeysFile {
        List<APIKey> keys = new ArrayList<APIKey>();
    }

    public static class APIKey {
        public String key;
        public String associatedUser;
        public long createdOn;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof APIKey)) {
                return false;
            }
            APIKey apiKey = (APIKey)o;
            return this.createdOn == apiKey.createdOn && Objects.equals(this.key, apiKey.key) && Objects.equals(this.associatedUser, apiKey.associatedUser);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.associatedUser, this.createdOn);
        }
    }
}

