/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions;

import com.dataiku.dip.transactions.TransactionProvider;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.exception.ExceptionUtils;

public class TransactionDebugInfo {
    private final Thread startingThread = Thread.currentThread();
    public volatile TransactionProvider.TransactionState state = TransactionProvider.TransactionState.WAITING_START;
    public final long requestedTime = System.currentTimeMillis();
    public long startedTime;
    public long commitStartedTime;
    public long commitWaitStartTime;
    public long commitWaitDoneTime;
    public long endTime;
    private final Exception startupStackException;
    private final String startupStackStatic;
    public final String threadName = Thread.currentThread().getName() + " (" + Thread.currentThread().getId() + ")";

    public TransactionDebugInfo(@Nullable String fakeStack) {
        if (fakeStack == null) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                this.startupStackException = e;
                this.startupStackStatic = null;
            }
        } else {
            this.startupStackStatic = fakeStack;
            this.startupStackException = null;
        }
    }

    public String getStartupStackTrace() {
        return this.startupStackException == null ? this.startupStackStatic : ExceptionUtils.getStackTrace((Throwable)this.startupStackException);
    }

    public void emptyCommit() {
        this.commitWaitDoneTime = this.commitWaitStartTime = this.commitStartedTime;
    }

    public String getFormattedStackStrace() {
        if (!this.startingThread.isAlive()) {
            return "Starting thread is not running, cannot retrieve stacktrace of the thread currently using it.";
        }
        return Arrays.stream(this.startingThread.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining(System.lineSeparator()));
    }
}

