/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.WindowsUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;

public class RelFile
implements Comparable<RelFile> {
    private static final char INVALID_CHARACTER = '/';
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final RelFile ROOT = new RelFile(new String[0]);
    private final String[] pathElements;
    private int hashCode = 0;

    public static boolean isValidName(String filename) {
        return filename.length() <= 254 && !"..".equals(filename) && !".".equals(filename) && filename.indexOf(47) == -1 && !filename.isEmpty();
    }

    public static String ensureValidName(String name) {
        if (RelFile.isValidName((String)name)) {
            return name;
        }
        if (".".equals(name) || "..".equals(name) || ((String)name).isEmpty()) {
            return "invalid-name";
        }
        if (((String)(name = ((String)name).replace('/', '_'))).length() > 254) {
            String hcode = Integer.toString(((String)name).hashCode());
            name = ((String)name).substring(0, 254 - hcode.length());
            name = (String)name + hcode;
        }
        return name;
    }

    public static void checkName(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("File has no name !");
        }
        if (DKUtils.isOsWindows() && !WindowsUtils.isFilenameValid((String)filename)) {
            throw new IllegalArgumentException("'" + filename + "' is not a valid file/directory name on Windows.");
        }
        if (!RelFile.isValidName(filename)) {
            throw new IllegalArgumentException("\"" + filename + "\" is not a valid file/directory name (forbidden characters or too long)");
        }
    }

    public static void checkNames(Iterable<String> filenames) {
        for (String filename : filenames) {
            RelFile.checkName(filename);
        }
    }

    public static void checkNames(String[] filenames) {
        for (String filename : filenames) {
            RelFile.checkName(filename);
        }
    }

    public static RelFile global(String path) {
        return new RelFile(path);
    }

    public RelFile(RelFile file) {
        this.pathElements = file.pathElements;
    }

    public RelFile(RelFile file, String ... elements) {
        RelFile.checkNames(elements);
        this.pathElements = new String[file.pathElements.length + elements.length];
        System.arraycopy(file.pathElements, 0, this.pathElements, 0, file.pathElements.length);
        System.arraycopy(elements, 0, this.pathElements, file.pathElements.length, elements.length);
    }

    public RelFile(List<String> elements) {
        RelFile.checkNames(elements);
        this.pathElements = elements.toArray(new String[0]);
    }

    public RelFile(String ... elements) {
        if (elements.length > 0) {
            RelFile.checkNames(elements);
            this.pathElements = (String[])elements.clone();
        } else {
            this.pathElements = EMPTY_ARRAY;
        }
    }

    private RelFile(boolean unsafe, String[] elements) {
        this.pathElements = elements;
    }

    public static RelFile root() {
        return ROOT;
    }

    public boolean isRoot() {
        return this.pathElements.length == 0;
    }

    public static RelFile fromPath(String path) {
        return new RelFile(RelFile.canonify(StringUtils.split((String)path, (String)"/")));
    }

    public RelFile getParent() {
        if (this.isRoot()) {
            return null;
        }
        return this.subPath(this.length() - 1);
    }

    public RelFile subPath(int currentIndex) {
        RelFile ret = currentIndex == 0 ? ROOT : (currentIndex == this.pathElements.length ? this : new RelFile(true, Arrays.copyOf(this.pathElements, currentIndex)));
        return ret;
    }

    public RelFile skipHead(int count) {
        if (count >= this.pathElements.length) {
            return ROOT;
        }
        if (count <= 0) {
            return this;
        }
        return new RelFile(true, Arrays.copyOfRange(this.pathElements, count, this.pathElements.length));
    }

    public boolean isAncestorOf(RelFile rf) {
        if (this.pathElements.length > rf.pathElements.length) {
            return false;
        }
        for (int i = this.pathElements.length - 1; i >= 0; --i) {
            if (this.pathElements[i].equals(rf.pathElements[i])) continue;
            return false;
        }
        return true;
    }

    private static List<String> canonify(String[] elements) {
        ArrayList<String> output = new ArrayList<String>();
        for (String element : elements) {
            if (element.isEmpty() || element.equals(".")) continue;
            if (element.equals("..")) {
                if (output.size() > 0) {
                    output.remove(output.size() - 1);
                    continue;
                }
                throw new IllegalArgumentException("Invalid path");
            }
            RelFile.checkName(element);
            output.add(element);
        }
        return output;
    }

    public String getLeafName() {
        if (this.pathElements.length > 0) {
            return this.pathElements[this.pathElements.length - 1];
        }
        return "";
    }

    public String getFullPath() {
        return StringUtils.join((Object[])this.pathElements, (String)"/");
    }

    public String toString() {
        return "/" + this.getFullPath();
    }

    public String[] getElements() {
        return this.pathElements;
    }

    public int length() {
        return this.pathElements.length;
    }

    public Iterable<RelFile> walk() {
        return this.walk(0, this.pathElements.length);
    }

    public Iterable<RelFile> walk(final int startIndex, final int endIndex) {
        boolean reverse;
        boolean bl = reverse = startIndex > endIndex;
        if (startIndex < 0 || startIndex > this.pathElements.length || endIndex < 0 || endIndex > this.pathElements.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new Iterable<RelFile>(){

            @Override
            public Iterator<RelFile> iterator() {
                return new Iterator<RelFile>(){
                    int currentIndex;
                    {
                        this.currentIndex = startIndex;
                    }

                    @Override
                    public boolean hasNext() {
                        return reverse ? this.currentIndex >= 0 : this.currentIndex <= endIndex;
                    }

                    @Override
                    public RelFile next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        RelFile ret = RelFile.this.subPath(this.currentIndex);
                        this.currentIndex = reverse ? --this.currentIndex : ++this.currentIndex;
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new NotImplementedException();
                    }
                };
            }
        };
    }

    public RelFile append(String ... elements) {
        return new RelFile(this, elements);
    }

    public RelFile appendStrictChildPath(String pathStr) {
        RelFile rf = this.appendPath_withoutDirectoryTraversalCheck(pathStr);
        if (!rf.isStrictChildOf(this)) {
            throw new IllegalArgumentException("\"" + pathStr + "\" is not a child of " + this.toString());
        }
        return rf;
    }

    public boolean isChildOf(RelFile parent) {
        return parent.isAncestorOf(this);
    }

    public boolean isParentOf(RelFile child) {
        if (child.pathElements.length != this.pathElements.length + 1) {
            return false;
        }
        for (int i = 0; i < this.pathElements.length; ++i) {
            if (this.pathElements[i].equals(child.pathElements[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictChildOf(RelFile parent) {
        return !this.equals(parent) && this.isChildOf(parent);
    }

    public RelFile appendPath_withoutDirectoryTraversalCheck(String pathStr) {
        if (pathStr == null) {
            throw new IllegalArgumentException("Null value supplied to build a file path");
        }
        ArrayList<String> elts = new ArrayList<String>();
        elts.addAll(Arrays.asList(this.pathElements));
        elts.addAll(Arrays.asList(StringUtils.split((String)pathStr, (String)"/")));
        return new RelFile(RelFile.canonify(elts.toArray(new String[0])));
    }

    public RelFile appendChildPath(String pathStr) {
        RelFile rf = this.appendPath_withoutDirectoryTraversalCheck(pathStr);
        if (!rf.isChildOf(this)) {
            throw new IllegalArgumentException("\"" + pathStr + "\" is not a child of " + this.toString());
        }
        return rf;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RelFile && Arrays.equals(this.pathElements, ((RelFile)obj).pathElements);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int acc = 1;
            for (String s : this.pathElements) {
                acc = acc * 127 + s.hashCode();
            }
            this.hashCode = acc;
        }
        return this.hashCode;
    }

    public File resolve(File root) {
        return new File(root, this.getFullPath());
    }

    @Override
    public int compareTo(RelFile other) {
        int minCount = Math.min(this.pathElements.length, other.pathElements.length);
        for (int i = 0; i < minCount; ++i) {
            int result = this.pathElements[i].compareTo(other.pathElements[i]);
            if (result == 0) continue;
            return result;
        }
        return this.pathElements.length - other.pathElements.length;
    }

    static {
        JSON.registerAdapter(RelFile.class, (Object)new JSON.Adapter<RelFile>(){

            public RelFile deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                return RelFile.fromPath(jsonElement.getAsJsonPrimitive().getAsString());
            }

            public JsonElement serialize(RelFile params, Type type, JsonSerializationContext ctx) {
                return new JsonPrimitive(params.getFullPath());
            }
        });
    }
}

