/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs.imfs;

import com.dataiku.dip.transactions.fs.BlackHoleFS;
import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.FileContentFactory;
import com.dataiku.dip.transactions.fs.Journal;
import com.dataiku.dip.transactions.fs.ReadWriteFSBase;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.commons.lang3.mutable.MutableObject;

public class InMemoryDiff
extends ReadWriteFSBase {
    private final ReadOnlyFS base;
    private final FileContentFactory fileContentFactory;
    static final Comparator<RelFile> comparator = new Comparator<RelFile>(){

        @Override
        public int compare(RelFile rf1, RelFile rf2) {
            boolean isEnd1 = rf1 instanceof EndMark;
            boolean isEnd2 = rf2 instanceof EndMark;
            if (!isEnd1 && !isEnd2) {
                return rf1.compareTo(rf2);
            }
            if (isEnd1 && rf1.isAncestorOf(rf2)) {
                return 1;
            }
            if (isEnd2 && rf2.isAncestorOf(rf1)) {
                return -1;
            }
            return rf1.compareTo(rf2);
        }
    };
    private TreeMap<RelFile, Node> diffMap = new TreeMap(comparator);

    public InMemoryDiff(ReadOnlyFS base, FileContentFactory fileContentFactory) {
        super(fileContentFactory);
        this.base = base;
        this.fileContentFactory = fileContentFactory;
    }

    public InMemoryDiff() {
        this(new BlackHoleFS());
    }

    public InMemoryDiff(ReadOnlyFS base) {
        this(base, FileContentFactory.DEFAULT);
    }

    public InMemoryDiff copy() {
        InMemoryDiff ret = new InMemoryDiff(this.base, this.fileContentFactory);
        ret.diffMap = new TreeMap<RelFile, Node>((SortedMap<RelFile, Node>)this.diffMap);
        return ret;
    }

    public Journal buildJournal() throws IOException {
        Journal journal = new Journal();
        for (Node node : this.diffMap.values()) {
            if (node.previousType == RelFileAttribute.FileType.DIRECTORY) {
                journal.deletedDirectories.add(node.file);
            } else if (node.previousType == RelFileAttribute.FileType.FILE && node.type != RelFileAttribute.FileType.FILE) {
                journal.deletedFiles.add(node.file);
            }
            if (!node.isWritten()) continue;
            switch (node.type) {
                case DIRECTORY: {
                    journal.createdDirectories.add(node.file);
                    break;
                }
                case FILE: {
                    Journal.WrittenFile wf = new Journal.WrittenFile(node.file, node.content);
                    journal.addWrittenFile(wf);
                }
            }
        }
        return journal;
    }

    @Override
    public boolean deleteFile(RelFile file) throws IOException {
        if (file.isRoot()) {
            return false;
        }
        Node prefix = this.longestPrefix(file);
        if (prefix != null) {
            if (!prefix.isWritten() || !prefix.file.equals(file)) {
                return true;
            }
            if (prefix.type != RelFileAttribute.FileType.FILE) {
                return false;
            }
            if (prefix.previousType == null) {
                this.diffMap.remove(prefix.file);
            } else {
                this.diffMap.put(file, Node.delete(file, prefix.previousType));
            }
            return true;
        }
        if (this.base.isFile(file)) {
            this.diffMap.put(file, Node.delete(file, RelFileAttribute.FileType.FILE));
            return true;
        }
        return !this.base.exists(file);
    }

    @Override
    public boolean deleteDirectory(RelFile directory) throws IOException {
        if (directory.isRoot()) {
            return false;
        }
        Node prefix = this.longestPrefix(directory);
        if (prefix != null) {
            if (!prefix.isWritten() || !prefix.file.equals(directory)) {
                return true;
            }
            if (prefix.type != RelFileAttribute.FileType.DIRECTORY) {
                return false;
            }
            this.removeDescendants(directory);
            if (prefix.previousType == null) {
                this.diffMap.remove(directory);
            } else {
                this.diffMap.put(directory, Node.delete(directory, prefix.previousType));
            }
        } else {
            if (this.base.isFile(directory)) {
                return false;
            }
            if (this.base.exists(directory)) {
                this.removeDescendants(directory);
                this.diffMap.put(directory, Node.delete(directory, RelFileAttribute.FileType.DIRECTORY));
            }
        }
        return true;
    }

    private void removeDescendants(RelFile directory) {
        Map.Entry entry;
        Iterator iterator = this.diffMap.tailMap(directory, false).entrySet().iterator();
        while (iterator.hasNext() && ((RelFile)(entry = iterator.next()).getKey()).isChildOf(directory)) {
            iterator.remove();
        }
    }

    @Override
    public boolean makeDirectory(RelFile directory) throws IOException {
        if (directory.isRoot()) {
            return true;
        }
        Node prefix = this.longestPrefix(directory);
        if (prefix != null) {
            if (prefix.type == RelFileAttribute.FileType.FILE) {
                return false;
            }
            if (prefix.type == null) {
                this.diffMap.put(prefix.file, Node.replaceWithDir(prefix.file, prefix.previousType));
            }
            if (prefix.file.equals(directory)) {
                return true;
            }
            for (RelFile current : directory.walk(prefix.file.length() + 1, directory.length())) {
                this.diffMap.put(current, Node.addDir(current));
            }
            return true;
        }
        ArrayList<Node> todo = new ArrayList<Node>(directory.length());
        for (RelFile current : directory.walk(directory.length(), 1)) {
            if (this.base.exists(current)) {
                if (this.base.isDirectory(current)) break;
                return false;
            }
            todo.add(Node.addDir(current));
        }
        for (Node n : todo) {
            this.diffMap.put(n.file, n);
        }
        return true;
    }

    @Nullable
    private Node longestPrefix(RelFile input) {
        RelFile key = input;
        while (!key.isRoot()) {
            Node node = this.diffMap.get(key);
            if (node != null) {
                return node;
            }
            key = key.getParent();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeContentUnsafeNoMkdir(RelFile file, FileContent content) throws IOException {
        if (file.isRoot()) {
            throw new IOException("The root is not a file");
        }
        Node prefix = this.longestPrefix(file);
        if (prefix != null) {
            if (prefix.file.equals(file)) {
                if (prefix.type == RelFileAttribute.FileType.DIRECTORY) {
                    throw new IOException("Cannot write file " + String.valueOf(file) + " because it's a directory");
                }
                if (prefix.previousType == null) {
                    this.diffMap.put(file, Node.addFile(file, content));
                    return;
                } else {
                    this.diffMap.put(file, Node.replaceWithFile(file, content, prefix.previousType));
                }
                return;
            } else {
                if (!prefix.isWritten() || !prefix.file.isParentOf(file) || !RelFileAttribute.FileType.DIRECTORY.equals((Object)prefix.type)) throw new IOException("Parent is not a directory: " + String.valueOf(file));
                this.diffMap.put(file, Node.addFile(file, content));
            }
            return;
        } else {
            if (!this.base.isDirectory(file.getParent())) {
                throw new IOException("Parent is not a directory: " + String.valueOf(file));
            }
            if (this.base.isDirectory(file)) {
                throw new IOException("Cannot write file " + String.valueOf(file) + " because it's a directory");
            }
            this.diffMap.put(file, this.base.isFile(file) ? Node.replaceWithFile(file, content, RelFileAttribute.FileType.FILE) : Node.addFile(file, content));
        }
    }

    @Override
    public List<RelFile> listFilesUnordered(RelFile directory) throws IOException {
        return this.listFilesImpl(directory, false);
    }

    @Override
    public List<RelFile> listFiles(RelFile directory) throws IOException {
        return this.listFilesImpl(directory, true);
    }

    private List<RelFile> listFilesImpl(RelFile directory, boolean ordered) throws IOException {
        Node prefix = this.longestPrefix(directory);
        if (prefix != null) {
            if (prefix.file.equals(directory) && RelFileAttribute.FileType.DIRECTORY.equals((Object)prefix.type)) {
                ArrayList<RelFile> output = new ArrayList<RelFile>();
                this.findDirectChildsOf(directory, node -> output.add(node.file));
                return output;
            }
            throw new IOException("Not a directory: " + String.valueOf(directory));
        }
        ArrayList baseListing = ordered ? this.base.listFiles(directory) : this.base.listFilesUnordered(directory);
        MutableObject setRef = new MutableObject(null);
        this.findDirectChildsOf(directory, node -> {
            TreeSet<RelFile> treeSet = (TreeSet<RelFile>)setRef.getValue();
            if (treeSet == null) {
                treeSet = new TreeSet<RelFile>(baseListing);
                setRef.setValue(treeSet);
            }
            if (node.isWritten()) {
                treeSet.add(node.file);
            } else {
                treeSet.remove(node.file);
            }
        });
        return setRef.getValue() == null ? baseListing : Lists.newArrayList((Iterable)((Iterable)setRef.getValue()));
    }

    private void findDirectChildsOf(RelFile directory, Consumer<Node> consumer) {
        NavigableMap<RelFile, Node> tailMap = this.diffMap.tailMap(directory, false);
        Iterator tailMapIterator = tailMap.entrySet().iterator();
        while (tailMapIterator.hasNext()) {
            Map.Entry entry = tailMapIterator.next();
            if (directory.isParentOf((RelFile)entry.getKey())) {
                consumer.accept((Node)entry.getValue());
                continue;
            }
            if (!((RelFile)entry.getKey()).isChildOf(directory)) break;
            RelFile dir = ((RelFile)entry.getKey()).getParent();
            while (!directory.isParentOf(dir)) {
                dir = dir.getParent();
            }
            tailMap = tailMap.tailMap(new EndMark(dir), false);
            tailMapIterator = tailMap.entrySet().iterator();
        }
    }

    @Override
    public FileContent readContentUnsafe(RelFile file) throws IOException {
        Node prefix = this.longestPrefix(file);
        if (prefix != null) {
            if (prefix.file.equals(file) && prefix.type == RelFileAttribute.FileType.FILE) {
                return prefix.content;
            }
            throw new IOException("Not a file: " + String.valueOf(file));
        }
        return this.base.readContentUnsafe(file);
    }

    @Override
    public RelFileAttribute getAttributes(RelFile file) throws IOException {
        if (file.isRoot()) {
            return this.base.getAttributes(file);
        }
        Node prefix = this.longestPrefix(file);
        if (prefix != null) {
            if (prefix.isWritten() && prefix.file.equals(file)) {
                return prefix;
            }
            return null;
        }
        return this.base.getAttributes(file);
    }

    @Override
    public void moveFile(RelFile src, RelFile dst) throws IOException {
        if (src == null) {
            throw new IOException("src is null");
        }
        if (dst == null) {
            throw new IOException("dst is null");
        }
        if (src.equals(dst)) {
            return;
        }
        if (dst.isStrictChildOf(src)) {
            throw new IOException("Cannot move '" + String.valueOf(src) + "' to '" + String.valueOf(dst) + "' because cannot copy directory in subdirectory");
        }
        InMemoryDiff tempDiff = this.copy();
        tempDiff.delete(dst);
        tempDiff.delete(src);
        FSUtils.newRecursiveCopy().from((ReadOnlyFS)this, src).to((ReadWriteFS)tempDiff, dst).copyMethod(FSUtils.COPY_FILE_CONTENT_REF).run();
        this.diffMap = tempDiff.diffMap;
    }

    private void delete(RelFile file) throws IOException {
        RelFileAttribute attributes = this.getAttributes(file);
        if (attributes != null) {
            switch (attributes.getFileType()) {
                case FILE: {
                    this.deleteFile(file);
                    break;
                }
                case DIRECTORY: {
                    this.deleteDirectory(file);
                }
            }
        }
    }

    @VisibleForTesting
    public void checkInvariants() {
        this.checkWrittenDirectoryDoesNotHaveDeletedChildren();
        this.checkDeletedDirectoryDoesNotHaveChildren();
    }

    private void checkWrittenDirectoryDoesNotHaveDeletedChildren() {
        for (Node parent : this.diffMap.values()) {
            if (!parent.isWritten()) continue;
            for (Node child : this.diffMap.values()) {
                if (!child.file.isStrictChildOf(parent.file) || child.isWritten()) continue;
                throw new RuntimeException(String.valueOf(parent.file) + " contain deleted child " + String.valueOf(child.file));
            }
        }
    }

    private void checkDeletedDirectoryDoesNotHaveChildren() {
        for (Node parent : this.diffMap.values()) {
            if (parent.type != null || parent.previousType != RelFileAttribute.FileType.DIRECTORY) continue;
            for (Node child : this.diffMap.values()) {
                if (!child.file.isStrictChildOf(parent.file)) continue;
                throw new RuntimeException("Deleted directory " + String.valueOf(parent.file) + " cannot contain deleted child " + String.valueOf(child.file));
            }
        }
    }

    static class Node
    implements RelFileAttribute {
        final RelFile file;
        final long lastModified;
        final FileContent content;
        final RelFileAttribute.FileType type;
        final RelFileAttribute.FileType previousType;

        private Node(RelFileAttribute.FileType type, RelFile file, FileContent content, RelFileAttribute.FileType previousType, long lastModified) {
            this.type = type;
            this.file = file;
            this.content = content;
            this.previousType = previousType;
            this.lastModified = lastModified;
        }

        static Node delete(RelFile path, RelFileAttribute.FileType previousType) {
            assert (previousType != null);
            return new Node(null, path, null, previousType, -1L);
        }

        static Node addFile(RelFile path, FileContent content) {
            assert (content != null);
            return new Node(RelFileAttribute.FileType.FILE, path, content, null, System.currentTimeMillis());
        }

        static Node replaceWithFile(RelFile path, FileContent content, RelFileAttribute.FileType previousType) {
            assert (content != null);
            assert (previousType != null);
            return new Node(RelFileAttribute.FileType.FILE, path, content, previousType, System.currentTimeMillis());
        }

        static Node addDir(RelFile path) {
            return new Node(RelFileAttribute.FileType.DIRECTORY, path, null, null, -1L);
        }

        static Node replaceWithDir(RelFile path, RelFileAttribute.FileType previousType) {
            assert (previousType != null);
            return new Node(RelFileAttribute.FileType.DIRECTORY, path, null, previousType, -1L);
        }

        boolean isWritten() {
            return this.type != null;
        }

        @Override
        public RelFile getFile() {
            return this.file;
        }

        @Override
        public RelFileAttribute.FileType getFileType() {
            return this.type;
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public long getLength() {
            return this.content == null ? -1L : this.content.getUncompressedLength();
        }
    }

    static class EndMark
    extends RelFile {
        public EndMark(RelFile rf) {
            super(rf);
        }
    }
}

